-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local log_helper = require 'infrastructure.log_helper'

Test_log_helper = {}

----------------Test_log_helper.dump_mdb_info----------------

function Test_log_helper:test_collection()
    local list = {[1] = 3, [2] = 3, [3] = 4}
    local cb = function(r, v)
        if r == v then
            return true
        end
    end
    local result = pcall(log_helper.parser_collection, list, cb, nil, 3)
    lu.assertEquals(result, true)
end

local mdb_obj = {
    names = {"obj_1"},
    props = {
        ["obj_1"] = 10
    }
}
function mdb_obj:get_all_prop_names()
    return self.names
end

function mdb_obj:get_prop(prop)
    return self.props[prop]
end

function Test_log_helper:test_dump_mdb_info_depth_over_3()
    local file = io.open("test_log_helper.txt", "w")
    local temp = pcall(log_helper.dump_mdb_info, mdb_obj, file, 4, "key")
    io.close(file)
    os.remove("test_log_helper.txt")
    lu.assertEquals(temp, true)
end

function Test_log_helper:test_dump_mdb_info_success()
    local file = io.open("test_log_helper.txt", "w")
    local temp = pcall(log_helper.dump_mdb_info, mdb_obj, file, 3, "key")
    io.close(file)
    os.remove("test_log_helper.txt")
    lu.assertEquals(temp, true)
end

function Test_log_helper:test_dump_mdb_info_not_names()
    local file = io.open("test_log_helper.txt", "w")
    local temp_obj = mdb_obj
    temp_obj.get_all_prop_names = nil
    local temp = pcall(log_helper.dump_mdb_info, temp_obj, file, 3, "key")
    io.close(file)
    os.remove("test_log_helper.txt")
    lu.assertEquals(temp, true)
end

----------------------Test_get_conn_info----------------------

local obj = {
    ports = {
        {
            name = 'port1',
            status = 'ok',
            target_unit_uid = 1,
            target_unit_index = 1,
            target_unit_port_id = 1
        },
        {
            name = 'port2'
        }
    },
    configs = {
        {
            ['uid'] = 10,
            ['index'] = 10
        }
    },
    get_prop = function (param)
        return param
    end
}

local port_map = {
    ['port1'] = true
}

function Test_log_helper:test_get_not_dump_cable_info()
    local obj = false
    local file = io.open("test_log_helper.txt", "w")
    local temp = pcall(log_helper.dump_cable_info, obj, file, 1, port_map)
    io.close(file)
    os.remove("test_log_helper.txt")
    lu.assertEquals(temp, true)
end

function Test_log_helper:test_get_dump_cable_info_type_1()
    local file = io.open("test_log_helper.txt", "w")
    local temp = pcall(log_helper.dump_cable_info, obj, file, 1, port_map)
    io.close(file)
    os.remove("test_log_helper.txt")
    lu.assertEquals(temp, true)
end

function Test_log_helper:test_get_dump_cable_info_type_2()
    local file = io.open("test_log_helper.txt", "w")
    local temp = pcall(log_helper.dump_cable_info, obj, file, 2, port_map)
    io.close(file)
    os.remove("test_log_helper.txt")
    lu.assertEquals(temp, true)
end

