-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local Event = require 'infrastructure.event'
local client = require 'pcie_device.client'

TestEvent = {}

function TestEvent:setupClass()
    self.GetEventsEventsObject = client.GetEventsEventsObject
    self.event_obj = client.event_obj
end

function TestEvent:teardownClass()
    client.GetEventsEventsObject = TestEvent.GetEventsEventsObject
    client.event_obj = self.event_obj
end

function TestEvent:test_get_latest_alarm_list_not_EventsObject()
    Event.event_obj = nil
    client.GetEventsEventsObject = function ()
        return nil
    end
    local list = Event.get_latest_alarm_list()
    lu.assertEquals(list, false)
end

function TestEvent:test_get_latest_alarm_list_not_ok()
    Event.event_obj = nil
    local temp_express = {}
    temp_express.GetAlarmList_PACKED = function()
        return false, {}
    end
    client.GetEventsEventsObject = function ()
        return {pcall = temp_express}
    end
    local list = Event.get_latest_alarm_list()
    lu.assertEquals(list, false)
end

function TestEvent:test_get_latest_alarm_list_not_ret_list()
    Event.event_obj = nil
    local temp_express = {}
    temp_express.GetAlarmList_PACKED = function()
        return true, {}
    end
    client.GetEventsEventsObject = function ()
        return {pcall = temp_express}
    end
    local list = Event.get_latest_alarm_list()
    lu.assertEquals(list, false)
end

function TestEvent:test_get_latest_alarm_list_exist_list_but_not_content()
    Event.event_obj = nil
    local temp_express = {}
    temp_express.GetAlarmList_PACKED = function()
        return true, {
            EventList = {}
        }
    end
    client.GetEventsEventsObject = function ()
        return {pcall = temp_express}
    end
    local list = Event.get_latest_alarm_list()
    lu.assertEquals(list, {})
end

function TestEvent:test_get_latest_alarm_list_exist_list_and_have_content()
    Event.event_obj = nil
    local temp_express = {}
    temp_express.GetAlarmList_PACKED = function()
        return true, {
            EventList = {
                {
                    MappingTable = {
                        {
                            Key = 'end_flag',
                            Value = 0
                        }
                    }
                },
                {
                    MappingTable = {
                        {
                            Key = 'end_flag',
                            Value = 1
                        }
                    }
                }
            }
        }
    end
    client.GetEventsEventsObject = function ()
        return {pcall = temp_express}
    end
    local list = Event.get_latest_alarm_list()
    local text_express = {
        {end_flag = 0},
        {end_flag = 1}
    }
    lu.assertEquals(list, text_express)
end

function TestEvent:test_add_not_event()
    local param = 0
    client.GetEventsEventsObject = function ()
        return nil
    end
    local ok, _ = pcall(Event.generate_event, param)
    lu.assertEquals(ok, false)
end

function TestEvent:test_add_event_successfully()
    local param = 0
    local temp_express_event = {}
    local temp_express_event_obj = {}
    temp_express_event_obj.unpack = function()
        return '1'
    end
    temp_express_event.AddEvent_PACKED = function()
        return temp_express_event_obj
    end
    client.GetEventsEventsObject = function ()
        return temp_express_event
    end
    local ok, _ = pcall(Event.generate_event, param)
    lu.assertEquals(ok, true)
end

function TestEvent:test_add_event_fail()
    local param = 0
    local temp_express_event = {}
    local temp_express_event_obj = {}
    temp_express_event_obj.unpack = function()
        return '0'
    end
    temp_express_event.AddEvent_PACKED = function()
        return temp_express_event_obj
    end
    client.GetEventsEventsObject = function ()
        return temp_express_event
    end
    local ok, _ = pcall(Event.generate_event, param)
    lu.assertEquals(ok, false)
end