-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local lu = require 'luaunit'
local log_helper = require 'infrastructure.log_helper'
local c_business_connector = require 'biz_topo.class.business_connector'
local c_unit_configuration = require 'biz_topo.class.unit_configuration'
local signal = require 'mc.signal'
local mock_complete_signal = signal.new()
 
TestLogHelper= {}
 
local test_ieu_with_two_configs_data<const> = {
    biz_conn_data = {
        {Name = 'C4a', ID = 13, Offset = 0, Width = 8}, {Name = 'C5a', ID = 17, Offset = 8, Width = 8},
        {Name = 'A3a', ID = 9, Offset = 0, Width = 8}, {Name = 'A4a', ID = 34, Offset = 8, Width = 8}
    },
    unit_conf_data = {
        {
            slot_type = 'IEU',
            slot_number = 1,
            silk_text = 'IEUSlot1',
            configs = {
                {
                    UID = '00000001040302058031',
                    Index = 0,
                    BCUIndex = 1,
                    SrcPortName = {'C4a', 'C5a', 'A3a'},
                    TargetPortID = {17, 18, 49},
                    Slot = {1, 2, 3},
                    Device = {}
                }
            },
            Port1Status = ''
        }, {
            slot_type = 'IEU',
            slot_number = 1,
            silk_text = 'IEUSlot1',
            configs = {
                {
                    UID = '00000001040302058031',
                    Index = 0,
                    BCUIndex = 2,
                    SrcPortName = {'A4a', 'A3a'},
                    TargetPortID = {34, 33},
                    Slot = {5},
                    Device = {}
                }
            }
        }
    }
}
 
local function create_biz_conn_objs(test_data, bcu_index)
    local result = {}
    for _, d in pairs(test_data) do
        result[#result + 1] = c_business_connector.new({
            Ports = {d},
            BCUIndex = bcu_index
        }, 1, mock_complete_signal)
    end
    return result
end
 
local function create_unit_conf_objs(test_data)
    local result = {}
    for _, d in pairs(test_data) do
        result[#result + 1] = c_unit_configuration.new({
            ['bmc.kepler.Systems.UnitConfigError'] = {
                Port1LinkInfo = '', Port2LinkInfo = '',
                Port1Status = 0, Port2Status = 0},
            SlotType = d.slot_type,
            SlotNumber = d.slot_number,
            SlotSilkText = d.silk_text,
            Configurations = d.configs
        }, 1)
    end
    return result
end
 
function TestLogHelper:test_get_conn_info()
    local fp = {
        write = function()
            return
        end
    }
    local port_map = {}
 
    -- 模拟bcu的biz connector
    local conn_objs_1 = create_biz_conn_objs(test_ieu_with_two_configs_data.biz_conn_data, 1)
    local conn_objs_2 = create_biz_conn_objs(test_ieu_with_two_configs_data.biz_conn_data, 2)
    for _, conn in pairs(conn_objs_1) do
        log_helper.get_conn_info(fp, conn, port_map)
    end
    for _, conn in pairs(conn_objs_2) do
        log_helper.get_conn_info(fp, conn, port_map)
    end
    -- 模拟psr的unit configuration
    local unit_confs = create_unit_conf_objs(test_ieu_with_two_configs_data.unit_conf_data)
    for _, unit_config in pairs(unit_confs) do
        log_helper.get_unit_config_info(fp, unit_config)
    end
    
end