-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local collection_helper = require 'infrastructure.collection_helper'

TestCollection = {}

function TestCollection:test_collection()
    local list = {[1] = 3, [2] = 3, [3] = 4}
    local cb = function(r, v)
        if r == v then
            return true
        end
    end
    local result = collection_helper.for_each(list, cb, nil, nil, 3)
    lu.assertEquals(#result, 2)
    lu.assertEquals(result[1], true)
end
