-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local c_ipmi_channel_config = require 'biz_topo.class.ipmi_channel_config'
local cmn = require 'common'

TestIpmiChannel = {}

function TestIpmiChannel:test_channel()
    local maps = {
        [1] = {
            ["HostId"] = 1,
            ["Instance"] =  11
        },
        [2] = {
            ["HostId"] =  2,
            ["Instance"] =  13
        },
        [3] = {
            ["HostId"] =  3,
            ["Instance"] =  15
        },
        [4] = {
            ["HostId"] =  4,
            ["Instance"] =  17
        },
        [5] = {
            ["HostId"] =  5,
            ["Instance"] =  19
        },
        [6] = {
            ["HostId"] =  6,
            ["Instance"] =  21
        },
        [7] = {
            ["HostId"] =  7,
            ["Instance"] =  23
        },
        [8] = {
            ["HostId"] =  8,
            ["Instance"] =  25
        }
    }
    c_ipmi_channel_config.new({})
    c_ipmi_channel_config.new({Maps = {}})
    c_ipmi_channel_config.new({Maps = maps})
end

function TestIpmiChannel:test_cmn()
    cmn.generate_event()
    cmn.retry_func(50, 5, function()
    end)
end
    