-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local c_device_loader = require 'biz_topo.device_loader'
local c_load_info = require 'biz_topo.class.load_info'

TestDeviceLoader = {}

function TestDeviceLoader:test_parse_pcie_card_bdf_data()
    local data = '\x00\x00\x01\x01\x01\x01\x00\x00\x00\x00\x00\x01\x02\x02\x02'

    local pcie_card_info = c_device_loader.parse_pcie_card_bdf_data(data)
    -- PCIeSlot 1
    lu.assertEquals(pcie_card_info[1].bus_info.segment, 0)
    lu.assertEquals(pcie_card_info[1].bus_info.socket_id, 0)
    lu.assertEquals(pcie_card_info[1].bus_info.bus, 1)
    lu.assertEquals(pcie_card_info[1].bus_info.device, 1)
    lu.assertEquals(pcie_card_info[1].bus_info.func, 1)
    -- PCIeSlot 3
    lu.assertEquals(pcie_card_info[3].bus_info.segment, 0)
    lu.assertEquals(pcie_card_info[3].bus_info.socket_id, 1)
    lu.assertEquals(pcie_card_info[3].bus_info.bus, 2)
    lu.assertEquals(pcie_card_info[3].bus_info.device, 2)
    lu.assertEquals(pcie_card_info[3].bus_info.func, 2)
end

function TestDeviceLoader:test_get_pcie_vid_did_info()
    local bus = {
        call = function()
            return 0, '\x00\x07\xdb\x04\x01\x02\x03\x04'
        end
    }
    local pcie_info = {
        bus_info = {
            socket_id = 1,
            bus = 1,
            device = 1,
            func = 1
        }
    }
    c_device_loader.get_pcie_vid_did_info(1, bus, pcie_info)
end

function TestDeviceLoader:test_load_unload_device()
    local mock_device_load = {
        biz_topo = {
            get_mgmt_connector = function(...)
                return true, nil, {Presence = 1, LoadStatus = 0}
            end
        }
    }
    local load_info = {
        slot_id = 256
    }
    c_device_loader.load_unload_device(mock_device_load, load_info, _, _, _)
    
end