-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local class = require 'mc.class'

---@class LoadInfo @设备加载信息
---@field public type string @设备类型
---@field public slot_id number @槽位号
---@field public id number
---@field public aux_id number
---@field public vid number @厂商ID
---@field public did number @设备ID
---@field public sub_vid number @子厂商ID
---@field public sub_did number @子设备ID
---@field public bus_info BusInfo @设备总线信息
local c_load_info = class()

function c_load_info:ctor(type, slot_id, id, aux_id, bus_info)
    self.type = type
    self.slot_id = slot_id
    self.id = id
    self.aux_id = aux_id
    ---@class BusInfo @总线信息
    ---@field public segment number
    ---@field public socket_id number
    ---@field public bus number @Device Bus号（非root）
    ---@field public device number @Device Device号
    ---@field public func number @Deivce Function号
    self.bus_info = {
        segment = bus_info and bus_info[1],
        socket_id = bus_info and bus_info[2],
        bus = bus_info and bus_info[3],
        device = bus_info and bus_info[4],
        func = bus_info and bus_info[5]
    }
end

return c_load_info