-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PCIeDevices = {}

---@class PCIeDevices.SetLinkSpeedReducedRsp
---@field Status integer
local TSetLinkSpeedReducedRsp = {}
TSetLinkSpeedReducedRsp.__index = TSetLinkSpeedReducedRsp
TSetLinkSpeedReducedRsp.group = {}

local function TSetLinkSpeedReducedRsp_from_obj(obj)
    return setmetatable(obj, TSetLinkSpeedReducedRsp)
end

function TSetLinkSpeedReducedRsp.new(Status)
    return TSetLinkSpeedReducedRsp_from_obj({Status = Status})
end
---@param obj PCIeDevices.SetLinkSpeedReducedRsp
function TSetLinkSpeedReducedRsp:init_from_obj(obj)
    self.Status = obj.Status
end

function TSetLinkSpeedReducedRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLinkSpeedReducedRsp.group)
end

TSetLinkSpeedReducedRsp.from_obj = TSetLinkSpeedReducedRsp_from_obj

TSetLinkSpeedReducedRsp.proto_property = {'Status'}

TSetLinkSpeedReducedRsp.default = {0}

TSetLinkSpeedReducedRsp.struct = {{name = 'Status', is_array = false, struct = nil}}

function TSetLinkSpeedReducedRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TSetLinkSpeedReducedRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLinkSpeedReducedRsp.proto_property, errs, need_convert)
    return self
end

function TSetLinkSpeedReducedRsp:unpack(_)
    return self.Status
end

PCIeDevices.SetLinkSpeedReducedRsp = TSetLinkSpeedReducedRsp

---@class PCIeDevices.SetLinkSpeedReducedReq
---@field Segment integer
---@field Bus integer
---@field Device integer
---@field Function integer
---@field Value integer
local TSetLinkSpeedReducedReq = {}
TSetLinkSpeedReducedReq.__index = TSetLinkSpeedReducedReq
TSetLinkSpeedReducedReq.group = {}

local function TSetLinkSpeedReducedReq_from_obj(obj)
    return setmetatable(obj, TSetLinkSpeedReducedReq)
end

function TSetLinkSpeedReducedReq.new(Segment, Bus, Device, Function, Value)
    return TSetLinkSpeedReducedReq_from_obj({
        Segment = Segment,
        Bus = Bus,
        Device = Device,
        Function = Function,
        Value = Value
    })
end
---@param obj PCIeDevices.SetLinkSpeedReducedReq
function TSetLinkSpeedReducedReq:init_from_obj(obj)
    self.Segment = obj.Segment
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
    self.Value = obj.Value
end

function TSetLinkSpeedReducedReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLinkSpeedReducedReq.group)
end

TSetLinkSpeedReducedReq.from_obj = TSetLinkSpeedReducedReq_from_obj

TSetLinkSpeedReducedReq.proto_property = {'Segment', 'Bus', 'Device', 'Function', 'Value'}

TSetLinkSpeedReducedReq.default = {0, 0, 0, 0, 0}

TSetLinkSpeedReducedReq.struct = {
    {name = 'Segment', is_array = false, struct = nil}, {name = 'Bus', is_array = false, struct = nil},
    {name = 'Device', is_array = false, struct = nil}, {name = 'Function', is_array = false, struct = nil},
    {name = 'Value', is_array = false, struct = nil}
}

function TSetLinkSpeedReducedReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Segment', self.Segment, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Bus', self.Bus, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Device', self.Device, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Function', self.Function, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Value', self.Value, 'uint8', false, errs, need_convert)

    TSetLinkSpeedReducedReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLinkSpeedReducedReq.proto_property, errs, need_convert)
    return self
end

function TSetLinkSpeedReducedReq:unpack(_)
    return self.Segment, self.Bus, self.Device, self.Function, self.Value
end

PCIeDevices.SetLinkSpeedReducedReq = TSetLinkSpeedReducedReq

---@class PCIeDevices.SetFaultByBiosRsp
---@field Status integer
local TSetFaultByBiosRsp = {}
TSetFaultByBiosRsp.__index = TSetFaultByBiosRsp
TSetFaultByBiosRsp.group = {}

local function TSetFaultByBiosRsp_from_obj(obj)
    return setmetatable(obj, TSetFaultByBiosRsp)
end

function TSetFaultByBiosRsp.new(Status)
    return TSetFaultByBiosRsp_from_obj({Status = Status})
end
---@param obj PCIeDevices.SetFaultByBiosRsp
function TSetFaultByBiosRsp:init_from_obj(obj)
    self.Status = obj.Status
end

function TSetFaultByBiosRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFaultByBiosRsp.group)
end

TSetFaultByBiosRsp.from_obj = TSetFaultByBiosRsp_from_obj

TSetFaultByBiosRsp.proto_property = {'Status'}

TSetFaultByBiosRsp.default = {0}

TSetFaultByBiosRsp.struct = {{name = 'Status', is_array = false, struct = nil}}

function TSetFaultByBiosRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TSetFaultByBiosRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFaultByBiosRsp.proto_property, errs, need_convert)
    return self
end

function TSetFaultByBiosRsp:unpack(_)
    return self.Status
end

PCIeDevices.SetFaultByBiosRsp = TSetFaultByBiosRsp

---@class PCIeDevices.SetFaultByBiosReq
---@field Bus integer
---@field Device integer
---@field Function integer
---@field FaultStatus integer
local TSetFaultByBiosReq = {}
TSetFaultByBiosReq.__index = TSetFaultByBiosReq
TSetFaultByBiosReq.group = {}

local function TSetFaultByBiosReq_from_obj(obj)
    return setmetatable(obj, TSetFaultByBiosReq)
end

function TSetFaultByBiosReq.new(Bus, Device, Function, FaultStatus)
    return TSetFaultByBiosReq_from_obj({Bus = Bus, Device = Device, Function = Function, FaultStatus = FaultStatus})
end
---@param obj PCIeDevices.SetFaultByBiosReq
function TSetFaultByBiosReq:init_from_obj(obj)
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
    self.FaultStatus = obj.FaultStatus
end

function TSetFaultByBiosReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFaultByBiosReq.group)
end

TSetFaultByBiosReq.from_obj = TSetFaultByBiosReq_from_obj

TSetFaultByBiosReq.proto_property = {'Bus', 'Device', 'Function', 'FaultStatus'}

TSetFaultByBiosReq.default = {0, 0, 0, 0}

TSetFaultByBiosReq.struct = {
    {name = 'Bus', is_array = false, struct = nil}, {name = 'Device', is_array = false, struct = nil},
    {name = 'Function', is_array = false, struct = nil}, {name = 'FaultStatus', is_array = false, struct = nil}
}

function TSetFaultByBiosReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Bus', self.Bus, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Device', self.Device, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Function', self.Function, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FaultStatus', self.FaultStatus, 'uint8', false, errs, need_convert)

    TSetFaultByBiosReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFaultByBiosReq.proto_property, errs, need_convert)
    return self
end

function TSetFaultByBiosReq:unpack(_)
    return self.Bus, self.Device, self.Function, self.FaultStatus
end

PCIeDevices.SetFaultByBiosReq = TSetFaultByBiosReq

---@class PCIeDevices.GetPCIeCardNumRsp
---@field PCIeCardNum integer
local TGetPCIeCardNumRsp = {}
TGetPCIeCardNumRsp.__index = TGetPCIeCardNumRsp
TGetPCIeCardNumRsp.group = {}

local function TGetPCIeCardNumRsp_from_obj(obj)
    return setmetatable(obj, TGetPCIeCardNumRsp)
end

function TGetPCIeCardNumRsp.new(PCIeCardNum)
    return TGetPCIeCardNumRsp_from_obj({PCIeCardNum = PCIeCardNum})
end
---@param obj PCIeDevices.GetPCIeCardNumRsp
function TGetPCIeCardNumRsp:init_from_obj(obj)
    self.PCIeCardNum = obj.PCIeCardNum
end

function TGetPCIeCardNumRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPCIeCardNumRsp.group)
end

TGetPCIeCardNumRsp.from_obj = TGetPCIeCardNumRsp_from_obj

TGetPCIeCardNumRsp.proto_property = {'PCIeCardNum'}

TGetPCIeCardNumRsp.default = {0}

TGetPCIeCardNumRsp.struct = {{name = 'PCIeCardNum', is_array = false, struct = nil}}

function TGetPCIeCardNumRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PCIeCardNum', self.PCIeCardNum, 'uint32', false, errs, need_convert)

    TGetPCIeCardNumRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPCIeCardNumRsp.proto_property, errs, need_convert)
    return self
end

function TGetPCIeCardNumRsp:unpack(_)
    return self.PCIeCardNum
end

PCIeDevices.GetPCIeCardNumRsp = TGetPCIeCardNumRsp

---@class PCIeDevices.GetPCIeCardNumReq
local TGetPCIeCardNumReq = {}
TGetPCIeCardNumReq.__index = TGetPCIeCardNumReq
TGetPCIeCardNumReq.group = {}

local function TGetPCIeCardNumReq_from_obj(obj)
    return setmetatable(obj, TGetPCIeCardNumReq)
end

function TGetPCIeCardNumReq.new()
    return TGetPCIeCardNumReq_from_obj({})
end
---@param obj PCIeDevices.GetPCIeCardNumReq
function TGetPCIeCardNumReq:init_from_obj(obj)

end

function TGetPCIeCardNumReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPCIeCardNumReq.group)
end

TGetPCIeCardNumReq.from_obj = TGetPCIeCardNumReq_from_obj

TGetPCIeCardNumReq.proto_property = {}

TGetPCIeCardNumReq.default = {}

TGetPCIeCardNumReq.struct = {}

function TGetPCIeCardNumReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetPCIeCardNumReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPCIeCardNumReq.proto_property, errs, need_convert)
    return self
end

function TGetPCIeCardNumReq:unpack(_)
end

PCIeDevices.GetPCIeCardNumReq = TGetPCIeCardNumReq

---@class PCIeDevices.GetDeviceNameRsp
---@field Status integer
---@field DeviceName string
local TGetDeviceNameRsp = {}
TGetDeviceNameRsp.__index = TGetDeviceNameRsp
TGetDeviceNameRsp.group = {}

local function TGetDeviceNameRsp_from_obj(obj)
    return setmetatable(obj, TGetDeviceNameRsp)
end

function TGetDeviceNameRsp.new(Status, DeviceName)
    return TGetDeviceNameRsp_from_obj({Status = Status, DeviceName = DeviceName})
end
---@param obj PCIeDevices.GetDeviceNameRsp
function TGetDeviceNameRsp:init_from_obj(obj)
    self.Status = obj.Status
    self.DeviceName = obj.DeviceName
end

function TGetDeviceNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceNameRsp.group)
end

TGetDeviceNameRsp.from_obj = TGetDeviceNameRsp_from_obj

TGetDeviceNameRsp.proto_property = {'Status', 'DeviceName'}

TGetDeviceNameRsp.default = {0, ''}

TGetDeviceNameRsp.struct = {
    {name = 'Status', is_array = false, struct = nil}, {name = 'DeviceName', is_array = false, struct = nil}
}

function TGetDeviceNameRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceName', self.DeviceName, 'string', false, errs, need_convert)

    TGetDeviceNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceNameRsp.proto_property, errs, need_convert)
    return self
end

function TGetDeviceNameRsp:unpack(_)
    return self.Status, self.DeviceName
end

PCIeDevices.GetDeviceNameRsp = TGetDeviceNameRsp

---@class PCIeDevices.GetDeviceNameReq
---@field Segment integer
---@field SocketID integer
---@field Bus integer
---@field Device integer
---@field Function integer
local TGetDeviceNameReq = {}
TGetDeviceNameReq.__index = TGetDeviceNameReq
TGetDeviceNameReq.group = {}

local function TGetDeviceNameReq_from_obj(obj)
    return setmetatable(obj, TGetDeviceNameReq)
end

function TGetDeviceNameReq.new(Segment, SocketID, Bus, Device, Function)
    return TGetDeviceNameReq_from_obj({
        Segment = Segment,
        SocketID = SocketID,
        Bus = Bus,
        Device = Device,
        Function = Function
    })
end
---@param obj PCIeDevices.GetDeviceNameReq
function TGetDeviceNameReq:init_from_obj(obj)
    self.Segment = obj.Segment
    self.SocketID = obj.SocketID
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
end

function TGetDeviceNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceNameReq.group)
end

TGetDeviceNameReq.from_obj = TGetDeviceNameReq_from_obj

TGetDeviceNameReq.proto_property = {'Segment', 'SocketID', 'Bus', 'Device', 'Function'}

TGetDeviceNameReq.default = {0, 0, 0, 0, 0}

TGetDeviceNameReq.struct = {
    {name = 'Segment', is_array = false, struct = nil}, {name = 'SocketID', is_array = false, struct = nil},
    {name = 'Bus', is_array = false, struct = nil}, {name = 'Device', is_array = false, struct = nil},
    {name = 'Function', is_array = false, struct = nil}
}

function TGetDeviceNameReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Segment', self.Segment, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SocketID', self.SocketID, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Bus', self.Bus, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Device', self.Device, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Function', self.Function, 'uint8', false, errs, need_convert)

    TGetDeviceNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceNameReq.proto_property, errs, need_convert)
    return self
end

function TGetDeviceNameReq:unpack(_)
    return self.Segment, self.SocketID, self.Bus, self.Device, self.Function
end

PCIeDevices.GetDeviceNameReq = TGetDeviceNameReq

---@class PCIeDevices.SetPredictiveFaultRsp
---@field Status integer
local TSetPredictiveFaultRsp = {}
TSetPredictiveFaultRsp.__index = TSetPredictiveFaultRsp
TSetPredictiveFaultRsp.group = {}

local function TSetPredictiveFaultRsp_from_obj(obj)
    return setmetatable(obj, TSetPredictiveFaultRsp)
end

function TSetPredictiveFaultRsp.new(Status)
    return TSetPredictiveFaultRsp_from_obj({Status = Status})
end
---@param obj PCIeDevices.SetPredictiveFaultRsp
function TSetPredictiveFaultRsp:init_from_obj(obj)
    self.Status = obj.Status
end

function TSetPredictiveFaultRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPredictiveFaultRsp.group)
end

TSetPredictiveFaultRsp.from_obj = TSetPredictiveFaultRsp_from_obj

TSetPredictiveFaultRsp.proto_property = {'Status'}

TSetPredictiveFaultRsp.default = {0}

TSetPredictiveFaultRsp.struct = {{name = 'Status', is_array = false, struct = nil}}

function TSetPredictiveFaultRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TSetPredictiveFaultRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPredictiveFaultRsp.proto_property, errs, need_convert)
    return self
end

function TSetPredictiveFaultRsp:unpack(_)
    return self.Status
end

PCIeDevices.SetPredictiveFaultRsp = TSetPredictiveFaultRsp

---@class PCIeDevices.SetPredictiveFaultReq
---@field Segment integer
---@field SocketID integer
---@field Bus integer
---@field Device integer
---@field Function integer
---@field Value integer
local TSetPredictiveFaultReq = {}
TSetPredictiveFaultReq.__index = TSetPredictiveFaultReq
TSetPredictiveFaultReq.group = {}

local function TSetPredictiveFaultReq_from_obj(obj)
    return setmetatable(obj, TSetPredictiveFaultReq)
end

function TSetPredictiveFaultReq.new(Segment, SocketID, Bus, Device, Function, Value)
    return TSetPredictiveFaultReq_from_obj({
        Segment = Segment,
        SocketID = SocketID,
        Bus = Bus,
        Device = Device,
        Function = Function,
        Value = Value
    })
end
---@param obj PCIeDevices.SetPredictiveFaultReq
function TSetPredictiveFaultReq:init_from_obj(obj)
    self.Segment = obj.Segment
    self.SocketID = obj.SocketID
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
    self.Value = obj.Value
end

function TSetPredictiveFaultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPredictiveFaultReq.group)
end

TSetPredictiveFaultReq.from_obj = TSetPredictiveFaultReq_from_obj

TSetPredictiveFaultReq.proto_property = {'Segment', 'SocketID', 'Bus', 'Device', 'Function', 'Value'}

TSetPredictiveFaultReq.default = {0, 0, 0, 0, 0, 0}

TSetPredictiveFaultReq.struct = {
    {name = 'Segment', is_array = false, struct = nil}, {name = 'SocketID', is_array = false, struct = nil},
    {name = 'Bus', is_array = false, struct = nil}, {name = 'Device', is_array = false, struct = nil},
    {name = 'Function', is_array = false, struct = nil}, {name = 'Value', is_array = false, struct = nil}
}

function TSetPredictiveFaultReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Segment', self.Segment, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SocketID', self.SocketID, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Bus', self.Bus, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Device', self.Device, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Function', self.Function, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Value', self.Value, 'uint8', false, errs, need_convert)

    TSetPredictiveFaultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPredictiveFaultReq.proto_property, errs, need_convert)
    return self
end

function TSetPredictiveFaultReq:unpack(_)
    return self.Segment, self.SocketID, self.Bus, self.Device, self.Function, self.Value
end

PCIeDevices.SetPredictiveFaultReq = TSetPredictiveFaultReq

---@class PCIeDevices.SetDiagnosticFaultRsp
---@field Status integer
local TSetDiagnosticFaultRsp = {}
TSetDiagnosticFaultRsp.__index = TSetDiagnosticFaultRsp
TSetDiagnosticFaultRsp.group = {}

local function TSetDiagnosticFaultRsp_from_obj(obj)
    return setmetatable(obj, TSetDiagnosticFaultRsp)
end

function TSetDiagnosticFaultRsp.new(Status)
    return TSetDiagnosticFaultRsp_from_obj({Status = Status})
end
---@param obj PCIeDevices.SetDiagnosticFaultRsp
function TSetDiagnosticFaultRsp:init_from_obj(obj)
    self.Status = obj.Status
end

function TSetDiagnosticFaultRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDiagnosticFaultRsp.group)
end

TSetDiagnosticFaultRsp.from_obj = TSetDiagnosticFaultRsp_from_obj

TSetDiagnosticFaultRsp.proto_property = {'Status'}

TSetDiagnosticFaultRsp.default = {0}

TSetDiagnosticFaultRsp.struct = {{name = 'Status', is_array = false, struct = nil}}

function TSetDiagnosticFaultRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TSetDiagnosticFaultRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDiagnosticFaultRsp.proto_property, errs, need_convert)
    return self
end

function TSetDiagnosticFaultRsp:unpack(_)
    return self.Status
end

PCIeDevices.SetDiagnosticFaultRsp = TSetDiagnosticFaultRsp

---@class PCIeDevices.SetDiagnosticFaultReq
---@field Segment integer
---@field SocketID integer
---@field Bus integer
---@field Device integer
---@field Function integer
---@field Value integer
local TSetDiagnosticFaultReq = {}
TSetDiagnosticFaultReq.__index = TSetDiagnosticFaultReq
TSetDiagnosticFaultReq.group = {}

local function TSetDiagnosticFaultReq_from_obj(obj)
    return setmetatable(obj, TSetDiagnosticFaultReq)
end

function TSetDiagnosticFaultReq.new(Segment, SocketID, Bus, Device, Function, Value)
    return TSetDiagnosticFaultReq_from_obj({
        Segment = Segment,
        SocketID = SocketID,
        Bus = Bus,
        Device = Device,
        Function = Function,
        Value = Value
    })
end
---@param obj PCIeDevices.SetDiagnosticFaultReq
function TSetDiagnosticFaultReq:init_from_obj(obj)
    self.Segment = obj.Segment
    self.SocketID = obj.SocketID
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
    self.Value = obj.Value
end

function TSetDiagnosticFaultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDiagnosticFaultReq.group)
end

TSetDiagnosticFaultReq.from_obj = TSetDiagnosticFaultReq_from_obj

TSetDiagnosticFaultReq.proto_property = {'Segment', 'SocketID', 'Bus', 'Device', 'Function', 'Value'}

TSetDiagnosticFaultReq.default = {0, 0, 0, 0, 0, 0}

TSetDiagnosticFaultReq.struct = {
    {name = 'Segment', is_array = false, struct = nil}, {name = 'SocketID', is_array = false, struct = nil},
    {name = 'Bus', is_array = false, struct = nil}, {name = 'Device', is_array = false, struct = nil},
    {name = 'Function', is_array = false, struct = nil}, {name = 'Value', is_array = false, struct = nil}
}

function TSetDiagnosticFaultReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Segment', self.Segment, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SocketID', self.SocketID, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Bus', self.Bus, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Device', self.Device, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Function', self.Function, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Value', self.Value, 'uint8', false, errs, need_convert)

    TSetDiagnosticFaultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDiagnosticFaultReq.proto_property, errs, need_convert)
    return self
end

function TSetDiagnosticFaultReq:unpack(_)
    return self.Segment, self.SocketID, self.Bus, self.Device, self.Function, self.Value
end

PCIeDevices.SetDiagnosticFaultReq = TSetDiagnosticFaultReq

---@class PCIeDevices.SetUCEByBIOSRsp
---@field Status integer
local TSetUCEByBIOSRsp = {}
TSetUCEByBIOSRsp.__index = TSetUCEByBIOSRsp
TSetUCEByBIOSRsp.group = {}

local function TSetUCEByBIOSRsp_from_obj(obj)
    return setmetatable(obj, TSetUCEByBIOSRsp)
end

function TSetUCEByBIOSRsp.new(Status)
    return TSetUCEByBIOSRsp_from_obj({Status = Status})
end
---@param obj PCIeDevices.SetUCEByBIOSRsp
function TSetUCEByBIOSRsp:init_from_obj(obj)
    self.Status = obj.Status
end

function TSetUCEByBIOSRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetUCEByBIOSRsp.group)
end

TSetUCEByBIOSRsp.from_obj = TSetUCEByBIOSRsp_from_obj

TSetUCEByBIOSRsp.proto_property = {'Status'}

TSetUCEByBIOSRsp.default = {0}

TSetUCEByBIOSRsp.struct = {{name = 'Status', is_array = false, struct = nil}}

function TSetUCEByBIOSRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TSetUCEByBIOSRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetUCEByBIOSRsp.proto_property, errs, need_convert)
    return self
end

function TSetUCEByBIOSRsp:unpack(_)
    return self.Status
end

PCIeDevices.SetUCEByBIOSRsp = TSetUCEByBIOSRsp

---@class PCIeDevices.SetUCEByBIOSReq
---@field Segment integer
---@field Bus integer
---@field Device integer
---@field Function integer
---@field Value integer
local TSetUCEByBIOSReq = {}
TSetUCEByBIOSReq.__index = TSetUCEByBIOSReq
TSetUCEByBIOSReq.group = {}

local function TSetUCEByBIOSReq_from_obj(obj)
    return setmetatable(obj, TSetUCEByBIOSReq)
end

function TSetUCEByBIOSReq.new(Segment, Bus, Device, Function, Value)
    return
        TSetUCEByBIOSReq_from_obj({Segment = Segment, Bus = Bus, Device = Device, Function = Function, Value = Value})
end
---@param obj PCIeDevices.SetUCEByBIOSReq
function TSetUCEByBIOSReq:init_from_obj(obj)
    self.Segment = obj.Segment
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
    self.Value = obj.Value
end

function TSetUCEByBIOSReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetUCEByBIOSReq.group)
end

TSetUCEByBIOSReq.from_obj = TSetUCEByBIOSReq_from_obj

TSetUCEByBIOSReq.proto_property = {'Segment', 'Bus', 'Device', 'Function', 'Value'}

TSetUCEByBIOSReq.default = {0, 0, 0, 0, 0}

TSetUCEByBIOSReq.struct = {
    {name = 'Segment', is_array = false, struct = nil}, {name = 'Bus', is_array = false, struct = nil},
    {name = 'Device', is_array = false, struct = nil}, {name = 'Function', is_array = false, struct = nil},
    {name = 'Value', is_array = false, struct = nil}
}

function TSetUCEByBIOSReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Segment', self.Segment, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Bus', self.Bus, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Device', self.Device, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Function', self.Function, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Value', self.Value, 'uint8', false, errs, need_convert)

    TSetUCEByBIOSReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetUCEByBIOSReq.proto_property, errs, need_convert)
    return self
end

function TSetUCEByBIOSReq:unpack(_)
    return self.Segment, self.Bus, self.Device, self.Function, self.Value
end

PCIeDevices.SetUCEByBIOSReq = TSetUCEByBIOSReq

---@class PCIeDevices.SetBandwidthReductionRsp
---@field Status integer
local TSetBandwidthReductionRsp = {}
TSetBandwidthReductionRsp.__index = TSetBandwidthReductionRsp
TSetBandwidthReductionRsp.group = {}

local function TSetBandwidthReductionRsp_from_obj(obj)
    return setmetatable(obj, TSetBandwidthReductionRsp)
end

function TSetBandwidthReductionRsp.new(Status)
    return TSetBandwidthReductionRsp_from_obj({Status = Status})
end
---@param obj PCIeDevices.SetBandwidthReductionRsp
function TSetBandwidthReductionRsp:init_from_obj(obj)
    self.Status = obj.Status
end

function TSetBandwidthReductionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBandwidthReductionRsp.group)
end

TSetBandwidthReductionRsp.from_obj = TSetBandwidthReductionRsp_from_obj

TSetBandwidthReductionRsp.proto_property = {'Status'}

TSetBandwidthReductionRsp.default = {0}

TSetBandwidthReductionRsp.struct = {{name = 'Status', is_array = false, struct = nil}}

function TSetBandwidthReductionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TSetBandwidthReductionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBandwidthReductionRsp.proto_property, errs, need_convert)
    return self
end

function TSetBandwidthReductionRsp:unpack(_)
    return self.Status
end

PCIeDevices.SetBandwidthReductionRsp = TSetBandwidthReductionRsp

---@class PCIeDevices.SetBandwidthReductionReq
---@field Segment integer
---@field Bus integer
---@field Device integer
---@field Function integer
---@field Value integer
local TSetBandwidthReductionReq = {}
TSetBandwidthReductionReq.__index = TSetBandwidthReductionReq
TSetBandwidthReductionReq.group = {}

local function TSetBandwidthReductionReq_from_obj(obj)
    return setmetatable(obj, TSetBandwidthReductionReq)
end

function TSetBandwidthReductionReq.new(Segment, Bus, Device, Function, Value)
    return TSetBandwidthReductionReq_from_obj({
        Segment = Segment,
        Bus = Bus,
        Device = Device,
        Function = Function,
        Value = Value
    })
end
---@param obj PCIeDevices.SetBandwidthReductionReq
function TSetBandwidthReductionReq:init_from_obj(obj)
    self.Segment = obj.Segment
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
    self.Value = obj.Value
end

function TSetBandwidthReductionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBandwidthReductionReq.group)
end

TSetBandwidthReductionReq.from_obj = TSetBandwidthReductionReq_from_obj

TSetBandwidthReductionReq.proto_property = {'Segment', 'Bus', 'Device', 'Function', 'Value'}

TSetBandwidthReductionReq.default = {0, 0, 0, 0, 0}

TSetBandwidthReductionReq.struct = {
    {name = 'Segment', is_array = false, struct = nil}, {name = 'Bus', is_array = false, struct = nil},
    {name = 'Device', is_array = false, struct = nil}, {name = 'Function', is_array = false, struct = nil},
    {name = 'Value', is_array = false, struct = nil}
}

function TSetBandwidthReductionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Segment', self.Segment, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Bus', self.Bus, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Device', self.Device, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Function', self.Function, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Value', self.Value, 'uint8', false, errs, need_convert)

    TSetBandwidthReductionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBandwidthReductionReq.proto_property, errs, need_convert)
    return self
end

function TSetBandwidthReductionReq:unpack(_)
    return self.Segment, self.Bus, self.Device, self.Function, self.Value
end

PCIeDevices.SetBandwidthReductionReq = TSetBandwidthReductionReq

---@class PCIeDevices.SetPcieErrorStatusRsp
---@field Status integer
local TSetPcieErrorStatusRsp = {}
TSetPcieErrorStatusRsp.__index = TSetPcieErrorStatusRsp
TSetPcieErrorStatusRsp.group = {}

local function TSetPcieErrorStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetPcieErrorStatusRsp)
end

function TSetPcieErrorStatusRsp.new(Status)
    return TSetPcieErrorStatusRsp_from_obj({Status = Status})
end
---@param obj PCIeDevices.SetPcieErrorStatusRsp
function TSetPcieErrorStatusRsp:init_from_obj(obj)
    self.Status = obj.Status
end

function TSetPcieErrorStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPcieErrorStatusRsp.group)
end

TSetPcieErrorStatusRsp.from_obj = TSetPcieErrorStatusRsp_from_obj

TSetPcieErrorStatusRsp.proto_property = {'Status'}

TSetPcieErrorStatusRsp.default = {0}

TSetPcieErrorStatusRsp.struct = {{name = 'Status', is_array = false, struct = nil}}

function TSetPcieErrorStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TSetPcieErrorStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPcieErrorStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetPcieErrorStatusRsp:unpack(_)
    return self.Status
end

PCIeDevices.SetPcieErrorStatusRsp = TSetPcieErrorStatusRsp

---@class PCIeDevices.SetPcieErrorStatusReq
---@field Segment integer
---@field SocketID integer
---@field Bus integer
---@field Device integer
---@field Function integer
---@field ErrorType string
---@field Value integer
local TSetPcieErrorStatusReq = {}
TSetPcieErrorStatusReq.__index = TSetPcieErrorStatusReq
TSetPcieErrorStatusReq.group = {}

local function TSetPcieErrorStatusReq_from_obj(obj)
    return setmetatable(obj, TSetPcieErrorStatusReq)
end

function TSetPcieErrorStatusReq.new(Segment, SocketID, Bus, Device, Function, ErrorType, Value)
    return TSetPcieErrorStatusReq_from_obj({
        Segment = Segment,
        SocketID = SocketID,
        Bus = Bus,
        Device = Device,
        Function = Function,
        ErrorType = ErrorType,
        Value = Value
    })
end
---@param obj PCIeDevices.SetPcieErrorStatusReq
function TSetPcieErrorStatusReq:init_from_obj(obj)
    self.Segment = obj.Segment
    self.SocketID = obj.SocketID
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
    self.ErrorType = obj.ErrorType
    self.Value = obj.Value
end

function TSetPcieErrorStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPcieErrorStatusReq.group)
end

TSetPcieErrorStatusReq.from_obj = TSetPcieErrorStatusReq_from_obj

TSetPcieErrorStatusReq.proto_property = {'Segment', 'SocketID', 'Bus', 'Device', 'Function', 'ErrorType', 'Value'}

TSetPcieErrorStatusReq.default = {0, 0, 0, 0, 0, '', 0}

TSetPcieErrorStatusReq.struct = {
    {name = 'Segment', is_array = false, struct = nil}, {name = 'SocketID', is_array = false, struct = nil},
    {name = 'Bus', is_array = false, struct = nil}, {name = 'Device', is_array = false, struct = nil},
    {name = 'Function', is_array = false, struct = nil}, {name = 'ErrorType', is_array = false, struct = nil},
    {name = 'Value', is_array = false, struct = nil}
}

function TSetPcieErrorStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Segment', self.Segment, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SocketID', self.SocketID, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Bus', self.Bus, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Device', self.Device, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Function', self.Function, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ErrorType', self.ErrorType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Value', self.Value, 'uint8', false, errs, need_convert)

    TSetPcieErrorStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPcieErrorStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetPcieErrorStatusReq:unpack(_)
    return self.Segment, self.SocketID, self.Bus, self.Device, self.Function, self.ErrorType, self.Value
end

PCIeDevices.SetPcieErrorStatusReq = TSetPcieErrorStatusReq

PCIeDevices.interface = mdb.register_interface('bmc.kepler.Systems.PCIeDevices', {}, {
    SetPcieErrorStatus = {'a{ss}yyyyysy', 'y', TSetPcieErrorStatusReq, TSetPcieErrorStatusRsp},
    SetBandwidthReduction = {'a{ss}yyyyy', 'y', TSetBandwidthReductionReq, TSetBandwidthReductionRsp},
    SetUCEByBIOS = {'a{ss}yyyyy', 'y', TSetUCEByBIOSReq, TSetUCEByBIOSRsp},
    SetDiagnosticFault = {'a{ss}yyyyyy', 'y', TSetDiagnosticFaultReq, TSetDiagnosticFaultRsp},
    SetPredictiveFault = {'a{ss}yyyyyy', 'y', TSetPredictiveFaultReq, TSetPredictiveFaultRsp},
    GetDeviceName = {'a{ss}yyyyy', 'ys', TGetDeviceNameReq, TGetDeviceNameRsp},
    GetPCIeCardNum = {'a{ss}', 'u', TGetPCIeCardNumReq, TGetPCIeCardNumRsp},
    SetFaultByBios = {'a{ss}yyyy', 'y', TSetFaultByBiosReq, TSetFaultByBiosRsp},
    SetLinkSpeedReduced = {'a{ss}yyyyy', 'y', TSetLinkSpeedReducedReq, TSetLinkSpeedReducedRsp}
}, {})

return PCIeDevices
