-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PCIeDevice = {}

---@class PCIeDevice.NegotiatedPCIeType
---@field NegotiatedPCIeType string
local TNegotiatedPCIeType = {}
TNegotiatedPCIeType.__index = TNegotiatedPCIeType
TNegotiatedPCIeType.group = {}

local function TNegotiatedPCIeType_from_obj(obj)
    return setmetatable(obj, TNegotiatedPCIeType)
end

function TNegotiatedPCIeType.new(NegotiatedPCIeType)
    return TNegotiatedPCIeType_from_obj({NegotiatedPCIeType = NegotiatedPCIeType})
end
---@param obj PCIeDevice.NegotiatedPCIeType
function TNegotiatedPCIeType:init_from_obj(obj)
    self.NegotiatedPCIeType = obj.NegotiatedPCIeType
end

function TNegotiatedPCIeType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNegotiatedPCIeType.group)
end

TNegotiatedPCIeType.from_obj = TNegotiatedPCIeType_from_obj

TNegotiatedPCIeType.proto_property = {'NegotiatedPCIeType'}

TNegotiatedPCIeType.default = {''}

TNegotiatedPCIeType.struct = {{name = 'NegotiatedPCIeType', is_array = false, struct = nil}}

function TNegotiatedPCIeType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NegotiatedPCIeType', self.NegotiatedPCIeType, 'string', true, errs, need_convert)

    if self.NegotiatedPCIeType ~= nil then
        validate.Enum(prefix .. 'NegotiatedPCIeType', self.NegotiatedPCIeType, '',
            {'Gen1', 'Gen2', 'Gen3', 'Gen4', 'Gen5', 'Gen6'}, errs, need_convert)
    end

    TNegotiatedPCIeType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNegotiatedPCIeType.proto_property, errs, need_convert)
    return self
end

function TNegotiatedPCIeType:unpack(_)
    return self.NegotiatedPCIeType
end

PCIeDevice.NegotiatedPCIeType = TNegotiatedPCIeType

---@class PCIeDevice.MaxPCIeType
---@field MaxPCIeType string
local TMaxPCIeType = {}
TMaxPCIeType.__index = TMaxPCIeType
TMaxPCIeType.group = {}

local function TMaxPCIeType_from_obj(obj)
    return setmetatable(obj, TMaxPCIeType)
end

function TMaxPCIeType.new(MaxPCIeType)
    return TMaxPCIeType_from_obj({MaxPCIeType = MaxPCIeType})
end
---@param obj PCIeDevice.MaxPCIeType
function TMaxPCIeType:init_from_obj(obj)
    self.MaxPCIeType = obj.MaxPCIeType
end

function TMaxPCIeType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxPCIeType.group)
end

TMaxPCIeType.from_obj = TMaxPCIeType_from_obj

TMaxPCIeType.proto_property = {'MaxPCIeType'}

TMaxPCIeType.default = {''}

TMaxPCIeType.struct = {{name = 'MaxPCIeType', is_array = false, struct = nil}}

function TMaxPCIeType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxPCIeType', self.MaxPCIeType, 'string', true, errs, need_convert)

    if self.MaxPCIeType ~= nil then
        validate.Enum(prefix .. 'MaxPCIeType', self.MaxPCIeType, '', {'Gen1', 'Gen2', 'Gen3', 'Gen4', 'Gen5', 'Gen6'},
            errs, need_convert)
    end

    TMaxPCIeType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxPCIeType.proto_property, errs, need_convert)
    return self
end

function TMaxPCIeType:unpack(_)
    return self.MaxPCIeType
end

PCIeDevice.MaxPCIeType = TMaxPCIeType

---@class PCIeDevice.ProgrammingInterface
---@field ProgrammingInterface integer
local TProgrammingInterface = {}
TProgrammingInterface.__index = TProgrammingInterface
TProgrammingInterface.group = {}

local function TProgrammingInterface_from_obj(obj)
    return setmetatable(obj, TProgrammingInterface)
end

function TProgrammingInterface.new(ProgrammingInterface)
    return TProgrammingInterface_from_obj({ProgrammingInterface = ProgrammingInterface})
end
---@param obj PCIeDevice.ProgrammingInterface
function TProgrammingInterface:init_from_obj(obj)
    self.ProgrammingInterface = obj.ProgrammingInterface
end

function TProgrammingInterface:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProgrammingInterface.group)
end

TProgrammingInterface.from_obj = TProgrammingInterface_from_obj

TProgrammingInterface.proto_property = {'ProgrammingInterface'}

TProgrammingInterface.default = {0}

TProgrammingInterface.struct = {{name = 'ProgrammingInterface', is_array = false, struct = nil}}

function TProgrammingInterface:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProgrammingInterface', self.ProgrammingInterface, 'uint8', true, errs, need_convert)

    TProgrammingInterface:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProgrammingInterface.proto_property, errs, need_convert)
    return self
end

function TProgrammingInterface:unpack(_)
    return self.ProgrammingInterface
end

PCIeDevice.ProgrammingInterface = TProgrammingInterface

---@class PCIeDevice.SubClassCode
---@field SubClassCode integer
local TSubClassCode = {}
TSubClassCode.__index = TSubClassCode
TSubClassCode.group = {}

local function TSubClassCode_from_obj(obj)
    return setmetatable(obj, TSubClassCode)
end

function TSubClassCode.new(SubClassCode)
    return TSubClassCode_from_obj({SubClassCode = SubClassCode})
end
---@param obj PCIeDevice.SubClassCode
function TSubClassCode:init_from_obj(obj)
    self.SubClassCode = obj.SubClassCode
end

function TSubClassCode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubClassCode.group)
end

TSubClassCode.from_obj = TSubClassCode_from_obj

TSubClassCode.proto_property = {'SubClassCode'}

TSubClassCode.default = {0}

TSubClassCode.struct = {{name = 'SubClassCode', is_array = false, struct = nil}}

function TSubClassCode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SubClassCode', self.SubClassCode, 'uint8', true, errs, need_convert)

    TSubClassCode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubClassCode.proto_property, errs, need_convert)
    return self
end

function TSubClassCode:unpack(_)
    return self.SubClassCode
end

PCIeDevice.SubClassCode = TSubClassCode

---@class PCIeDevice.BaseClassCode
---@field BaseClassCode integer
local TBaseClassCode = {}
TBaseClassCode.__index = TBaseClassCode
TBaseClassCode.group = {}

local function TBaseClassCode_from_obj(obj)
    return setmetatable(obj, TBaseClassCode)
end

function TBaseClassCode.new(BaseClassCode)
    return TBaseClassCode_from_obj({BaseClassCode = BaseClassCode})
end
---@param obj PCIeDevice.BaseClassCode
function TBaseClassCode:init_from_obj(obj)
    self.BaseClassCode = obj.BaseClassCode
end

function TBaseClassCode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBaseClassCode.group)
end

TBaseClassCode.from_obj = TBaseClassCode_from_obj

TBaseClassCode.proto_property = {'BaseClassCode'}

TBaseClassCode.default = {0}

TBaseClassCode.struct = {{name = 'BaseClassCode', is_array = false, struct = nil}}

function TBaseClassCode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BaseClassCode', self.BaseClassCode, 'uint8', true, errs, need_convert)

    TBaseClassCode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBaseClassCode.proto_property, errs, need_convert)
    return self
end

function TBaseClassCode:unpack(_)
    return self.BaseClassCode
end

PCIeDevice.BaseClassCode = TBaseClassCode

---@class PCIeDevice.PCIeDeviceType
---@field PCIeDeviceType string
local TPCIeDeviceType = {}
TPCIeDeviceType.__index = TPCIeDeviceType
TPCIeDeviceType.group = {}

local function TPCIeDeviceType_from_obj(obj)
    return setmetatable(obj, TPCIeDeviceType)
end

function TPCIeDeviceType.new(PCIeDeviceType)
    return TPCIeDeviceType_from_obj({PCIeDeviceType = PCIeDeviceType})
end
---@param obj PCIeDevice.PCIeDeviceType
function TPCIeDeviceType:init_from_obj(obj)
    self.PCIeDeviceType = obj.PCIeDeviceType
end

function TPCIeDeviceType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPCIeDeviceType.group)
end

TPCIeDeviceType.from_obj = TPCIeDeviceType_from_obj

TPCIeDeviceType.proto_property = {'PCIeDeviceType'}

TPCIeDeviceType.default = {''}

TPCIeDeviceType.struct = {{name = 'PCIeDeviceType', is_array = false, struct = nil}}

function TPCIeDeviceType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PCIeDeviceType', self.PCIeDeviceType, 'string', true, errs, need_convert)

    if self.PCIeDeviceType ~= nil then
        validate.Enum(prefix .. 'PCIeDeviceType', self.PCIeDeviceType, '',
            {'MultiFunction', 'Retimer', 'Simulated', 'SingleFunction'}, errs, need_convert)
    end

    TPCIeDeviceType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPCIeDeviceType.proto_property, errs, need_convert)
    return self
end

function TPCIeDeviceType:unpack(_)
    return self.PCIeDeviceType
end

PCIeDevice.PCIeDeviceType = TPCIeDeviceType

---@class PCIeDevice.PCIeType
---@field PCIeType string
local TPCIeType = {}
TPCIeType.__index = TPCIeType
TPCIeType.group = {}

local function TPCIeType_from_obj(obj)
    return setmetatable(obj, TPCIeType)
end

function TPCIeType.new(PCIeType)
    return TPCIeType_from_obj({PCIeType = PCIeType})
end
---@param obj PCIeDevice.PCIeType
function TPCIeType:init_from_obj(obj)
    self.PCIeType = obj.PCIeType
end

function TPCIeType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPCIeType.group)
end

TPCIeType.from_obj = TPCIeType_from_obj

TPCIeType.proto_property = {'PCIeType'}

TPCIeType.default = {''}

TPCIeType.struct = {{name = 'PCIeType', is_array = false, struct = nil}}

function TPCIeType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PCIeType', self.PCIeType, 'string', true, errs, need_convert)

    if self.PCIeType ~= nil then
        validate.Enum(prefix .. 'PCIeType', self.PCIeType, '', {'Gen1', 'Gen2', 'Gen3', 'Gen4', 'Gen5'}, errs,
            need_convert)
    end

    TPCIeType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPCIeType.proto_property, errs, need_convert)
    return self
end

function TPCIeType:unpack(_)
    return self.PCIeType
end

PCIeDevice.PCIeType = TPCIeType

---@class PCIeDevice.FunctionType
---@field FunctionType string
local TFunctionType = {}
TFunctionType.__index = TFunctionType
TFunctionType.group = {}

local function TFunctionType_from_obj(obj)
    return setmetatable(obj, TFunctionType)
end

function TFunctionType.new(FunctionType)
    return TFunctionType_from_obj({FunctionType = FunctionType})
end
---@param obj PCIeDevice.FunctionType
function TFunctionType:init_from_obj(obj)
    self.FunctionType = obj.FunctionType
end

function TFunctionType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFunctionType.group)
end

TFunctionType.from_obj = TFunctionType_from_obj

TFunctionType.proto_property = {'FunctionType'}

TFunctionType.default = {''}

TFunctionType.struct = {{name = 'FunctionType', is_array = false, struct = nil}}

function TFunctionType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FunctionType', self.FunctionType, 'string', true, errs, need_convert)

    if self.FunctionType ~= nil then
        validate.Enum(prefix .. 'FunctionType', self.FunctionType, '', {'Physical', 'Virtual'}, errs, need_convert)
    end

    TFunctionType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFunctionType.proto_property, errs, need_convert)
    return self
end

function TFunctionType:unpack(_)
    return self.FunctionType
end

PCIeDevice.FunctionType = TFunctionType

---@class PCIeDevice.FunctionProtocol
---@field FunctionProtocol string
local TFunctionProtocol = {}
TFunctionProtocol.__index = TFunctionProtocol
TFunctionProtocol.group = {}

local function TFunctionProtocol_from_obj(obj)
    return setmetatable(obj, TFunctionProtocol)
end

function TFunctionProtocol.new(FunctionProtocol)
    return TFunctionProtocol_from_obj({FunctionProtocol = FunctionProtocol})
end
---@param obj PCIeDevice.FunctionProtocol
function TFunctionProtocol:init_from_obj(obj)
    self.FunctionProtocol = obj.FunctionProtocol
end

function TFunctionProtocol:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFunctionProtocol.group)
end

TFunctionProtocol.from_obj = TFunctionProtocol_from_obj

TFunctionProtocol.proto_property = {'FunctionProtocol'}

TFunctionProtocol.default = {''}

TFunctionProtocol.struct = {{name = 'FunctionProtocol', is_array = false, struct = nil}}

function TFunctionProtocol:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FunctionProtocol', self.FunctionProtocol, 'string', true, errs, need_convert)

    if self.FunctionProtocol ~= nil then
        validate.Enum(prefix .. 'FunctionProtocol', self.FunctionProtocol, '', {'CXL', 'PCIe'}, errs, need_convert)
    end

    TFunctionProtocol:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFunctionProtocol.proto_property, errs, need_convert)
    return self
end

function TFunctionProtocol:unpack(_)
    return self.FunctionProtocol
end

PCIeDevice.FunctionProtocol = TFunctionProtocol

---@class PCIeDevice.SlotType
---@field SlotType string
local TSlotType = {}
TSlotType.__index = TSlotType
TSlotType.group = {}

local function TSlotType_from_obj(obj)
    return setmetatable(obj, TSlotType)
end

function TSlotType.new(SlotType)
    return TSlotType_from_obj({SlotType = SlotType})
end
---@param obj PCIeDevice.SlotType
function TSlotType:init_from_obj(obj)
    self.SlotType = obj.SlotType
end

function TSlotType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotType.group)
end

TSlotType.from_obj = TSlotType_from_obj

TSlotType.proto_property = {'SlotType'}

TSlotType.default = {''}

TSlotType.struct = {{name = 'SlotType', is_array = false, struct = nil}}

function TSlotType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlotType', self.SlotType, 'string', true, errs, need_convert)

    if self.SlotType ~= nil then
        validate.Enum(prefix .. 'SlotType', self.SlotType, '',
            {'FullLength', 'HalfLength', 'LowProfile', 'M2', 'Mini', 'OCP3Large', 'OCP3Small', 'OEM', 'U2'}, errs,
            need_convert)
    end

    TSlotType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotType.proto_property, errs, need_convert)
    return self
end

function TSlotType:unpack(_)
    return self.SlotType
end

PCIeDevice.SlotType = TSlotType

---@class PCIeDevice.FaultByBios
---@field FaultByBios integer
local TFaultByBios = {}
TFaultByBios.__index = TFaultByBios
TFaultByBios.group = {}

local function TFaultByBios_from_obj(obj)
    return setmetatable(obj, TFaultByBios)
end

function TFaultByBios.new(FaultByBios)
    return TFaultByBios_from_obj({FaultByBios = FaultByBios})
end
---@param obj PCIeDevice.FaultByBios
function TFaultByBios:init_from_obj(obj)
    self.FaultByBios = obj.FaultByBios
end

function TFaultByBios:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFaultByBios.group)
end

TFaultByBios.from_obj = TFaultByBios_from_obj

TFaultByBios.proto_property = {'FaultByBios'}

TFaultByBios.default = {0}

TFaultByBios.struct = {{name = 'FaultByBios', is_array = false, struct = nil}}

function TFaultByBios:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FaultByBios', self.FaultByBios, 'uint8', true, errs, need_convert)

    TFaultByBios:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFaultByBios.proto_property, errs, need_convert)
    return self
end

function TFaultByBios:unpack(_)
    return self.FaultByBios
end

PCIeDevice.FaultByBios = TFaultByBios

---@class PCIeDevice.Position
---@field Position string
local TPosition = {}
TPosition.__index = TPosition
TPosition.group = {}

local function TPosition_from_obj(obj)
    return setmetatable(obj, TPosition)
end

function TPosition.new(Position)
    return TPosition_from_obj({Position = Position})
end
---@param obj PCIeDevice.Position
function TPosition:init_from_obj(obj)
    self.Position = obj.Position
end

function TPosition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPosition.group)
end

TPosition.from_obj = TPosition_from_obj

TPosition.proto_property = {'Position'}

TPosition.default = {''}

TPosition.struct = {{name = 'Position', is_array = false, struct = nil}}

function TPosition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Position', self.Position, 'string', true, errs, need_convert)

    TPosition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPosition.proto_property, errs, need_convert)
    return self
end

function TPosition:unpack(_)
    return self.Position
end

PCIeDevice.Position = TPosition

---@class PCIeDevice.DeviceName
---@field DeviceName string
local TDeviceName = {}
TDeviceName.__index = TDeviceName
TDeviceName.group = {}

local function TDeviceName_from_obj(obj)
    return setmetatable(obj, TDeviceName)
end

function TDeviceName.new(DeviceName)
    return TDeviceName_from_obj({DeviceName = DeviceName})
end
---@param obj PCIeDevice.DeviceName
function TDeviceName:init_from_obj(obj)
    self.DeviceName = obj.DeviceName
end

function TDeviceName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceName.group)
end

TDeviceName.from_obj = TDeviceName_from_obj

TDeviceName.proto_property = {'DeviceName'}

TDeviceName.default = {''}

TDeviceName.struct = {{name = 'DeviceName', is_array = false, struct = nil}}

function TDeviceName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceName', self.DeviceName, 'string', true, errs, need_convert)

    TDeviceName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceName.proto_property, errs, need_convert)
    return self
end

function TDeviceName:unpack(_)
    return self.DeviceName
end

PCIeDevice.DeviceName = TDeviceName

---@class PCIeDevice.FunctionClass
---@field FunctionClass integer
local TFunctionClass = {}
TFunctionClass.__index = TFunctionClass
TFunctionClass.group = {}

local function TFunctionClass_from_obj(obj)
    return setmetatable(obj, TFunctionClass)
end

function TFunctionClass.new(FunctionClass)
    return TFunctionClass_from_obj({FunctionClass = FunctionClass})
end
---@param obj PCIeDevice.FunctionClass
function TFunctionClass:init_from_obj(obj)
    self.FunctionClass = obj.FunctionClass
end

function TFunctionClass:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFunctionClass.group)
end

TFunctionClass.from_obj = TFunctionClass_from_obj

TFunctionClass.proto_property = {'FunctionClass'}

TFunctionClass.default = {0}

TFunctionClass.struct = {{name = 'FunctionClass', is_array = false, struct = nil}}

function TFunctionClass:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FunctionClass', self.FunctionClass, 'uint8', true, errs, need_convert)

    TFunctionClass:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFunctionClass.proto_property, errs, need_convert)
    return self
end

function TFunctionClass:unpack(_)
    return self.FunctionClass
end

PCIeDevice.FunctionClass = TFunctionClass

---@class PCIeDevice.LinkSpeedReduced
---@field LinkSpeedReduced integer
local TLinkSpeedReduced = {}
TLinkSpeedReduced.__index = TLinkSpeedReduced
TLinkSpeedReduced.group = {}

local function TLinkSpeedReduced_from_obj(obj)
    return setmetatable(obj, TLinkSpeedReduced)
end

function TLinkSpeedReduced.new(LinkSpeedReduced)
    return TLinkSpeedReduced_from_obj({LinkSpeedReduced = LinkSpeedReduced})
end
---@param obj PCIeDevice.LinkSpeedReduced
function TLinkSpeedReduced:init_from_obj(obj)
    self.LinkSpeedReduced = obj.LinkSpeedReduced
end

function TLinkSpeedReduced:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkSpeedReduced.group)
end

TLinkSpeedReduced.from_obj = TLinkSpeedReduced_from_obj

TLinkSpeedReduced.proto_property = {'LinkSpeedReduced'}

TLinkSpeedReduced.default = {0}

TLinkSpeedReduced.struct = {{name = 'LinkSpeedReduced', is_array = false, struct = nil}}

function TLinkSpeedReduced:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkSpeedReduced', self.LinkSpeedReduced, 'uint8', true, errs, need_convert)

    TLinkSpeedReduced:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkSpeedReduced.proto_property, errs, need_convert)
    return self
end

function TLinkSpeedReduced:unpack(_)
    return self.LinkSpeedReduced
end

PCIeDevice.LinkSpeedReduced = TLinkSpeedReduced

---@class PCIeDevice.BandwidthReduction
---@field BandwidthReduction integer
local TBandwidthReduction = {}
TBandwidthReduction.__index = TBandwidthReduction
TBandwidthReduction.group = {}

local function TBandwidthReduction_from_obj(obj)
    return setmetatable(obj, TBandwidthReduction)
end

function TBandwidthReduction.new(BandwidthReduction)
    return TBandwidthReduction_from_obj({BandwidthReduction = BandwidthReduction})
end
---@param obj PCIeDevice.BandwidthReduction
function TBandwidthReduction:init_from_obj(obj)
    self.BandwidthReduction = obj.BandwidthReduction
end

function TBandwidthReduction:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBandwidthReduction.group)
end

TBandwidthReduction.from_obj = TBandwidthReduction_from_obj

TBandwidthReduction.proto_property = {'BandwidthReduction'}

TBandwidthReduction.default = {0}

TBandwidthReduction.struct = {{name = 'BandwidthReduction', is_array = false, struct = nil}}

function TBandwidthReduction:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BandwidthReduction', self.BandwidthReduction, 'uint8', true, errs, need_convert)

    TBandwidthReduction:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBandwidthReduction.proto_property, errs, need_convert)
    return self
end

function TBandwidthReduction:unpack(_)
    return self.BandwidthReduction
end

PCIeDevice.BandwidthReduction = TBandwidthReduction

---@class PCIeDevice.UCEByBIOS
---@field UCEByBIOS integer
local TUCEByBIOS = {}
TUCEByBIOS.__index = TUCEByBIOS
TUCEByBIOS.group = {}

local function TUCEByBIOS_from_obj(obj)
    return setmetatable(obj, TUCEByBIOS)
end

function TUCEByBIOS.new(UCEByBIOS)
    return TUCEByBIOS_from_obj({UCEByBIOS = UCEByBIOS})
end
---@param obj PCIeDevice.UCEByBIOS
function TUCEByBIOS:init_from_obj(obj)
    self.UCEByBIOS = obj.UCEByBIOS
end

function TUCEByBIOS:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUCEByBIOS.group)
end

TUCEByBIOS.from_obj = TUCEByBIOS_from_obj

TUCEByBIOS.proto_property = {'UCEByBIOS'}

TUCEByBIOS.default = {0}

TUCEByBIOS.struct = {{name = 'UCEByBIOS', is_array = false, struct = nil}}

function TUCEByBIOS:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UCEByBIOS', self.UCEByBIOS, 'uint8', true, errs, need_convert)

    TUCEByBIOS:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUCEByBIOS.proto_property, errs, need_convert)
    return self
end

function TUCEByBIOS:unpack(_)
    return self.UCEByBIOS
end

PCIeDevice.UCEByBIOS = TUCEByBIOS

---@class PCIeDevice.PredictiveFault
---@field PredictiveFault integer
local TPredictiveFault = {}
TPredictiveFault.__index = TPredictiveFault
TPredictiveFault.group = {}

local function TPredictiveFault_from_obj(obj)
    return setmetatable(obj, TPredictiveFault)
end

function TPredictiveFault.new(PredictiveFault)
    return TPredictiveFault_from_obj({PredictiveFault = PredictiveFault})
end
---@param obj PCIeDevice.PredictiveFault
function TPredictiveFault:init_from_obj(obj)
    self.PredictiveFault = obj.PredictiveFault
end

function TPredictiveFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPredictiveFault.group)
end

TPredictiveFault.from_obj = TPredictiveFault_from_obj

TPredictiveFault.proto_property = {'PredictiveFault'}

TPredictiveFault.default = {0}

TPredictiveFault.struct = {{name = 'PredictiveFault', is_array = false, struct = nil}}

function TPredictiveFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PredictiveFault', self.PredictiveFault, 'uint8', true, errs, need_convert)

    TPredictiveFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPredictiveFault.proto_property, errs, need_convert)
    return self
end

function TPredictiveFault:unpack(_)
    return self.PredictiveFault
end

PCIeDevice.PredictiveFault = TPredictiveFault

---@class PCIeDevice.DiagnosticFault
---@field DiagnosticFault integer
local TDiagnosticFault = {}
TDiagnosticFault.__index = TDiagnosticFault
TDiagnosticFault.group = {}

local function TDiagnosticFault_from_obj(obj)
    return setmetatable(obj, TDiagnosticFault)
end

function TDiagnosticFault.new(DiagnosticFault)
    return TDiagnosticFault_from_obj({DiagnosticFault = DiagnosticFault})
end
---@param obj PCIeDevice.DiagnosticFault
function TDiagnosticFault:init_from_obj(obj)
    self.DiagnosticFault = obj.DiagnosticFault
end

function TDiagnosticFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDiagnosticFault.group)
end

TDiagnosticFault.from_obj = TDiagnosticFault_from_obj

TDiagnosticFault.proto_property = {'DiagnosticFault'}

TDiagnosticFault.default = {0}

TDiagnosticFault.struct = {{name = 'DiagnosticFault', is_array = false, struct = nil}}

function TDiagnosticFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiagnosticFault', self.DiagnosticFault, 'uint8', true, errs, need_convert)

    TDiagnosticFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDiagnosticFault.proto_property, errs, need_convert)
    return self
end

function TDiagnosticFault:unpack(_)
    return self.DiagnosticFault
end

PCIeDevice.DiagnosticFault = TDiagnosticFault

---@class PCIeDevice.DevFunction
---@field DevFunction integer
local TDevFunction = {}
TDevFunction.__index = TDevFunction
TDevFunction.group = {}

local function TDevFunction_from_obj(obj)
    return setmetatable(obj, TDevFunction)
end

function TDevFunction.new(DevFunction)
    return TDevFunction_from_obj({DevFunction = DevFunction})
end
---@param obj PCIeDevice.DevFunction
function TDevFunction:init_from_obj(obj)
    self.DevFunction = obj.DevFunction
end

function TDevFunction:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevFunction.group)
end

TDevFunction.from_obj = TDevFunction_from_obj

TDevFunction.proto_property = {'DevFunction'}

TDevFunction.default = {0}

TDevFunction.struct = {{name = 'DevFunction', is_array = false, struct = nil}}

function TDevFunction:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevFunction', self.DevFunction, 'uint8', true, errs, need_convert)

    TDevFunction:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevFunction.proto_property, errs, need_convert)
    return self
end

function TDevFunction:unpack(_)
    return self.DevFunction
end

PCIeDevice.DevFunction = TDevFunction

---@class PCIeDevice.DevDevice
---@field DevDevice integer
local TDevDevice = {}
TDevDevice.__index = TDevDevice
TDevDevice.group = {}

local function TDevDevice_from_obj(obj)
    return setmetatable(obj, TDevDevice)
end

function TDevDevice.new(DevDevice)
    return TDevDevice_from_obj({DevDevice = DevDevice})
end
---@param obj PCIeDevice.DevDevice
function TDevDevice:init_from_obj(obj)
    self.DevDevice = obj.DevDevice
end

function TDevDevice:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevDevice.group)
end

TDevDevice.from_obj = TDevDevice_from_obj

TDevDevice.proto_property = {'DevDevice'}

TDevDevice.default = {0}

TDevDevice.struct = {{name = 'DevDevice', is_array = false, struct = nil}}

function TDevDevice:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevDevice', self.DevDevice, 'uint8', true, errs, need_convert)

    TDevDevice:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevDevice.proto_property, errs, need_convert)
    return self
end

function TDevDevice:unpack(_)
    return self.DevDevice
end

PCIeDevice.DevDevice = TDevDevice

---@class PCIeDevice.DevBus
---@field DevBus integer
local TDevBus = {}
TDevBus.__index = TDevBus
TDevBus.group = {}

local function TDevBus_from_obj(obj)
    return setmetatable(obj, TDevBus)
end

function TDevBus.new(DevBus)
    return TDevBus_from_obj({DevBus = DevBus})
end
---@param obj PCIeDevice.DevBus
function TDevBus:init_from_obj(obj)
    self.DevBus = obj.DevBus
end

function TDevBus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevBus.group)
end

TDevBus.from_obj = TDevBus_from_obj

TDevBus.proto_property = {'DevBus'}

TDevBus.default = {0}

TDevBus.struct = {{name = 'DevBus', is_array = false, struct = nil}}

function TDevBus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevBus', self.DevBus, 'uint8', true, errs, need_convert)

    TDevBus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevBus.proto_property, errs, need_convert)
    return self
end

function TDevBus:unpack(_)
    return self.DevBus
end

PCIeDevice.DevBus = TDevBus

---@class PCIeDevice.Function
---@field Function integer
local TFunction = {}
TFunction.__index = TFunction
TFunction.group = {}

local function TFunction_from_obj(obj)
    return setmetatable(obj, TFunction)
end

function TFunction.new(Function)
    return TFunction_from_obj({Function = Function})
end
---@param obj PCIeDevice.Function
function TFunction:init_from_obj(obj)
    self.Function = obj.Function
end

function TFunction:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFunction.group)
end

TFunction.from_obj = TFunction_from_obj

TFunction.proto_property = {'Function'}

TFunction.default = {0}

TFunction.struct = {{name = 'Function', is_array = false, struct = nil}}

function TFunction:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Function', self.Function, 'uint8', true, errs, need_convert)

    TFunction:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFunction.proto_property, errs, need_convert)
    return self
end

function TFunction:unpack(_)
    return self.Function
end

PCIeDevice.Function = TFunction

---@class PCIeDevice.Device
---@field Device integer
local TDevice = {}
TDevice.__index = TDevice
TDevice.group = {}

local function TDevice_from_obj(obj)
    return setmetatable(obj, TDevice)
end

function TDevice.new(Device)
    return TDevice_from_obj({Device = Device})
end
---@param obj PCIeDevice.Device
function TDevice:init_from_obj(obj)
    self.Device = obj.Device
end

function TDevice:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevice.group)
end

TDevice.from_obj = TDevice_from_obj

TDevice.proto_property = {'Device'}

TDevice.default = {0}

TDevice.struct = {{name = 'Device', is_array = false, struct = nil}}

function TDevice:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Device', self.Device, 'uint8', true, errs, need_convert)

    TDevice:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevice.proto_property, errs, need_convert)
    return self
end

function TDevice:unpack(_)
    return self.Device
end

PCIeDevice.Device = TDevice

---@class PCIeDevice.Bus
---@field Bus integer
local TBus = {}
TBus.__index = TBus
TBus.group = {}

local function TBus_from_obj(obj)
    return setmetatable(obj, TBus)
end

function TBus.new(Bus)
    return TBus_from_obj({Bus = Bus})
end
---@param obj PCIeDevice.Bus
function TBus:init_from_obj(obj)
    self.Bus = obj.Bus
end

function TBus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBus.group)
end

TBus.from_obj = TBus_from_obj

TBus.proto_property = {'Bus'}

TBus.default = {0}

TBus.struct = {{name = 'Bus', is_array = false, struct = nil}}

function TBus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Bus', self.Bus, 'uint8', true, errs, need_convert)

    TBus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBus.proto_property, errs, need_convert)
    return self
end

function TBus:unpack(_)
    return self.Bus
end

PCIeDevice.Bus = TBus

---@class PCIeDevice.SocketID
---@field SocketID integer
local TSocketID = {}
TSocketID.__index = TSocketID
TSocketID.group = {}

local function TSocketID_from_obj(obj)
    return setmetatable(obj, TSocketID)
end

function TSocketID.new(SocketID)
    return TSocketID_from_obj({SocketID = SocketID})
end
---@param obj PCIeDevice.SocketID
function TSocketID:init_from_obj(obj)
    self.SocketID = obj.SocketID
end

function TSocketID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSocketID.group)
end

TSocketID.from_obj = TSocketID_from_obj

TSocketID.proto_property = {'SocketID'}

TSocketID.default = {0}

TSocketID.struct = {{name = 'SocketID', is_array = false, struct = nil}}

function TSocketID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SocketID', self.SocketID, 'uint8', true, errs, need_convert)

    TSocketID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSocketID.proto_property, errs, need_convert)
    return self
end

function TSocketID:unpack(_)
    return self.SocketID
end

PCIeDevice.SocketID = TSocketID

---@class PCIeDevice.Segment
---@field Segment integer
local TSegment = {}
TSegment.__index = TSegment
TSegment.group = {}

local function TSegment_from_obj(obj)
    return setmetatable(obj, TSegment)
end

function TSegment.new(Segment)
    return TSegment_from_obj({Segment = Segment})
end
---@param obj PCIeDevice.Segment
function TSegment:init_from_obj(obj)
    self.Segment = obj.Segment
end

function TSegment:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSegment.group)
end

TSegment.from_obj = TSegment_from_obj

TSegment.proto_property = {'Segment'}

TSegment.default = {0}

TSegment.struct = {{name = 'Segment', is_array = false, struct = nil}}

function TSegment:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Segment', self.Segment, 'uint8', true, errs, need_convert)

    TSegment:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSegment.proto_property, errs, need_convert)
    return self
end

function TSegment:unpack(_)
    return self.Segment
end

PCIeDevice.Segment = TSegment

---@class PCIeDevice.SlotID
---@field SlotID integer
local TSlotID = {}
TSlotID.__index = TSlotID
TSlotID.group = {}

local function TSlotID_from_obj(obj)
    return setmetatable(obj, TSlotID)
end

function TSlotID.new(SlotID)
    return TSlotID_from_obj({SlotID = SlotID})
end
---@param obj PCIeDevice.SlotID
function TSlotID:init_from_obj(obj)
    self.SlotID = obj.SlotID
end

function TSlotID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotID.group)
end

TSlotID.from_obj = TSlotID_from_obj

TSlotID.proto_property = {'SlotID'}

TSlotID.default = {0}

TSlotID.struct = {{name = 'SlotID', is_array = false, struct = nil}}

function TSlotID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlotID', self.SlotID, 'uint8', true, errs, need_convert)

    TSlotID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotID.proto_property, errs, need_convert)
    return self
end

function TSlotID:unpack(_)
    return self.SlotID
end

PCIeDevice.SlotID = TSlotID

PCIeDevice.interface = mdb.register_interface('bmc.kepler.Systems.PCIeDevices.PCIeDevice', {
    SlotID = {'y', nil, true, nil, false},
    Segment = {'y', nil, true, nil, false},
    SocketID = {'y', nil, true, nil, false},
    Bus = {'y', nil, true, nil, false},
    Device = {'y', nil, true, nil, false},
    Function = {'y', nil, true, nil, false},
    DevBus = {'y', nil, true, nil, false},
    DevDevice = {'y', nil, true, nil, false},
    DevFunction = {'y', nil, true, nil, false},
    DiagnosticFault = {'y', nil, true, nil, false},
    PredictiveFault = {'y', nil, true, nil, false},
    UCEByBIOS = {'y', nil, true, nil, false},
    BandwidthReduction = {'y', nil, true, nil, false},
    LinkSpeedReduced = {'y', nil, true, nil, false},
    FunctionClass = {'y', nil, true, nil, false},
    DeviceName = {'s', nil, true, nil, false},
    Position = {'s', nil, true, nil, false},
    FaultByBios = {'y', nil, true, nil, false},
    SlotType = {'s', nil, true, nil, false},
    FunctionProtocol = {'s', nil, true, nil, false},
    FunctionType = {'s', nil, true, nil, false},
    PCIeType = {'s', nil, true, nil, false},
    PCIeDeviceType = {'s', nil, true, nil, false},
    BaseClassCode = {'y', nil, true, nil, false},
    SubClassCode = {'y', nil, true, nil, false},
    ProgrammingInterface = {'y', nil, true, nil, false},
    MaxPCIeType = {'s', nil, true, nil, false},
    NegotiatedPCIeType = {'s', nil, true, nil, false}
}, {}, {})

return PCIeDevice
