--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local bs = require 'mc.bitstring'
local enums = require 'ipmi.enums'
local ipmi = require 'ipmi'
local types = require 'ipmi.types'
local privilege = require 'mc.privilege'
local msg = require 'pcie_device.ipmi.ipmi_message'

local CT = enums.ChannelType

local PcieDevice = {}

PcieDevice.SetCpuBusSize = {
    name = 'SetCpuBusSize',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,17,01]=],
    decode = [=[<<ManuId:3/unit:8, 0x17:1/unit:8, 0x01:1/unit:8, D]=] .. [=[ataLen:1/unit:8, Tail/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManuId:3/unit:8>>]=],
    req = msg.SetCpuBusSizeReq,
    rsp = msg.SetCpuBusSizeRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PcieDevice.UpdateIntegratedPcieConfig = {
    name = 'UpdateIntegratedPcieConfig',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,17,0E]=],
    decode = [=[<<ManuId:3/unit:8, 0x17:1/unit:8, 0x0E:1/unit:8, D]=] .. [=[ataLen:1/unit:8, Tail/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManuId:3/unit:8>>]=],
    req = msg.UpdateIntegratedPcieConfigReq,
    rsp = msg.UpdateIntegratedPcieConfigRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PcieDevice.GetMezzSilkName = {
    name = 'GetMezzSilkName',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,40,0B,02]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x40:1/unit:8, 0x0B:1/u]=] ..
        [=[nit:8, 0x02:1/unit:8, Length:1/unit:8, Data/string]=] .. [=[>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Data/string>>]=],
    req = msg.GetMezzSilkNameReq,
    rsp = msg.GetMezzSilkNameRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PcieDevice.GetPcieSilkName = {
    name = 'GetPcieSilkName',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,40,08,02]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x40:1/unit:8, 0x08:1/u]=] ..
        [=[nit:8, 0x02:1/unit:8, Length:1/unit:8, Data/string]=] .. [=[>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Data/string>>]=],
    req = msg.GetPcieSilkNameReq,
    rsp = msg.GetPcieSilkNameRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PcieDevice.GetNicSilkName = {
    name = 'GetNicSilkName',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,40,0D,02]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x40:1/unit:8, 0x0D:1/u]=] ..
        [=[nit:8, 0x02:1/unit:8, Length:1/unit:8, Data/string]=] .. [=[>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Data/string>>]=],
    req = msg.GetNicSilkNameReq,
    rsp = msg.GetNicSilkNameRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PcieDevice.GetRaidSilkName = {
    name = 'GetRaidSilkName',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,40,06,02]=],
    decode = [=[<<ManufacturerId:3/unit:8, 0x40:1/unit:8, 0x06:1/u]=] ..
        [=[nit:8, 0x02:1/unit:8, Length:1/unit:8, Data/string]=] .. [=[>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Data/string>>]=],
    req = msg.GetRaidSilkNameReq,
    rsp = msg.GetRaidSilkNameRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PcieDevice.GetDeviceLocationName = {
    name = 'GetDeviceLocationName',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,43,*,02]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x43:1/unit:8, DeviceTyp]=] ..
        [=[e:1/unit:8, 0x02:1/unit:8, InfoLen:1/unit:8, InfoD]=] .. [=[ata:InfoLen/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ LocNameData/string>>]=],
    req = msg.GetDeviceLocationNameReq,
    rsp = msg.GetDeviceLocationNameRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PcieDevice.GetPCIeCardModel = {
    name = 'GetPCIeCardModel',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,40,08,05]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x40:1/unit:8, 0x08:1/un]=] ..
        [=[it:8, 0x05:1/unit:8, Length:1/unit:8, Data/string>]=] .. [=[>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Data/string>>]=],
    req = msg.GetPCIeCardModelReq,
    rsp = msg.GetPCIeCardModelRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PcieDevice.GetPCIeDevPresentStatus = {
    name = 'GetPCIeDevPresentStatus',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,4b]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x4b:1/unit:8, DeviceTyp]=] .. [=[e:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Data:4/unit:8>>]=],
    req = msg.GetPCIeDevPresentStatusReq,
    rsp = msg.GetPCIeDevPresentStatusRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PcieDevice.WritePCIeVPDInfoToBmc = {
    name = 'WritePCIeVPDInfoToBmc',
    prio = types.Priority.Default,
    netfn = 0x06,
    cmd = 0x58,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[D2]=],
    decode = [=[<<0xD2:1/unit:8, CardType:1/unit:8, PCIeSlotNumber]=] ..
        [=[:1/unit:8, BusNumber:1/unit:8, DeviceNumber:1/unit]=] ..
        [=[:8, FunctionNumber:1/unit:8, VPDItemData/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.WritePCIeVPDInfoToBmcReq,
    rsp = msg.WritePCIeVPDInfoToBmcRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

return PcieDevice
