--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetCpuBusSize = {}

---@class PcieDevice.SetCpuBusSizeReq
---@field ManuId integer
---@field DataLen integer
---@field Tail string
local TSetCpuBusSizeReq = {}
TSetCpuBusSizeReq.__index = TSetCpuBusSizeReq
TSetCpuBusSizeReq.group = {}

local function TSetCpuBusSizeReq_from_obj(obj)
    return setmetatable(obj, TSetCpuBusSizeReq)
end

function TSetCpuBusSizeReq.new(ManuId, DataLen, Tail)
    return TSetCpuBusSizeReq_from_obj({ManuId = ManuId, DataLen = DataLen, Tail = Tail})
end
---@param obj PcieDevice.SetCpuBusSizeReq
function TSetCpuBusSizeReq:init_from_obj(obj)
    self.ManuId = obj.ManuId
    self.DataLen = obj.DataLen
    self.Tail = obj.Tail
end

function TSetCpuBusSizeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCpuBusSizeReq.group)
end

TSetCpuBusSizeReq.from_obj = TSetCpuBusSizeReq_from_obj

TSetCpuBusSizeReq.proto_property = {'ManuId', 'DataLen', 'Tail'}

TSetCpuBusSizeReq.default = {0, 0, ''}

TSetCpuBusSizeReq.struct = {
    {name = 'ManuId', is_array = false, struct = nil}, {name = 'DataLen', is_array = false, struct = nil},
    {name = 'Tail', is_array = false, struct = nil}
}

function TSetCpuBusSizeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManuId', self.ManuId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DataLen', self.DataLen, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Tail', self.Tail, 'string', false, errs, need_convert)

    TSetCpuBusSizeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCpuBusSizeReq.proto_property, errs, need_convert)
    return self
end

function TSetCpuBusSizeReq:unpack(_)
    return self.ManuId, self.DataLen, self.Tail
end

SetCpuBusSize.SetCpuBusSizeReq = TSetCpuBusSizeReq

---@class PcieDevice.SetCpuBusSizeRsp
---@field CompletionCode integer
---@field ManuId integer
local TSetCpuBusSizeRsp = {}
TSetCpuBusSizeRsp.__index = TSetCpuBusSizeRsp
TSetCpuBusSizeRsp.group = {}

local function TSetCpuBusSizeRsp_from_obj(obj)
    return setmetatable(obj, TSetCpuBusSizeRsp)
end

function TSetCpuBusSizeRsp.new(CompletionCode, ManuId)
    return TSetCpuBusSizeRsp_from_obj({CompletionCode = CompletionCode, ManuId = ManuId})
end
---@param obj PcieDevice.SetCpuBusSizeRsp
function TSetCpuBusSizeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManuId = obj.ManuId
end

function TSetCpuBusSizeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCpuBusSizeRsp.group)
end

TSetCpuBusSizeRsp.from_obj = TSetCpuBusSizeRsp_from_obj

TSetCpuBusSizeRsp.proto_property = {'CompletionCode', 'ManuId'}

TSetCpuBusSizeRsp.default = {0, 0}

TSetCpuBusSizeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManuId', is_array = false, struct = nil}
}

function TSetCpuBusSizeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManuId', self.ManuId, 'uint32', false, errs, need_convert)

    TSetCpuBusSizeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCpuBusSizeRsp.proto_property, errs, need_convert)
    return self
end

function TSetCpuBusSizeRsp:unpack(_)
    return self.CompletionCode, self.ManuId
end

SetCpuBusSize.SetCpuBusSizeRsp = TSetCpuBusSizeRsp

return SetCpuBusSize
