--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetRaidSilkName = {}

---@class PcieDevice.GetRaidSilkNameReq
---@field ManufacturerId integer
---@field Length integer
---@field Data string
local TGetRaidSilkNameReq = {}
TGetRaidSilkNameReq.__index = TGetRaidSilkNameReq
TGetRaidSilkNameReq.group = {}

local function TGetRaidSilkNameReq_from_obj(obj)
    return setmetatable(obj, TGetRaidSilkNameReq)
end

function TGetRaidSilkNameReq.new(ManufacturerId, Length, Data)
    return TGetRaidSilkNameReq_from_obj({ManufacturerId = ManufacturerId, Length = Length, Data = Data})
end
---@param obj PcieDevice.GetRaidSilkNameReq
function TGetRaidSilkNameReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Length = obj.Length
    self.Data = obj.Data
end

function TGetRaidSilkNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetRaidSilkNameReq.group)
end

TGetRaidSilkNameReq.from_obj = TGetRaidSilkNameReq_from_obj

TGetRaidSilkNameReq.proto_property = {'ManufacturerId', 'Length', 'Data'}

TGetRaidSilkNameReq.default = {0, 0, ''}

TGetRaidSilkNameReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetRaidSilkNameReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetRaidSilkNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetRaidSilkNameReq.proto_property, errs, need_convert)
    return self
end

function TGetRaidSilkNameReq:unpack(_)
    return self.ManufacturerId, self.Length, self.Data
end

GetRaidSilkName.GetRaidSilkNameReq = TGetRaidSilkNameReq

---@class PcieDevice.GetRaidSilkNameRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Data string
local TGetRaidSilkNameRsp = {}
TGetRaidSilkNameRsp.__index = TGetRaidSilkNameRsp
TGetRaidSilkNameRsp.group = {}

local function TGetRaidSilkNameRsp_from_obj(obj)
    return setmetatable(obj, TGetRaidSilkNameRsp)
end

function TGetRaidSilkNameRsp.new(CompletionCode, ManufactureId, Data)
    return TGetRaidSilkNameRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId, Data = Data})
end
---@param obj PcieDevice.GetRaidSilkNameRsp
function TGetRaidSilkNameRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Data = obj.Data
end

function TGetRaidSilkNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetRaidSilkNameRsp.group)
end

TGetRaidSilkNameRsp.from_obj = TGetRaidSilkNameRsp_from_obj

TGetRaidSilkNameRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Data'}

TGetRaidSilkNameRsp.default = {0, 0, ''}

TGetRaidSilkNameRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetRaidSilkNameRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetRaidSilkNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetRaidSilkNameRsp.proto_property, errs, need_convert)
    return self
end

function TGetRaidSilkNameRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Data
end

GetRaidSilkName.GetRaidSilkNameRsp = TGetRaidSilkNameRsp

return GetRaidSilkName
