--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPcieSilkName = {}

---@class PcieDevice.GetPcieSilkNameReq
---@field ManufacturerId integer
---@field Length integer
---@field Data string
local TGetPcieSilkNameReq = {}
TGetPcieSilkNameReq.__index = TGetPcieSilkNameReq
TGetPcieSilkNameReq.group = {}

local function TGetPcieSilkNameReq_from_obj(obj)
    return setmetatable(obj, TGetPcieSilkNameReq)
end

function TGetPcieSilkNameReq.new(ManufacturerId, Length, Data)
    return TGetPcieSilkNameReq_from_obj({ManufacturerId = ManufacturerId, Length = Length, Data = Data})
end
---@param obj PcieDevice.GetPcieSilkNameReq
function TGetPcieSilkNameReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Length = obj.Length
    self.Data = obj.Data
end

function TGetPcieSilkNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPcieSilkNameReq.group)
end

TGetPcieSilkNameReq.from_obj = TGetPcieSilkNameReq_from_obj

TGetPcieSilkNameReq.proto_property = {'ManufacturerId', 'Length', 'Data'}

TGetPcieSilkNameReq.default = {0, 0, ''}

TGetPcieSilkNameReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetPcieSilkNameReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetPcieSilkNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPcieSilkNameReq.proto_property, errs, need_convert)
    return self
end

function TGetPcieSilkNameReq:unpack(_)
    return self.ManufacturerId, self.Length, self.Data
end

GetPcieSilkName.GetPcieSilkNameReq = TGetPcieSilkNameReq

---@class PcieDevice.GetPcieSilkNameRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Data string
local TGetPcieSilkNameRsp = {}
TGetPcieSilkNameRsp.__index = TGetPcieSilkNameRsp
TGetPcieSilkNameRsp.group = {}

local function TGetPcieSilkNameRsp_from_obj(obj)
    return setmetatable(obj, TGetPcieSilkNameRsp)
end

function TGetPcieSilkNameRsp.new(CompletionCode, ManufactureId, Data)
    return TGetPcieSilkNameRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId, Data = Data})
end
---@param obj PcieDevice.GetPcieSilkNameRsp
function TGetPcieSilkNameRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Data = obj.Data
end

function TGetPcieSilkNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPcieSilkNameRsp.group)
end

TGetPcieSilkNameRsp.from_obj = TGetPcieSilkNameRsp_from_obj

TGetPcieSilkNameRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Data'}

TGetPcieSilkNameRsp.default = {0, 0, ''}

TGetPcieSilkNameRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetPcieSilkNameRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetPcieSilkNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPcieSilkNameRsp.proto_property, errs, need_convert)
    return self
end

function TGetPcieSilkNameRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Data
end

GetPcieSilkName.GetPcieSilkNameRsp = TGetPcieSilkNameRsp

return GetPcieSilkName
