--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPCIeCardModel = {}

---@class PcieDevice.GetPCIeCardModelReq
---@field ManufactureId integer
---@field Length integer
---@field Data string
local TGetPCIeCardModelReq = {}
TGetPCIeCardModelReq.__index = TGetPCIeCardModelReq
TGetPCIeCardModelReq.group = {}

local function TGetPCIeCardModelReq_from_obj(obj)
    return setmetatable(obj, TGetPCIeCardModelReq)
end

function TGetPCIeCardModelReq.new(ManufactureId, Length, Data)
    return TGetPCIeCardModelReq_from_obj({ManufactureId = ManufactureId, Length = Length, Data = Data})
end
---@param obj PcieDevice.GetPCIeCardModelReq
function TGetPCIeCardModelReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Length = obj.Length
    self.Data = obj.Data
end

function TGetPCIeCardModelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPCIeCardModelReq.group)
end

TGetPCIeCardModelReq.from_obj = TGetPCIeCardModelReq_from_obj

TGetPCIeCardModelReq.proto_property = {'ManufactureId', 'Length', 'Data'}

TGetPCIeCardModelReq.default = {0, 0, ''}

TGetPCIeCardModelReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetPCIeCardModelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetPCIeCardModelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPCIeCardModelReq.proto_property, errs, need_convert)
    return self
end

function TGetPCIeCardModelReq:unpack(_)
    return self.ManufactureId, self.Length, self.Data
end

GetPCIeCardModel.GetPCIeCardModelReq = TGetPCIeCardModelReq

---@class PcieDevice.GetPCIeCardModelRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Data string
local TGetPCIeCardModelRsp = {}
TGetPCIeCardModelRsp.__index = TGetPCIeCardModelRsp
TGetPCIeCardModelRsp.group = {}

local function TGetPCIeCardModelRsp_from_obj(obj)
    return setmetatable(obj, TGetPCIeCardModelRsp)
end

function TGetPCIeCardModelRsp.new(CompletionCode, ManufactureId, Data)
    return TGetPCIeCardModelRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId, Data = Data})
end
---@param obj PcieDevice.GetPCIeCardModelRsp
function TGetPCIeCardModelRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Data = obj.Data
end

function TGetPCIeCardModelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPCIeCardModelRsp.group)
end

TGetPCIeCardModelRsp.from_obj = TGetPCIeCardModelRsp_from_obj

TGetPCIeCardModelRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Data'}

TGetPCIeCardModelRsp.default = {0, 0, ''}

TGetPCIeCardModelRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetPCIeCardModelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetPCIeCardModelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPCIeCardModelRsp.proto_property, errs, need_convert)
    return self
end

function TGetPCIeCardModelRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Data
end

GetPCIeCardModel.GetPCIeCardModelRsp = TGetPCIeCardModelRsp

return GetPCIeCardModel
