--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetNicSilkName = {}

---@class PcieDevice.GetNicSilkNameReq
---@field ManufacturerId integer
---@field Length integer
---@field Data string
local TGetNicSilkNameReq = {}
TGetNicSilkNameReq.__index = TGetNicSilkNameReq
TGetNicSilkNameReq.group = {}

local function TGetNicSilkNameReq_from_obj(obj)
    return setmetatable(obj, TGetNicSilkNameReq)
end

function TGetNicSilkNameReq.new(ManufacturerId, Length, Data)
    return TGetNicSilkNameReq_from_obj({ManufacturerId = ManufacturerId, Length = Length, Data = Data})
end
---@param obj PcieDevice.GetNicSilkNameReq
function TGetNicSilkNameReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Length = obj.Length
    self.Data = obj.Data
end

function TGetNicSilkNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNicSilkNameReq.group)
end

TGetNicSilkNameReq.from_obj = TGetNicSilkNameReq_from_obj

TGetNicSilkNameReq.proto_property = {'ManufacturerId', 'Length', 'Data'}

TGetNicSilkNameReq.default = {0, 0, ''}

TGetNicSilkNameReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetNicSilkNameReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetNicSilkNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNicSilkNameReq.proto_property, errs, need_convert)
    return self
end

function TGetNicSilkNameReq:unpack(_)
    return self.ManufacturerId, self.Length, self.Data
end

GetNicSilkName.GetNicSilkNameReq = TGetNicSilkNameReq

---@class PcieDevice.GetNicSilkNameRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Data string
local TGetNicSilkNameRsp = {}
TGetNicSilkNameRsp.__index = TGetNicSilkNameRsp
TGetNicSilkNameRsp.group = {}

local function TGetNicSilkNameRsp_from_obj(obj)
    return setmetatable(obj, TGetNicSilkNameRsp)
end

function TGetNicSilkNameRsp.new(CompletionCode, ManufactureId, Data)
    return TGetNicSilkNameRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId, Data = Data})
end
---@param obj PcieDevice.GetNicSilkNameRsp
function TGetNicSilkNameRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Data = obj.Data
end

function TGetNicSilkNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNicSilkNameRsp.group)
end

TGetNicSilkNameRsp.from_obj = TGetNicSilkNameRsp_from_obj

TGetNicSilkNameRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Data'}

TGetNicSilkNameRsp.default = {0, 0, ''}

TGetNicSilkNameRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetNicSilkNameRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetNicSilkNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNicSilkNameRsp.proto_property, errs, need_convert)
    return self
end

function TGetNicSilkNameRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Data
end

GetNicSilkName.GetNicSilkNameRsp = TGetNicSilkNameRsp

return GetNicSilkName
