--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDeviceLocationName = {}

---@class PcieDevice.GetDeviceLocationNameReq
---@field ManufactureId integer
---@field DeviceType integer
---@field InfoLen integer
---@field InfoData string
local TGetDeviceLocationNameReq = {}
TGetDeviceLocationNameReq.__index = TGetDeviceLocationNameReq
TGetDeviceLocationNameReq.group = {}

local function TGetDeviceLocationNameReq_from_obj(obj)
    return setmetatable(obj, TGetDeviceLocationNameReq)
end

function TGetDeviceLocationNameReq.new(ManufactureId, DeviceType, InfoLen, InfoData)
    return TGetDeviceLocationNameReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceType = DeviceType,
        InfoLen = InfoLen,
        InfoData = InfoData
    })
end
---@param obj PcieDevice.GetDeviceLocationNameReq
function TGetDeviceLocationNameReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceType = obj.DeviceType
    self.InfoLen = obj.InfoLen
    self.InfoData = obj.InfoData
end

function TGetDeviceLocationNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceLocationNameReq.group)
end

TGetDeviceLocationNameReq.from_obj = TGetDeviceLocationNameReq_from_obj

TGetDeviceLocationNameReq.proto_property = {'ManufactureId', 'DeviceType', 'InfoLen', 'InfoData'}

TGetDeviceLocationNameReq.default = {0, 0, 0, ''}

TGetDeviceLocationNameReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceType', is_array = false, struct = nil},
    {name = 'InfoLen', is_array = false, struct = nil}, {name = 'InfoData', is_array = false, struct = nil}
}

function TGetDeviceLocationNameReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'InfoLen', self.InfoLen, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'InfoData', self.InfoData, 'string', false, errs, need_convert)

    TGetDeviceLocationNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceLocationNameReq.proto_property, errs, need_convert)
    return self
end

function TGetDeviceLocationNameReq:unpack(_)
    return self.ManufactureId, self.DeviceType, self.InfoLen, self.InfoData
end

GetDeviceLocationName.GetDeviceLocationNameReq = TGetDeviceLocationNameReq

---@class PcieDevice.GetDeviceLocationNameRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field LocNameData string
local TGetDeviceLocationNameRsp = {}
TGetDeviceLocationNameRsp.__index = TGetDeviceLocationNameRsp
TGetDeviceLocationNameRsp.group = {}

local function TGetDeviceLocationNameRsp_from_obj(obj)
    return setmetatable(obj, TGetDeviceLocationNameRsp)
end

function TGetDeviceLocationNameRsp.new(CompletionCode, ManufactureId, LocNameData)
    return TGetDeviceLocationNameRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        LocNameData = LocNameData
    })
end
---@param obj PcieDevice.GetDeviceLocationNameRsp
function TGetDeviceLocationNameRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.LocNameData = obj.LocNameData
end

function TGetDeviceLocationNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceLocationNameRsp.group)
end

TGetDeviceLocationNameRsp.from_obj = TGetDeviceLocationNameRsp_from_obj

TGetDeviceLocationNameRsp.proto_property = {'CompletionCode', 'ManufactureId', 'LocNameData'}

TGetDeviceLocationNameRsp.default = {0, 0, ''}

TGetDeviceLocationNameRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'LocNameData', is_array = false, struct = nil}
}

function TGetDeviceLocationNameRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'LocNameData', self.LocNameData, 'string', false, errs, need_convert)

    TGetDeviceLocationNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceLocationNameRsp.proto_property, errs, need_convert)
    return self
end

function TGetDeviceLocationNameRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.LocNameData
end

GetDeviceLocationName.GetDeviceLocationNameRsp = TGetDeviceLocationNameRsp

return GetDeviceLocationName
