-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local log = require 'mc.logging'
local error = require 'mc.error'
local new_error = error.new_error
local print_log = error.print_log
local print_trace = error.print_trace
local regist_err_eng = error.register_err

local M = {}

local InvalidCommand = {
    name = 'kepler.ipmi.InvalidCommand',
    format = [=[ipmi handle[channel = %s, netfn = %s, cmd = %s] : ]=] .. [=[invalid command]=],
    severity = 'debug'
}
M.InvalidCommand = InvalidCommand.name
---@return Error
function M.invalid_command(val1, val2, val3)
    local err_data = new_error(InvalidCommand.name, InvalidCommand.format, val1, val2, val3)
    regist_err_eng(InvalidCommand, 400, nil, 0xC1)
    print_log(log.DEBUG, InvalidCommand.format, val1, val2, val3)
    return err_data
end

local InvalidField = {
    name = 'kepler.ipmi.InvalidField',
    format = [=[ipmi handle[channel = %s, netfn = %s, cmd = %s] : ]=] .. [=[Invalid data field in Request]=],
    severity = 'debug'
}
M.InvalidField = InvalidField.name
---@return Error
function M.invalid_field(val1, val2, val3)
    local err_data = new_error(InvalidField.name, InvalidField.format, val1, val2, val3)
    regist_err_eng(InvalidField, 400, nil, 0xCC)
    print_log(log.DEBUG, InvalidField.format, val1, val2, val3)
    return err_data
end

local InvalidLength = {
    name = 'kepler.ipmi.InvalidLength',
    format = [=[ipmi handle[channel = %s, netfn = %s, cmd = %s] : ]=] .. [=[Request data length invaild]=],
    severity = 'debug'
}
M.InvalidLength = InvalidLength.name
---@return Error
function M.invalid_length(val1, val2, val3)
    local err_data = new_error(InvalidLength.name, InvalidLength.format, val1, val2, val3)
    regist_err_eng(InvalidLength, 400, nil, 0xC7)
    print_log(log.DEBUG, InvalidLength.format, val1, val2, val3)
    return err_data
end

local GetPCIInfoFailed = {
    name = 'kepler.pcie_device.GetPCIInfoFailed',
    format = [=[Failed to get PCI info.]=],
    severity = 'error'
}
M.GetPCIInfoFailed = GetPCIInfoFailed.name
---@return Error
function M.get_pci_info_failed()
    local err_data = new_error(GetPCIInfoFailed.name, GetPCIInfoFailed.format)
    regist_err_eng(GetPCIInfoFailed, 400, nil, 0xFF)
    print_log(log.ERROR, GetPCIInfoFailed.format)
    return err_data
end

return M
