-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local def_types = require 'class.types.types'

local MUnitConfiguration = {}

---@class MUnitConfiguration.Configurations
---@field Configurations def_types.Configuration[]
local TConfigurations = {}
TConfigurations.__index = TConfigurations
TConfigurations.group = {}

local function TConfigurations_from_obj(obj)
    obj.Configurations = utils.from_obj(def_types.Configuration, obj.Configurations, true)
    return setmetatable(obj, TConfigurations)
end

function TConfigurations.new(Configurations)
    return TConfigurations_from_obj({Configurations = Configurations})
end
---@param obj MUnitConfiguration.Configurations
function TConfigurations:init_from_obj(obj)
    self.Configurations = obj.Configurations
end

function TConfigurations:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConfigurations.group)
end

TConfigurations.from_obj = TConfigurations_from_obj

TConfigurations.proto_property = {'Configurations'}

TConfigurations.default = {{}}

TConfigurations.struct = {{name = 'Configurations', is_array = true, struct = def_types.Configuration.struct}}

function TConfigurations:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.Configurations) do
        def_types.Configuration.new(v.UID, v.Index, v.SrcPortName, v.TargetPortID, v.Slot, v.Device, v.Default,
            v.BCUIndex):validate(prefix, errs, need_convert)
    end

    TConfigurations:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConfigurations.proto_property, errs, need_convert)
    return self
end

function TConfigurations:unpack(raw)
    return utils.unpack(raw, self.Configurations, true)
end

MUnitConfiguration.Configurations = TConfigurations

---@class MUnitConfiguration.ContainerSlot
---@field ContainerSlot integer
local TContainerSlot = {}
TContainerSlot.__index = TContainerSlot
TContainerSlot.group = {}

local function TContainerSlot_from_obj(obj)
    return setmetatable(obj, TContainerSlot)
end

function TContainerSlot.new(ContainerSlot)
    return TContainerSlot_from_obj({ContainerSlot = ContainerSlot})
end
---@param obj MUnitConfiguration.ContainerSlot
function TContainerSlot:init_from_obj(obj)
    self.ContainerSlot = obj.ContainerSlot
end

function TContainerSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TContainerSlot.group)
end

TContainerSlot.from_obj = TContainerSlot_from_obj

TContainerSlot.proto_property = {'ContainerSlot'}

TContainerSlot.default = {0}

TContainerSlot.struct = {{name = 'ContainerSlot', is_array = false, struct = nil}}

function TContainerSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ContainerSlot', self.ContainerSlot, 'uint8', false, errs, need_convert)

    TContainerSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TContainerSlot.proto_property, errs, need_convert)
    return self
end

function TContainerSlot:unpack(_)
    return self.ContainerSlot
end

MUnitConfiguration.ContainerSlot = TContainerSlot

---@class MUnitConfiguration.ContainerUID
---@field ContainerUID string
local TContainerUID = {}
TContainerUID.__index = TContainerUID
TContainerUID.group = {}

local function TContainerUID_from_obj(obj)
    return setmetatable(obj, TContainerUID)
end

function TContainerUID.new(ContainerUID)
    return TContainerUID_from_obj({ContainerUID = ContainerUID})
end
---@param obj MUnitConfiguration.ContainerUID
function TContainerUID:init_from_obj(obj)
    self.ContainerUID = obj.ContainerUID
end

function TContainerUID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TContainerUID.group)
end

TContainerUID.from_obj = TContainerUID_from_obj

TContainerUID.proto_property = {'ContainerUID'}

TContainerUID.default = {''}

TContainerUID.struct = {{name = 'ContainerUID', is_array = false, struct = nil}}

function TContainerUID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ContainerUID', self.ContainerUID, 'string', false, errs, need_convert)

    TContainerUID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TContainerUID.proto_property, errs, need_convert)
    return self
end

function TContainerUID:unpack(_)
    return self.ContainerUID
end

MUnitConfiguration.ContainerUID = TContainerUID

---@class MUnitConfiguration.SlotSilkText
---@field SlotSilkText string
local TSlotSilkText = {}
TSlotSilkText.__index = TSlotSilkText
TSlotSilkText.group = {}

local function TSlotSilkText_from_obj(obj)
    return setmetatable(obj, TSlotSilkText)
end

function TSlotSilkText.new(SlotSilkText)
    return TSlotSilkText_from_obj({SlotSilkText = SlotSilkText})
end
---@param obj MUnitConfiguration.SlotSilkText
function TSlotSilkText:init_from_obj(obj)
    self.SlotSilkText = obj.SlotSilkText
end

function TSlotSilkText:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotSilkText.group)
end

TSlotSilkText.from_obj = TSlotSilkText_from_obj

TSlotSilkText.proto_property = {'SlotSilkText'}

TSlotSilkText.default = {''}

TSlotSilkText.struct = {{name = 'SlotSilkText', is_array = false, struct = nil}}

function TSlotSilkText:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlotSilkText', self.SlotSilkText, 'string', false, errs, need_convert)

    TSlotSilkText:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotSilkText.proto_property, errs, need_convert)
    return self
end

function TSlotSilkText:unpack(_)
    return self.SlotSilkText
end

MUnitConfiguration.SlotSilkText = TSlotSilkText

---@class MUnitConfiguration.SlotNumber
---@field SlotNumber integer
local TSlotNumber = {}
TSlotNumber.__index = TSlotNumber
TSlotNumber.group = {}

local function TSlotNumber_from_obj(obj)
    return setmetatable(obj, TSlotNumber)
end

function TSlotNumber.new(SlotNumber)
    return TSlotNumber_from_obj({SlotNumber = SlotNumber})
end
---@param obj MUnitConfiguration.SlotNumber
function TSlotNumber:init_from_obj(obj)
    self.SlotNumber = obj.SlotNumber
end

function TSlotNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotNumber.group)
end

TSlotNumber.from_obj = TSlotNumber_from_obj

TSlotNumber.proto_property = {'SlotNumber'}

TSlotNumber.default = {0}

TSlotNumber.struct = {{name = 'SlotNumber', is_array = false, struct = nil}}

function TSlotNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlotNumber', self.SlotNumber, 'uint8', false, errs, need_convert)

    TSlotNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotNumber.proto_property, errs, need_convert)
    return self
end

function TSlotNumber:unpack(_)
    return self.SlotNumber
end

MUnitConfiguration.SlotNumber = TSlotNumber

---@class MUnitConfiguration.SlotType
---@field SlotType string
local TSlotType = {}
TSlotType.__index = TSlotType
TSlotType.group = {}

local function TSlotType_from_obj(obj)
    return setmetatable(obj, TSlotType)
end

function TSlotType.new(SlotType)
    return TSlotType_from_obj({SlotType = SlotType})
end
---@param obj MUnitConfiguration.SlotType
function TSlotType:init_from_obj(obj)
    self.SlotType = obj.SlotType
end

function TSlotType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotType.group)
end

TSlotType.from_obj = TSlotType_from_obj

TSlotType.proto_property = {'SlotType'}

TSlotType.default = {''}

TSlotType.struct = {{name = 'SlotType', is_array = false, struct = nil}}

function TSlotType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlotType', self.SlotType, 'string', false, errs, need_convert)

    TSlotType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotType.proto_property, errs, need_convert)
    return self
end

function TSlotType:unpack(_)
    return self.SlotType
end

MUnitConfiguration.SlotType = TSlotType

return MUnitConfiguration
