-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MBusinessTopoNode = {}

---@class MBusinessTopoNode.RefSmcChip
---@field RefSmcChip integer[]
local TRefSmcChip = {}
TRefSmcChip.__index = TRefSmcChip
TRefSmcChip.group = {}

local function TRefSmcChip_from_obj(obj)
    return setmetatable(obj, TRefSmcChip)
end

function TRefSmcChip.new(RefSmcChip)
    return TRefSmcChip_from_obj({RefSmcChip = RefSmcChip})
end
---@param obj MBusinessTopoNode.RefSmcChip
function TRefSmcChip:init_from_obj(obj)
    self.RefSmcChip = obj.RefSmcChip
end

function TRefSmcChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefSmcChip.group)
end

TRefSmcChip.from_obj = TRefSmcChip_from_obj

TRefSmcChip.proto_property = {'RefSmcChip'}

TRefSmcChip.default = {{}}

TRefSmcChip.struct = {{name = 'RefSmcChip', is_array = true, struct = nil}}

function TRefSmcChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefSmcChip', self.RefSmcChip, 'uint8', false, errs, need_convert)

    TRefSmcChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefSmcChip.proto_property, errs, need_convert)
    return self
end

function TRefSmcChip:unpack(_)
    return self.RefSmcChip
end

MBusinessTopoNode.RefSmcChip = TRefSmcChip

---@class MBusinessTopoNode.Type
---@field Type string
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj MBusinessTopoNode.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {''}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'string', false, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

MBusinessTopoNode.Type = TType

---@class MBusinessTopoNode.UID
---@field UID string
local TUID = {}
TUID.__index = TUID
TUID.group = {}

local function TUID_from_obj(obj)
    return setmetatable(obj, TUID)
end

function TUID.new(UID)
    return TUID_from_obj({UID = UID})
end
---@param obj MBusinessTopoNode.UID
function TUID:init_from_obj(obj)
    self.UID = obj.UID
end

function TUID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUID.group)
end

TUID.from_obj = TUID_from_obj

TUID.proto_property = {'UID'}

TUID.default = {''}

TUID.struct = {{name = 'UID', is_array = false, struct = nil}}

function TUID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UID', self.UID, 'string', false, errs, need_convert)

    TUID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUID.proto_property, errs, need_convert)
    return self
end

function TUID:unpack(_)
    return self.UID
end

MBusinessTopoNode.UID = TUID

---@class MBusinessTopoNode.Slot
---@field Slot integer
local TSlot = {}
TSlot.__index = TSlot
TSlot.group = {}

local function TSlot_from_obj(obj)
    return setmetatable(obj, TSlot)
end

function TSlot.new(Slot)
    return TSlot_from_obj({Slot = Slot})
end
---@param obj MBusinessTopoNode.Slot
function TSlot:init_from_obj(obj)
    self.Slot = obj.Slot
end

function TSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlot.group)
end

TSlot.from_obj = TSlot_from_obj

TSlot.proto_property = {'Slot'}

TSlot.default = {0}

TSlot.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slot', self.Slot, 'uint8', false, errs, need_convert)

    TSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlot.proto_property, errs, need_convert)
    return self
end

function TSlot:unpack(_)
    return self.Slot
end

MBusinessTopoNode.Slot = TSlot

return MBusinessTopoNode
