-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local def_types = require 'class.types.types'

local MBusinessConnector = {}

---@class MBusinessConnector.BCUIndex
---@field BCUIndex integer
local TBCUIndex = {}
TBCUIndex.__index = TBCUIndex
TBCUIndex.group = {}

local function TBCUIndex_from_obj(obj)
    return setmetatable(obj, TBCUIndex)
end

function TBCUIndex.new(BCUIndex)
    return TBCUIndex_from_obj({BCUIndex = BCUIndex})
end
---@param obj MBusinessConnector.BCUIndex
function TBCUIndex:init_from_obj(obj)
    self.BCUIndex = obj.BCUIndex
end

function TBCUIndex:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBCUIndex.group)
end

TBCUIndex.from_obj = TBCUIndex_from_obj

TBCUIndex.proto_property = {'BCUIndex'}

TBCUIndex.default = {0}

TBCUIndex.struct = {{name = 'BCUIndex', is_array = false, struct = nil}}

function TBCUIndex:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BCUIndex', self.BCUIndex, 'uint8', false, errs, need_convert)

    TBCUIndex:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBCUIndex.proto_property, errs, need_convert)
    return self
end

function TBCUIndex:unpack(_)
    return self.BCUIndex
end

MBusinessConnector.BCUIndex = TBCUIndex

---@class MBusinessConnector.RefPCIeAddrInfo
---@field RefPCIeAddrInfo string
local TRefPCIeAddrInfo = {}
TRefPCIeAddrInfo.__index = TRefPCIeAddrInfo
TRefPCIeAddrInfo.group = {}

local function TRefPCIeAddrInfo_from_obj(obj)
    return setmetatable(obj, TRefPCIeAddrInfo)
end

function TRefPCIeAddrInfo.new(RefPCIeAddrInfo)
    return TRefPCIeAddrInfo_from_obj({RefPCIeAddrInfo = RefPCIeAddrInfo})
end
---@param obj MBusinessConnector.RefPCIeAddrInfo
function TRefPCIeAddrInfo:init_from_obj(obj)
    self.RefPCIeAddrInfo = obj.RefPCIeAddrInfo
end

function TRefPCIeAddrInfo:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefPCIeAddrInfo.group)
end

TRefPCIeAddrInfo.from_obj = TRefPCIeAddrInfo_from_obj

TRefPCIeAddrInfo.proto_property = {'RefPCIeAddrInfo'}

TRefPCIeAddrInfo.default = {''}

TRefPCIeAddrInfo.struct = {{name = 'RefPCIeAddrInfo', is_array = false, struct = nil}}

function TRefPCIeAddrInfo:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RefPCIeAddrInfo', self.RefPCIeAddrInfo, 'string', false, errs, need_convert)

    TRefPCIeAddrInfo:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefPCIeAddrInfo.proto_property, errs, need_convert)
    return self
end

function TRefPCIeAddrInfo:unpack(_)
    return self.RefPCIeAddrInfo
end

MBusinessConnector.RefPCIeAddrInfo = TRefPCIeAddrInfo

---@class MBusinessConnector.RefMgmtConnectorTianChi
---@field RefMgmtConnectorTianChi string
local TRefMgmtConnectorTianChi = {}
TRefMgmtConnectorTianChi.__index = TRefMgmtConnectorTianChi
TRefMgmtConnectorTianChi.group = {}

local function TRefMgmtConnectorTianChi_from_obj(obj)
    return setmetatable(obj, TRefMgmtConnectorTianChi)
end

function TRefMgmtConnectorTianChi.new(RefMgmtConnectorTianChi)
    return TRefMgmtConnectorTianChi_from_obj({RefMgmtConnectorTianChi = RefMgmtConnectorTianChi})
end
---@param obj MBusinessConnector.RefMgmtConnectorTianChi
function TRefMgmtConnectorTianChi:init_from_obj(obj)
    self.RefMgmtConnectorTianChi = obj.RefMgmtConnectorTianChi
end

function TRefMgmtConnectorTianChi:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefMgmtConnectorTianChi.group)
end

TRefMgmtConnectorTianChi.from_obj = TRefMgmtConnectorTianChi_from_obj

TRefMgmtConnectorTianChi.proto_property = {'RefMgmtConnectorTianChi'}

TRefMgmtConnectorTianChi.default = {''}

TRefMgmtConnectorTianChi.struct = {{name = 'RefMgmtConnectorTianChi', is_array = false, struct = nil}}

function TRefMgmtConnectorTianChi:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RefMgmtConnectorTianChi', self.RefMgmtConnectorTianChi, 'string', false, errs,
        need_convert)

    TRefMgmtConnectorTianChi:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefMgmtConnectorTianChi.proto_property, errs, need_convert)
    return self
end

function TRefMgmtConnectorTianChi:unpack(_)
    return self.RefMgmtConnectorTianChi
end

MBusinessConnector.RefMgmtConnectorTianChi = TRefMgmtConnectorTianChi

---@class MBusinessConnector.RefMgmtConnector
---@field RefMgmtConnector string
local TRefMgmtConnector = {}
TRefMgmtConnector.__index = TRefMgmtConnector
TRefMgmtConnector.group = {}

local function TRefMgmtConnector_from_obj(obj)
    return setmetatable(obj, TRefMgmtConnector)
end

function TRefMgmtConnector.new(RefMgmtConnector)
    return TRefMgmtConnector_from_obj({RefMgmtConnector = RefMgmtConnector})
end
---@param obj MBusinessConnector.RefMgmtConnector
function TRefMgmtConnector:init_from_obj(obj)
    self.RefMgmtConnector = obj.RefMgmtConnector
end

function TRefMgmtConnector:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefMgmtConnector.group)
end

TRefMgmtConnector.from_obj = TRefMgmtConnector_from_obj

TRefMgmtConnector.proto_property = {'RefMgmtConnector'}

TRefMgmtConnector.default = {''}

TRefMgmtConnector.struct = {{name = 'RefMgmtConnector', is_array = false, struct = nil}}

function TRefMgmtConnector:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RefMgmtConnector', self.RefMgmtConnector, 'string', false, errs, need_convert)

    TRefMgmtConnector:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefMgmtConnector.proto_property, errs, need_convert)
    return self
end

function TRefMgmtConnector:unpack(_)
    return self.RefMgmtConnector
end

MBusinessConnector.RefMgmtConnector = TRefMgmtConnector

---@class MBusinessConnector.Ports
---@field Ports def_types.Port[]
local TPorts = {}
TPorts.__index = TPorts
TPorts.group = {}

local function TPorts_from_obj(obj)
    obj.Ports = utils.from_obj(def_types.Port, obj.Ports, true)
    return setmetatable(obj, TPorts)
end

function TPorts.new(Ports)
    return TPorts_from_obj({Ports = Ports})
end
---@param obj MBusinessConnector.Ports
function TPorts:init_from_obj(obj)
    self.Ports = obj.Ports
end

function TPorts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPorts.group)
end

TPorts.from_obj = TPorts_from_obj

TPorts.proto_property = {'Ports'}

TPorts.default = {{}}

TPorts.struct = {{name = 'Ports', is_array = true, struct = def_types.Port.struct}}

function TPorts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.Ports) do
        def_types.Port.new(v.Name, v.ID, v.Offset, v.Width):validate(prefix, errs, need_convert)
    end

    TPorts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPorts.proto_property, errs, need_convert)
    return self
end

function TPorts:unpack(raw)
    return utils.unpack(raw, self.Ports, true)
end

MBusinessConnector.Ports = TPorts

---@class MBusinessConnector.ActualResourceOrder
---@field ActualResourceOrder string[]
local TActualResourceOrder = {}
TActualResourceOrder.__index = TActualResourceOrder
TActualResourceOrder.group = {}

local function TActualResourceOrder_from_obj(obj)
    return setmetatable(obj, TActualResourceOrder)
end

function TActualResourceOrder.new(ActualResourceOrder)
    return TActualResourceOrder_from_obj({ActualResourceOrder = ActualResourceOrder})
end
---@param obj MBusinessConnector.ActualResourceOrder
function TActualResourceOrder:init_from_obj(obj)
    self.ActualResourceOrder = obj.ActualResourceOrder
end

function TActualResourceOrder:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActualResourceOrder.group)
end

TActualResourceOrder.from_obj = TActualResourceOrder_from_obj

TActualResourceOrder.proto_property = {'ActualResourceOrder'}

TActualResourceOrder.default = {{}}

TActualResourceOrder.struct = {{name = 'ActualResourceOrder', is_array = true, struct = nil}}

function TActualResourceOrder:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'ActualResourceOrder', self.ActualResourceOrder, 'string', false, errs,
        need_convert)

    TActualResourceOrder:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActualResourceOrder.proto_property, errs, need_convert)
    return self
end

function TActualResourceOrder:unpack(_)
    return self.ActualResourceOrder
end

MBusinessConnector.ActualResourceOrder = TActualResourceOrder

---@class MBusinessConnector.UpstreamResources
---@field UpstreamResources def_types.Port[]
local TUpstreamResources = {}
TUpstreamResources.__index = TUpstreamResources
TUpstreamResources.group = {}

local function TUpstreamResources_from_obj(obj)
    obj.UpstreamResources = utils.from_obj(def_types.Port, obj.UpstreamResources, true)
    return setmetatable(obj, TUpstreamResources)
end

function TUpstreamResources.new(UpstreamResources)
    return TUpstreamResources_from_obj({UpstreamResources = UpstreamResources})
end
---@param obj MBusinessConnector.UpstreamResources
function TUpstreamResources:init_from_obj(obj)
    self.UpstreamResources = obj.UpstreamResources
end

function TUpstreamResources:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpstreamResources.group)
end

TUpstreamResources.from_obj = TUpstreamResources_from_obj

TUpstreamResources.proto_property = {'UpstreamResources'}

TUpstreamResources.default = {{}}

TUpstreamResources.struct = {{name = 'UpstreamResources', is_array = true, struct = def_types.Port.struct}}

function TUpstreamResources:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.UpstreamResources) do
        def_types.Port.new(v.Name, v.ID, v.Offset, v.Width):validate(prefix, errs, need_convert)
    end

    TUpstreamResources:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpstreamResources.proto_property, errs, need_convert)
    return self
end

function TUpstreamResources:unpack(raw)
    return utils.unpack(raw, self.UpstreamResources, true)
end

MBusinessConnector.UpstreamResources = TUpstreamResources

---@class MBusinessConnector.SilkText
---@field SilkText string
local TSilkText = {}
TSilkText.__index = TSilkText
TSilkText.group = {}

local function TSilkText_from_obj(obj)
    return setmetatable(obj, TSilkText)
end

function TSilkText.new(SilkText)
    return TSilkText_from_obj({SilkText = SilkText})
end
---@param obj MBusinessConnector.SilkText
function TSilkText:init_from_obj(obj)
    self.SilkText = obj.SilkText
end

function TSilkText:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSilkText.group)
end

TSilkText.from_obj = TSilkText_from_obj

TSilkText.proto_property = {'SilkText'}

TSilkText.default = {''}

TSilkText.struct = {{name = 'SilkText', is_array = false, struct = nil}}

function TSilkText:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SilkText', self.SilkText, 'string', false, errs, need_convert)

    TSilkText:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSilkText.proto_property, errs, need_convert)
    return self
end

function TSilkText:unpack(_)
    return self.SilkText
end

MBusinessConnector.SilkText = TSilkText

---@class MBusinessConnector.ConnectorType
---@field ConnectorType string
local TConnectorType = {}
TConnectorType.__index = TConnectorType
TConnectorType.group = {}

local function TConnectorType_from_obj(obj)
    return setmetatable(obj, TConnectorType)
end

function TConnectorType.new(ConnectorType)
    return TConnectorType_from_obj({ConnectorType = ConnectorType})
end
---@param obj MBusinessConnector.ConnectorType
function TConnectorType:init_from_obj(obj)
    self.ConnectorType = obj.ConnectorType
end

function TConnectorType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConnectorType.group)
end

TConnectorType.from_obj = TConnectorType_from_obj

TConnectorType.proto_property = {'ConnectorType'}

TConnectorType.default = {''}

TConnectorType.struct = {{name = 'ConnectorType', is_array = false, struct = nil}}

function TConnectorType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ConnectorType', self.ConnectorType, 'string', false, errs, need_convert)

    TConnectorType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConnectorType.proto_property, errs, need_convert)
    return self
end

function TConnectorType:unpack(_)
    return self.ConnectorType
end

MBusinessConnector.ConnectorType = TConnectorType

---@class MBusinessConnector.MaxLinkRate
---@field MaxLinkRate string
local TMaxLinkRate = {}
TMaxLinkRate.__index = TMaxLinkRate
TMaxLinkRate.group = {}

local function TMaxLinkRate_from_obj(obj)
    return setmetatable(obj, TMaxLinkRate)
end

function TMaxLinkRate.new(MaxLinkRate)
    return TMaxLinkRate_from_obj({MaxLinkRate = MaxLinkRate})
end
---@param obj MBusinessConnector.MaxLinkRate
function TMaxLinkRate:init_from_obj(obj)
    self.MaxLinkRate = obj.MaxLinkRate
end

function TMaxLinkRate:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxLinkRate.group)
end

TMaxLinkRate.from_obj = TMaxLinkRate_from_obj

TMaxLinkRate.proto_property = {'MaxLinkRate'}

TMaxLinkRate.default = {''}

TMaxLinkRate.struct = {{name = 'MaxLinkRate', is_array = false, struct = nil}}

function TMaxLinkRate:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxLinkRate', self.MaxLinkRate, 'string', false, errs, need_convert)

    TMaxLinkRate:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxLinkRate.proto_property, errs, need_convert)
    return self
end

function TMaxLinkRate:unpack(_)
    return self.MaxLinkRate
end

MBusinessConnector.MaxLinkRate = TMaxLinkRate

---@class MBusinessConnector.LinkWidth
---@field LinkWidth string
local TLinkWidth = {}
TLinkWidth.__index = TLinkWidth
TLinkWidth.group = {}

local function TLinkWidth_from_obj(obj)
    return setmetatable(obj, TLinkWidth)
end

function TLinkWidth.new(LinkWidth)
    return TLinkWidth_from_obj({LinkWidth = LinkWidth})
end
---@param obj MBusinessConnector.LinkWidth
function TLinkWidth:init_from_obj(obj)
    self.LinkWidth = obj.LinkWidth
end

function TLinkWidth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkWidth.group)
end

TLinkWidth.from_obj = TLinkWidth_from_obj

TLinkWidth.proto_property = {'LinkWidth'}

TLinkWidth.default = {''}

TLinkWidth.struct = {{name = 'LinkWidth', is_array = false, struct = nil}}

function TLinkWidth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkWidth', self.LinkWidth, 'string', false, errs, need_convert)

    TLinkWidth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkWidth.proto_property, errs, need_convert)
    return self
end

function TLinkWidth:unpack(_)
    return self.LinkWidth
end

MBusinessConnector.LinkWidth = TLinkWidth

---@class MBusinessConnector.Slot
---@field Slot integer
local TSlot = {}
TSlot.__index = TSlot
TSlot.group = {}

local function TSlot_from_obj(obj)
    return setmetatable(obj, TSlot)
end

function TSlot.new(Slot)
    return TSlot_from_obj({Slot = Slot})
end
---@param obj MBusinessConnector.Slot
function TSlot:init_from_obj(obj)
    self.Slot = obj.Slot
end

function TSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlot.group)
end

TSlot.from_obj = TSlot_from_obj

TSlot.proto_property = {'Slot'}

TSlot.default = {0}

TSlot.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slot', self.Slot, 'uint8', false, errs, need_convert)

    TSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlot.proto_property, errs, need_convert)
    return self
end

function TSlot:unpack(_)
    return self.Slot
end

MBusinessConnector.Slot = TSlot

---@class MBusinessConnector.Direction
---@field Direction string
local TDirection = {}
TDirection.__index = TDirection
TDirection.group = {}

local function TDirection_from_obj(obj)
    return setmetatable(obj, TDirection)
end

function TDirection.new(Direction)
    return TDirection_from_obj({Direction = Direction})
end
---@param obj MBusinessConnector.Direction
function TDirection:init_from_obj(obj)
    self.Direction = obj.Direction
end

function TDirection:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDirection.group)
end

TDirection.from_obj = TDirection_from_obj

TDirection.proto_property = {'Direction'}

TDirection.default = {''}

TDirection.struct = {{name = 'Direction', is_array = false, struct = nil}}

function TDirection:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Direction', self.Direction, 'string', false, errs, need_convert)

    TDirection:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDirection.proto_property, errs, need_convert)
    return self
end

function TDirection:unpack(_)
    return self.Direction
end

MBusinessConnector.Direction = TDirection

---@class MBusinessConnector.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj MBusinessConnector.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', false, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

MBusinessConnector.Name = TName

return MBusinessConnector
