-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local def_types = require 'class.types.types'

local MBDFConfig = {}

---@class MBDFConfig.BDFConfigs
---@field BDFConfigs def_types.BDFConfiguration[]
local TBDFConfigs = {}
TBDFConfigs.__index = TBDFConfigs
TBDFConfigs.group = {}

local function TBDFConfigs_from_obj(obj)
    obj.BDFConfigs = utils.from_obj(def_types.BDFConfiguration, obj.BDFConfigs, true)
    return setmetatable(obj, TBDFConfigs)
end

function TBDFConfigs.new(BDFConfigs)
    return TBDFConfigs_from_obj({BDFConfigs = BDFConfigs or def_types.BDFConfiguration.new()})
end
---@param obj MBDFConfig.BDFConfigs
function TBDFConfigs:init_from_obj(obj)
    self.BDFConfigs = obj.BDFConfigs
end

function TBDFConfigs:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBDFConfigs.group)
end

TBDFConfigs.from_obj = TBDFConfigs_from_obj

TBDFConfigs.proto_property = {'BDFConfigs'}

TBDFConfigs.default = {{}}

TBDFConfigs.struct = {{name = 'BDFConfigs', is_array = true, struct = def_types.BDFConfiguration.struct}}

function TBDFConfigs:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.BDFConfigs) do
        def_types.BDFConfiguration.new(v.PortId, v.ControllerIndex, v.Segment, v.Bus, v.Device, v.Function,
            v.Type):validate(prefix, errs, need_convert)
    end

    TBDFConfigs:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBDFConfigs.proto_property, errs, need_convert)
    return self
end

function TBDFConfigs:unpack(raw)
    return utils.unpack(raw, self.BDFConfigs, true)
end

MBDFConfig.BDFConfigs = TBDFConfigs

---@class MBDFConfig.ConfigLength
---@field ConfigLength integer
local TConfigLength = {}
TConfigLength.__index = TConfigLength
TConfigLength.group = {}

local function TConfigLength_from_obj(obj)
    return setmetatable(obj, TConfigLength)
end

function TConfigLength.new(ConfigLength)
    return TConfigLength_from_obj({ConfigLength = ConfigLength or 255})
end
---@param obj MBDFConfig.ConfigLength
function TConfigLength:init_from_obj(obj)
    self.ConfigLength = obj.ConfigLength or 255
end

function TConfigLength:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConfigLength.group)
end

TConfigLength.from_obj = TConfigLength_from_obj

TConfigLength.proto_property = {'ConfigLength'}

TConfigLength.default = {0}

TConfigLength.struct = {{name = 'ConfigLength', is_array = false, struct = nil}}

function TConfigLength:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ConfigLength', self.ConfigLength, 'uint8', false, errs, need_convert)

    TConfigLength:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConfigLength.proto_property, errs, need_convert)
    return self
end

function TConfigLength:unpack(_)
    return self.ConfigLength
end

MBDFConfig.ConfigLength = TConfigLength

---@class MBDFConfig.Type
---@field Type string
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj MBDFConfig.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {''}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'string', false, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

MBDFConfig.Type = TType

---@class MBDFConfig.SocketId
---@field SocketId integer
local TSocketId = {}
TSocketId.__index = TSocketId
TSocketId.group = {}

local function TSocketId_from_obj(obj)
    return setmetatable(obj, TSocketId)
end

function TSocketId.new(SocketId)
    return TSocketId_from_obj({SocketId = SocketId})
end
---@param obj MBDFConfig.SocketId
function TSocketId:init_from_obj(obj)
    self.SocketId = obj.SocketId
end

function TSocketId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSocketId.group)
end

TSocketId.from_obj = TSocketId_from_obj

TSocketId.proto_property = {'SocketId'}

TSocketId.default = {0}

TSocketId.struct = {{name = 'SocketId', is_array = false, struct = nil}}

function TSocketId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SocketId', self.SocketId, 'uint8', false, errs, need_convert)

    TSocketId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSocketId.proto_property, errs, need_convert)
    return self
end

function TSocketId:unpack(_)
    return self.SocketId
end

MBDFConfig.SocketId = TSocketId

return MBDFConfig
