-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-4-27
-- Description: DO NOT EDIT; Code generated by "test_${project_name}.lua.mako"
local skynet = require 'skynet'
require 'skynet.manager'
require 'observability.json_types.Receiver'
local log = require 'mc.logging'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'
local dbus = require 'sd_bus'
local lu = require 'luaunit'
local gvariant = require 'mc.gvariant'
local test_common = require 'test_common.utils'
local vos = require 'utils.vos'
local defs = require 'public.defs'

local function prepare_test_data()
    local test_data_dir = skynet.getenv('TEST_DATA_DIR')
    os.execute('mkdir -p ' .. test_data_dir)
    os.execute('mkdir -p ' .. '/tmp/test_dump')
    if vos.get_file_accessible(defs.SSL_KEY_PATH) then
        os.execute('rm -rf ' .. defs.SSL_KEY_PATH)
    end
end

local function clear_test_data(exit_test)
    log:info('clear test data')
    local test_data_dir = skynet.getenv('TEST_DATA_DIR')
    if not exit_test then return utils.remove_file(test_data_dir) end

    skynet.timeout(0, function()
        skynet.sleep(20)
        skynet.abort()
        utils.remove_file(test_data_dir)
        utils.remove_file('/tmp/test_dump')
    end)
end

local function test_observability_mdb(bus)
    log:info('================ test_observability_mdb ================')
    local ret, obj = pcall(mdb.get_object, bus, '/bmc/kepler/ObservabilityService/Receivers/0',
                           'bmc.kepler.ObservabilityService.Receiver')
    lu.assertEquals(ret, true)
    lu.assertEquals(obj.Address, '')
    lu.assertEquals(obj.Port, 0)
    lu.assertEquals(obj.Protocol, 'OtlpHttp')
    lu.assertEquals(obj.Enabled, false)
    lu.assertEquals(obj.ReceiverId, 0)
end

local function test_attribute_set(bus)
    local ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Receivers/0',
            'org.freedesktop.DBus.Properties', 'Set', 'ssv', 'bmc.kepler.ObservabilityService.Receiver',
            'Enabled', gvariant.new_bool(true))
    end)
    assert(ok)

    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService',
            'org.freedesktop.DBus.Properties', 'Set', 'ssv', 'bmc.kepler.ObservabilityService',
            'Enabled', gvariant.new_bool(true))
    end)
    assert(ok)
end

local function test_observability()
    skynet.sleep(20)
    log:info('================ test start ================')
    local bus = dbus.open_user(true)
    test_observability_mdb(bus)
    test_attribute_set(bus)
    log:info('================ test complete ================')
end

skynet.start(function()
    clear_test_data(false)
    prepare_test_data()
    test_common.dbus_launch()
    skynet.uniqueservice('persistence/service/main')
    skynet.uniqueservice('main')
    skynet.fork(function()
        local ok, err = pcall(test_observability)
        clear_test_data(true)
        if not ok then
            error(err)
        end
    end)
end)
