/* Copyright (c) 2024 Huawei Technologies Co., Ltd.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#ifndef OTEL_UTILS_H
#define OTEL_UTILS_H

#include <lua.hpp>
#include <unordered_map>
#include "opentelemetry/common/attribute_value.h"
#include "logging.h"
namespace Otel {
namespace nostd = opentelemetry::nostd;
using AttributeValue = opentelemetry::common::AttributeValue;
using AttributeMap = std::unordered_map<std::string, AttributeValue>;

namespace Utils {

void get_attributes(lua_State *L, AttributeMap &attributes, int table_idx);
AttributeValue get_attribute_value(lua_State *L, int val_idx);
void initialize_telemetry();

} // namespace Utils
} // namespace Otel

#endif // OTEL_UTILS_H