-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-4-28
-- Description: DO NOT EDIT; Code generated by "service.lua.mako"
local mdb = require 'mc.mdb'
local class = require 'mc.class'
local open_db = require 'observability.db'
local app_base = require 'mc.service_app_base'
local object_manage = require 'mc.mdb.object_manage'
local persist_client = require 'persistence.persist_client_lib'
local orm_classes = require 'observability.orm_classes'
local ok, datas = pcall(require, 'observability.datas')
if not ok then
    datas = nil -- 如果没有datas配置，证明当前组件不需要datas，仅打开数据库
end

local ObservabilityServiceTypes = require 'observability.json_types.ObservabilityService'
local PropertiesTypes = require 'observability.json_types.Properties'
local ReceiverTypes = require 'observability.json_types.Receiver'

local ObservabilityService = mdb.register_object('/bmc/kepler/ObservabilityService', {
    {name = 'bmc.kepler.ObservabilityService', interface = ObservabilityServiceTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function ObservabilityService:ctor()
    self.path = '/bmc/kepler/ObservabilityService'
end

local Receivers = mdb.register_object('/bmc/kepler/ObservabilityService/Receivers/:Id', {
    {name = 'bmc.kepler.ObservabilityService.Receiver', interface = ReceiverTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function Receivers:ctor(Id)
    self.path = '/bmc/kepler/ObservabilityService/Receivers/' .. Id
end

local model = require 'class.model'

local observability_service = class(app_base.Service)

observability_service.package = 'observability'

function observability_service:CreateObservabilityService(prop_setting_cb)
    return object_manage.create_object('ObservabilityService', 'ObservabilityService_0',
        '/bmc/kepler/ObservabilityService', prop_setting_cb)
end

function observability_service:CreateReceivers(Id, prop_setting_cb)
    local path = '/bmc/kepler/ObservabilityService/Receivers/' .. Id
    return object_manage.create_object('Receivers', path, path, prop_setting_cb)
end

function observability_service:ImplObservabilityServicePropertiesGetOptions(cb)
    model.ImplObservabilityServicePropertiesGetOptions(cb)
end

function observability_service:ImplObservabilityServicePropertiesGetPropertiesByOptions(cb)
    model.ImplObservabilityServicePropertiesGetPropertiesByOptions(cb)
end

function observability_service:ImplReceiversReceiverSubmitTestTelemetryData(cb)
    model.ImplReceiversReceiverSubmitTestTelemetryData(cb)
end

function observability_service:ImplReceiversPropertiesGetOptions(cb)
    model.ImplReceiversPropertiesGetOptions(cb)
end

function observability_service:ImplReceiversPropertiesGetPropertiesByOptions(cb)
    model.ImplReceiversPropertiesGetPropertiesByOptions(cb)
end

function observability_service:get_bus()
    return self.bus
end

function observability_service:ctor()
    self.signal_slots = {}
    self.name = self.name or observability_service.package
    self.db = open_db(':memory:', datas)

    orm_classes.init(self.db)
    self.bus:request_name(app_base.Service.get_service_name(self.name))
    model.init(self.bus)
    observability_service.bus = self.bus
end

function observability_service:pre_init()
    observability_service.super.pre_init(self)
    self.persist = persist_client.new(self.bus, self.db, self, {})
    object_manage.set_persist_client(self.persist)
end

function observability_service:init()
    observability_service.super.init(self)
end

return observability_service
