-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-5-7
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Certificate = {}

---@class Certificate.KeyLength
---@field KeyLength integer
local TKeyLength = {}
TKeyLength.__index = TKeyLength
TKeyLength.group = {}

local function TKeyLength_from_obj(obj)
    return setmetatable(obj, TKeyLength)
end

function TKeyLength.new(KeyLength)
    return TKeyLength_from_obj({KeyLength = KeyLength})
end
---@param obj Certificate.KeyLength
function TKeyLength:init_from_obj(obj)
    self.KeyLength = obj.KeyLength
end

function TKeyLength:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TKeyLength.group)
end

TKeyLength.from_obj = TKeyLength_from_obj

TKeyLength.proto_property = {'KeyLength'}

TKeyLength.default = {0}

TKeyLength.struct = {{name = 'KeyLength', is_array = false, struct = nil}}

function TKeyLength:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'KeyLength', self.KeyLength, 'uint32', true, errs, need_convert)

    TKeyLength:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TKeyLength.proto_property, errs, need_convert)
    return self
end

function TKeyLength:unpack(_)
    return self.KeyLength
end

Certificate.KeyLength = TKeyLength

---@class Certificate.CertCount
---@field CertCount integer
local TCertCount = {}
TCertCount.__index = TCertCount
TCertCount.group = {}

local function TCertCount_from_obj(obj)
    return setmetatable(obj, TCertCount)
end

function TCertCount.new(CertCount)
    return TCertCount_from_obj({CertCount = CertCount})
end
---@param obj Certificate.CertCount
function TCertCount:init_from_obj(obj)
    self.CertCount = obj.CertCount
end

function TCertCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCertCount.group)
end

TCertCount.from_obj = TCertCount_from_obj

TCertCount.proto_property = {'CertCount'}

TCertCount.default = {0}

TCertCount.struct = {{name = 'CertCount', is_array = false, struct = nil}}

function TCertCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CertCount', self.CertCount, 'uint32', true, errs, need_convert)

    TCertCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCertCount.proto_property, errs, need_convert)
    return self
end

function TCertCount:unpack(_)
    return self.CertCount
end

Certificate.CertCount = TCertCount

---@class Certificate.CRLExpireTime
---@field CRLExpireTime string
local TCRLExpireTime = {}
TCRLExpireTime.__index = TCRLExpireTime
TCRLExpireTime.group = {}

local function TCRLExpireTime_from_obj(obj)
    return setmetatable(obj, TCRLExpireTime)
end

function TCRLExpireTime.new(CRLExpireTime)
    return TCRLExpireTime_from_obj({CRLExpireTime = CRLExpireTime})
end
---@param obj Certificate.CRLExpireTime
function TCRLExpireTime:init_from_obj(obj)
    self.CRLExpireTime = obj.CRLExpireTime
end

function TCRLExpireTime:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCRLExpireTime.group)
end

TCRLExpireTime.from_obj = TCRLExpireTime_from_obj

TCRLExpireTime.proto_property = {'CRLExpireTime'}

TCRLExpireTime.default = {''}

TCRLExpireTime.struct = {{name = 'CRLExpireTime', is_array = false, struct = nil}}

function TCRLExpireTime:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CRLExpireTime', self.CRLExpireTime, 'string', true, errs, need_convert)

    TCRLExpireTime:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCRLExpireTime.proto_property, errs, need_convert)
    return self
end

function TCRLExpireTime:unpack(_)
    return self.CRLExpireTime
end

Certificate.CRLExpireTime = TCRLExpireTime

---@class Certificate.CRLStartTime
---@field CRLStartTime string
local TCRLStartTime = {}
TCRLStartTime.__index = TCRLStartTime
TCRLStartTime.group = {}

local function TCRLStartTime_from_obj(obj)
    return setmetatable(obj, TCRLStartTime)
end

function TCRLStartTime.new(CRLStartTime)
    return TCRLStartTime_from_obj({CRLStartTime = CRLStartTime})
end
---@param obj Certificate.CRLStartTime
function TCRLStartTime:init_from_obj(obj)
    self.CRLStartTime = obj.CRLStartTime
end

function TCRLStartTime:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCRLStartTime.group)
end

TCRLStartTime.from_obj = TCRLStartTime_from_obj

TCRLStartTime.proto_property = {'CRLStartTime'}

TCRLStartTime.default = {''}

TCRLStartTime.struct = {{name = 'CRLStartTime', is_array = false, struct = nil}}

function TCRLStartTime:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CRLStartTime', self.CRLStartTime, 'string', true, errs, need_convert)

    TCRLStartTime:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCRLStartTime.proto_property, errs, need_convert)
    return self
end

function TCRLStartTime:unpack(_)
    return self.CRLStartTime
end

Certificate.CRLStartTime = TCRLStartTime

---@class Certificate.CommonName
---@field CommonName string
local TCommonName = {}
TCommonName.__index = TCommonName
TCommonName.group = {}

local function TCommonName_from_obj(obj)
    return setmetatable(obj, TCommonName)
end

function TCommonName.new(CommonName)
    return TCommonName_from_obj({CommonName = CommonName})
end
---@param obj Certificate.CommonName
function TCommonName:init_from_obj(obj)
    self.CommonName = obj.CommonName
end

function TCommonName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCommonName.group)
end

TCommonName.from_obj = TCommonName_from_obj

TCommonName.proto_property = {'CommonName'}

TCommonName.default = {''}

TCommonName.struct = {{name = 'CommonName', is_array = false, struct = nil}}

function TCommonName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CommonName', self.CommonName, 'string', true, errs, need_convert)

    TCommonName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCommonName.proto_property, errs, need_convert)
    return self
end

function TCommonName:unpack(_)
    return self.CommonName
end

Certificate.CommonName = TCommonName

---@class Certificate.FilePath
---@field FilePath string
local TFilePath = {}
TFilePath.__index = TFilePath
TFilePath.group = {}

local function TFilePath_from_obj(obj)
    return setmetatable(obj, TFilePath)
end

function TFilePath.new(FilePath)
    return TFilePath_from_obj({FilePath = FilePath})
end
---@param obj Certificate.FilePath
function TFilePath:init_from_obj(obj)
    self.FilePath = obj.FilePath
end

function TFilePath:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFilePath.group)
end

TFilePath.from_obj = TFilePath_from_obj

TFilePath.proto_property = {'FilePath'}

TFilePath.default = {''}

TFilePath.struct = {{name = 'FilePath', is_array = false, struct = nil}}

function TFilePath:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FilePath', self.FilePath, 'string', true, errs, need_convert)

    TFilePath:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFilePath.proto_property, errs, need_convert)
    return self
end

function TFilePath:unpack(_)
    return self.FilePath
end

Certificate.FilePath = TFilePath

---@class Certificate.ValidNotBefore
---@field ValidNotBefore string
local TValidNotBefore = {}
TValidNotBefore.__index = TValidNotBefore
TValidNotBefore.group = {}

local function TValidNotBefore_from_obj(obj)
    return setmetatable(obj, TValidNotBefore)
end

function TValidNotBefore.new(ValidNotBefore)
    return TValidNotBefore_from_obj({ValidNotBefore = ValidNotBefore})
end
---@param obj Certificate.ValidNotBefore
function TValidNotBefore:init_from_obj(obj)
    self.ValidNotBefore = obj.ValidNotBefore
end

function TValidNotBefore:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TValidNotBefore.group)
end

TValidNotBefore.from_obj = TValidNotBefore_from_obj

TValidNotBefore.proto_property = {'ValidNotBefore'}

TValidNotBefore.default = {''}

TValidNotBefore.struct = {{name = 'ValidNotBefore', is_array = false, struct = nil}}

function TValidNotBefore:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ValidNotBefore', self.ValidNotBefore, 'string', true, errs, need_convert)

    TValidNotBefore:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TValidNotBefore.proto_property, errs, need_convert)
    return self
end

function TValidNotBefore:unpack(_)
    return self.ValidNotBefore
end

Certificate.ValidNotBefore = TValidNotBefore

---@class Certificate.ValidNotAfter
---@field ValidNotAfter string
local TValidNotAfter = {}
TValidNotAfter.__index = TValidNotAfter
TValidNotAfter.group = {}

local function TValidNotAfter_from_obj(obj)
    return setmetatable(obj, TValidNotAfter)
end

function TValidNotAfter.new(ValidNotAfter)
    return TValidNotAfter_from_obj({ValidNotAfter = ValidNotAfter})
end
---@param obj Certificate.ValidNotAfter
function TValidNotAfter:init_from_obj(obj)
    self.ValidNotAfter = obj.ValidNotAfter
end

function TValidNotAfter:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TValidNotAfter.group)
end

TValidNotAfter.from_obj = TValidNotAfter_from_obj

TValidNotAfter.proto_property = {'ValidNotAfter'}

TValidNotAfter.default = {''}

TValidNotAfter.struct = {{name = 'ValidNotAfter', is_array = false, struct = nil}}

function TValidNotAfter:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ValidNotAfter', self.ValidNotAfter, 'string', true, errs, need_convert)

    TValidNotAfter:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TValidNotAfter.proto_property, errs, need_convert)
    return self
end

function TValidNotAfter:unpack(_)
    return self.ValidNotAfter
end

Certificate.ValidNotAfter = TValidNotAfter

---@class Certificate.Subject
---@field Subject string
local TSubject = {}
TSubject.__index = TSubject
TSubject.group = {}

local function TSubject_from_obj(obj)
    return setmetatable(obj, TSubject)
end

function TSubject.new(Subject)
    return TSubject_from_obj({Subject = Subject})
end
---@param obj Certificate.Subject
function TSubject:init_from_obj(obj)
    self.Subject = obj.Subject
end

function TSubject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubject.group)
end

TSubject.from_obj = TSubject_from_obj

TSubject.proto_property = {'Subject'}

TSubject.default = {''}

TSubject.struct = {{name = 'Subject', is_array = false, struct = nil}}

function TSubject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Subject', self.Subject, 'string', true, errs, need_convert)

    TSubject:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubject.proto_property, errs, need_convert)
    return self
end

function TSubject:unpack(_)
    return self.Subject
end

Certificate.Subject = TSubject

---@class Certificate.SignatureAlgorithm
---@field SignatureAlgorithm string
local TSignatureAlgorithm = {}
TSignatureAlgorithm.__index = TSignatureAlgorithm
TSignatureAlgorithm.group = {}

local function TSignatureAlgorithm_from_obj(obj)
    return setmetatable(obj, TSignatureAlgorithm)
end

function TSignatureAlgorithm.new(SignatureAlgorithm)
    return TSignatureAlgorithm_from_obj({SignatureAlgorithm = SignatureAlgorithm})
end
---@param obj Certificate.SignatureAlgorithm
function TSignatureAlgorithm:init_from_obj(obj)
    self.SignatureAlgorithm = obj.SignatureAlgorithm
end

function TSignatureAlgorithm:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSignatureAlgorithm.group)
end

TSignatureAlgorithm.from_obj = TSignatureAlgorithm_from_obj

TSignatureAlgorithm.proto_property = {'SignatureAlgorithm'}

TSignatureAlgorithm.default = {''}

TSignatureAlgorithm.struct = {{name = 'SignatureAlgorithm', is_array = false, struct = nil}}

function TSignatureAlgorithm:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SignatureAlgorithm', self.SignatureAlgorithm, 'string', true, errs, need_convert)

    TSignatureAlgorithm:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSignatureAlgorithm.proto_property, errs, need_convert)
    return self
end

function TSignatureAlgorithm:unpack(_)
    return self.SignatureAlgorithm
end

Certificate.SignatureAlgorithm = TSignatureAlgorithm

---@class Certificate.SerialNumber
---@field SerialNumber string
local TSerialNumber = {}
TSerialNumber.__index = TSerialNumber
TSerialNumber.group = {}

local function TSerialNumber_from_obj(obj)
    return setmetatable(obj, TSerialNumber)
end

function TSerialNumber.new(SerialNumber)
    return TSerialNumber_from_obj({SerialNumber = SerialNumber})
end
---@param obj Certificate.SerialNumber
function TSerialNumber:init_from_obj(obj)
    self.SerialNumber = obj.SerialNumber
end

function TSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialNumber.group)
end

TSerialNumber.from_obj = TSerialNumber_from_obj

TSerialNumber.proto_property = {'SerialNumber'}

TSerialNumber.default = {''}

TSerialNumber.struct = {{name = 'SerialNumber', is_array = false, struct = nil}}

function TSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, 'string', true, errs, need_convert)

    TSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialNumber.proto_property, errs, need_convert)
    return self
end

function TSerialNumber:unpack(_)
    return self.SerialNumber
end

Certificate.SerialNumber = TSerialNumber

---@class Certificate.KeyUsage
---@field KeyUsage integer[]
local TKeyUsage = {}
TKeyUsage.__index = TKeyUsage
TKeyUsage.group = {}

local function TKeyUsage_from_obj(obj)
    return setmetatable(obj, TKeyUsage)
end

function TKeyUsage.new(KeyUsage)
    return TKeyUsage_from_obj({KeyUsage = KeyUsage})
end
---@param obj Certificate.KeyUsage
function TKeyUsage:init_from_obj(obj)
    self.KeyUsage = obj.KeyUsage
end

function TKeyUsage:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TKeyUsage.group)
end

TKeyUsage.from_obj = TKeyUsage_from_obj

TKeyUsage.proto_property = {'KeyUsage'}

TKeyUsage.default = {{}}

TKeyUsage.struct = {{name = 'KeyUsage', is_array = true, struct = nil}}

function TKeyUsage:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'KeyUsage', self.KeyUsage, 'uint32', true, errs, need_convert)

    TKeyUsage:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TKeyUsage.proto_property, errs, need_convert)
    return self
end

function TKeyUsage:unpack(_)
    return self.KeyUsage
end

Certificate.KeyUsage = TKeyUsage

---@class Certificate.Issuer
---@field Issuer string
local TIssuer = {}
TIssuer.__index = TIssuer
TIssuer.group = {}

local function TIssuer_from_obj(obj)
    return setmetatable(obj, TIssuer)
end

function TIssuer.new(Issuer)
    return TIssuer_from_obj({Issuer = Issuer})
end
---@param obj Certificate.Issuer
function TIssuer:init_from_obj(obj)
    self.Issuer = obj.Issuer
end

function TIssuer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIssuer.group)
end

TIssuer.from_obj = TIssuer_from_obj

TIssuer.proto_property = {'Issuer'}

TIssuer.default = {''}

TIssuer.struct = {{name = 'Issuer', is_array = false, struct = nil}}

function TIssuer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Issuer', self.Issuer, 'string', true, errs, need_convert)

    TIssuer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIssuer.proto_property, errs, need_convert)
    return self
end

function TIssuer:unpack(_)
    return self.Issuer
end

Certificate.Issuer = TIssuer

---@class Certificate.FingerprintHashAlgorithm
---@field FingerprintHashAlgorithm string
local TFingerprintHashAlgorithm = {}
TFingerprintHashAlgorithm.__index = TFingerprintHashAlgorithm
TFingerprintHashAlgorithm.group = {}

local function TFingerprintHashAlgorithm_from_obj(obj)
    return setmetatable(obj, TFingerprintHashAlgorithm)
end

function TFingerprintHashAlgorithm.new(FingerprintHashAlgorithm)
    return TFingerprintHashAlgorithm_from_obj({FingerprintHashAlgorithm = FingerprintHashAlgorithm})
end
---@param obj Certificate.FingerprintHashAlgorithm
function TFingerprintHashAlgorithm:init_from_obj(obj)
    self.FingerprintHashAlgorithm = obj.FingerprintHashAlgorithm
end

function TFingerprintHashAlgorithm:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFingerprintHashAlgorithm.group)
end

TFingerprintHashAlgorithm.from_obj = TFingerprintHashAlgorithm_from_obj

TFingerprintHashAlgorithm.proto_property = {'FingerprintHashAlgorithm'}

TFingerprintHashAlgorithm.default = {''}

TFingerprintHashAlgorithm.struct = {{name = 'FingerprintHashAlgorithm', is_array = false, struct = nil}}

function TFingerprintHashAlgorithm:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FingerprintHashAlgorithm', self.FingerprintHashAlgorithm, 'string', true, errs,
        need_convert)

    TFingerprintHashAlgorithm:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFingerprintHashAlgorithm.proto_property, errs, need_convert)
    return self
end

function TFingerprintHashAlgorithm:unpack(_)
    return self.FingerprintHashAlgorithm
end

Certificate.FingerprintHashAlgorithm = TFingerprintHashAlgorithm

---@class Certificate.Fingerprint
---@field Fingerprint string
local TFingerprint = {}
TFingerprint.__index = TFingerprint
TFingerprint.group = {}

local function TFingerprint_from_obj(obj)
    return setmetatable(obj, TFingerprint)
end

function TFingerprint.new(Fingerprint)
    return TFingerprint_from_obj({Fingerprint = Fingerprint})
end
---@param obj Certificate.Fingerprint
function TFingerprint:init_from_obj(obj)
    self.Fingerprint = obj.Fingerprint
end

function TFingerprint:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFingerprint.group)
end

TFingerprint.from_obj = TFingerprint_from_obj

TFingerprint.proto_property = {'Fingerprint'}

TFingerprint.default = {''}

TFingerprint.struct = {{name = 'Fingerprint', is_array = false, struct = nil}}

function TFingerprint:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Fingerprint', self.Fingerprint, 'string', true, errs, need_convert)

    TFingerprint:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFingerprint.proto_property, errs, need_convert)
    return self
end

function TFingerprint:unpack(_)
    return self.Fingerprint
end

Certificate.Fingerprint = TFingerprint

---@class Certificate.CertificateUsageType
---@field CertificateUsageType integer
local TCertificateUsageType = {}
TCertificateUsageType.__index = TCertificateUsageType
TCertificateUsageType.group = {}

local function TCertificateUsageType_from_obj(obj)
    return setmetatable(obj, TCertificateUsageType)
end

function TCertificateUsageType.new(CertificateUsageType)
    return TCertificateUsageType_from_obj({CertificateUsageType = CertificateUsageType})
end
---@param obj Certificate.CertificateUsageType
function TCertificateUsageType:init_from_obj(obj)
    self.CertificateUsageType = obj.CertificateUsageType
end

function TCertificateUsageType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCertificateUsageType.group)
end

TCertificateUsageType.from_obj = TCertificateUsageType_from_obj

TCertificateUsageType.proto_property = {'CertificateUsageType'}

TCertificateUsageType.default = {0}

TCertificateUsageType.struct = {{name = 'CertificateUsageType', is_array = false, struct = nil}}

function TCertificateUsageType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CertificateUsageType', self.CertificateUsageType, 'uint32', true, errs, need_convert)

    TCertificateUsageType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCertificateUsageType.proto_property, errs, need_convert)
    return self
end

function TCertificateUsageType:unpack(_)
    return self.CertificateUsageType
end

Certificate.CertificateUsageType = TCertificateUsageType

---@class Certificate.CertificateType
---@field CertificateType integer
local TCertificateType = {}
TCertificateType.__index = TCertificateType
TCertificateType.group = {}

local function TCertificateType_from_obj(obj)
    return setmetatable(obj, TCertificateType)
end

function TCertificateType.new(CertificateType)
    return TCertificateType_from_obj({CertificateType = CertificateType})
end
---@param obj Certificate.CertificateType
function TCertificateType:init_from_obj(obj)
    self.CertificateType = obj.CertificateType
end

function TCertificateType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCertificateType.group)
end

TCertificateType.from_obj = TCertificateType_from_obj

TCertificateType.proto_property = {'CertificateType'}

TCertificateType.default = {0}

TCertificateType.struct = {{name = 'CertificateType', is_array = false, struct = nil}}

function TCertificateType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CertificateType', self.CertificateType, 'uint32', true, errs, need_convert)

    TCertificateType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCertificateType.proto_property, errs, need_convert)
    return self
end

function TCertificateType:unpack(_)
    return self.CertificateType
end

Certificate.CertificateType = TCertificateType

---@class Certificate.DeleteCRLRsp
local TDeleteCRLRsp = {}
TDeleteCRLRsp.__index = TDeleteCRLRsp
TDeleteCRLRsp.group = {}

local function TDeleteCRLRsp_from_obj(obj)
    return setmetatable(obj, TDeleteCRLRsp)
end

function TDeleteCRLRsp.new()
    return TDeleteCRLRsp_from_obj({})
end
---@param obj Certificate.DeleteCRLRsp
function TDeleteCRLRsp:init_from_obj(obj)

end

function TDeleteCRLRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteCRLRsp.group)
end

TDeleteCRLRsp.from_obj = TDeleteCRLRsp_from_obj

TDeleteCRLRsp.proto_property = {}

TDeleteCRLRsp.default = {}

TDeleteCRLRsp.struct = {}

function TDeleteCRLRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDeleteCRLRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteCRLRsp.proto_property, errs, need_convert)
    return self
end

function TDeleteCRLRsp:unpack(_)
end

Certificate.DeleteCRLRsp = TDeleteCRLRsp

---@class Certificate.DeleteCRLReq
local TDeleteCRLReq = {}
TDeleteCRLReq.__index = TDeleteCRLReq
TDeleteCRLReq.group = {}

local function TDeleteCRLReq_from_obj(obj)
    return setmetatable(obj, TDeleteCRLReq)
end

function TDeleteCRLReq.new()
    return TDeleteCRLReq_from_obj({})
end
---@param obj Certificate.DeleteCRLReq
function TDeleteCRLReq:init_from_obj(obj)

end

function TDeleteCRLReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteCRLReq.group)
end

TDeleteCRLReq.from_obj = TDeleteCRLReq_from_obj

TDeleteCRLReq.proto_property = {}

TDeleteCRLReq.default = {}

TDeleteCRLReq.struct = {}

function TDeleteCRLReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDeleteCRLReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteCRLReq.proto_property, errs, need_convert)
    return self
end

function TDeleteCRLReq:unpack(_)
end

Certificate.DeleteCRLReq = TDeleteCRLReq

Certificate.interface = mdb.register_interface('bmc.kepler.CertificateService.Certificate', {
    CertificateType = {'u', nil, true, nil, false},
    CertificateUsageType = {'u', nil, true, nil, false},
    Fingerprint = {'s', nil, true, nil, false},
    FingerprintHashAlgorithm = {'s', nil, true, nil, false},
    Issuer = {'s', nil, true, nil, false},
    KeyUsage = {'au', nil, true, nil, false},
    SerialNumber = {'s', nil, true, nil, false},
    SignatureAlgorithm = {'s', nil, true, nil, false},
    Subject = {'s', nil, true, nil, false},
    ValidNotAfter = {'s', nil, true, nil, false},
    ValidNotBefore = {'s', nil, true, nil, false},
    FilePath = {'s', nil, true, nil, false},
    CommonName = {'s', nil, true, nil, false},
    CRLStartTime = {'s', nil, true, nil, false},
    CRLExpireTime = {'s', nil, true, nil, false},
    CertCount = {'u', nil, true, nil, false},
    KeyLength = {'u', nil, true, nil, false}
}, {DeleteCRL = {'a{ss}', '', TDeleteCRLReq, TDeleteCRLRsp}}, {})

return Certificate
