-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-4-28
-- Description: DO NOT EDIT; Code generated by "client.lua.mako"
local mdb = require 'mc.mdb'
local class = require 'mc.class'
local app_base = require 'mc.client_app_base'
local mdb_service = require 'mc.mdb.mdb_service'
local subscribe_signal = require 'mc.mdb.subscribe_signal'

local get_non_virtual_interface_objects = mdb_service.get_non_virtual_interface_objects
local foreach_non_virtual_interface_objects = mdb_service.foreach_non_virtual_interface_objects

local CertificateService = require 'observability.json_types.CertificateService'
local Certificate = require 'observability.json_types.Certificate'
local Observability = require 'observability.json_types.Observability'

---@class observability_client: BasicClient
local observability_client = class(app_base.Client)

function observability_client:GetCertificateObjects()
    return get_non_virtual_interface_objects(self:get_bus(), 'bmc.kepler.CertificateService.Certificate', true)
end

function observability_client:ForeachCertificateObjects(cb)
    return foreach_non_virtual_interface_objects(self:get_bus(), 'bmc.kepler.CertificateService.Certificate', cb, true)
end

function observability_client:GetCertificateServiceCertificateServiceObject()
    return mdb.try_get_object(self:get_bus(), '/bmc/kepler/CertificateService', 'bmc.kepler.CertificateService')
end

function observability_client:OnCertificateServiceInterfacesAdded(cb)
    local path_namespace = '/bmc/kepler/CertificateService'
    self.signal_slots[#self.signal_slots + 1] = subscribe_signal.on_interfaces_added(self:get_bus(), path_namespace, cb,
        'bmc.kepler.CertificateService')
end

function observability_client:OnCertificateServiceInterfacesRemoved(cb)
    local path_namespace = '/bmc/kepler/CertificateService'
    self.signal_slots[#self.signal_slots + 1] = subscribe_signal.on_interfaces_removed(self:get_bus(), path_namespace,
        cb, 'bmc.kepler.CertificateService')
end

function observability_client:OnCertificatePropertiesChanged(cb)
    self.signal_slots[#self.signal_slots + 1] = subscribe_signal.on_properties_changed(self:get_bus(), '/bmc', cb,
        'bmc.kepler.CertificateService.Certificate', {'FilePath'})
end

function observability_client:OnCertificateInterfacesAdded(cb)
    self.signal_slots[#self.signal_slots + 1] = subscribe_signal.on_interfaces_added(self:get_bus(), '/bmc', cb,
        'bmc.kepler.CertificateService.Certificate')
end

function observability_client:OnCertificateInterfacesRemoved(cb)
    self.signal_slots[#self.signal_slots + 1] = subscribe_signal.on_interfaces_removed(self:get_bus(), '/bmc', cb,
        'bmc.kepler.CertificateService.Certificate')
end

function observability_client:GetDashboardObservabilityObject()
    return mdb.try_get_object(self:get_bus(), '/bmc/kepler/Dashboard', 'bmc.kepler.Dashboard.Observability')
end

function observability_client:OnObservabilityInterfacesAdded(cb)
    local path_namespace = '/bmc/kepler/Dashboard'
    self.signal_slots[#self.signal_slots + 1] = subscribe_signal.on_interfaces_added(self:get_bus(), path_namespace, cb,
        'bmc.kepler.Dashboard.Observability')
end

function observability_client:OnObservabilityInterfacesRemoved(cb)
    local path_namespace = '/bmc/kepler/Dashboard'
    self.signal_slots[#self.signal_slots + 1] = subscribe_signal.on_interfaces_removed(self:get_bus(), path_namespace,
        cb, 'bmc.kepler.Dashboard.Observability')
end

---@param CertificateUsageType CertificateService.CertificateUsageType
---@return CertificateService.GetCertPathRsp
function observability_client:CertificateServiceCertificateServiceGetCertPath(ctx, CertificateUsageType)
    local req = CertificateService.GetCertPathReq.new(CertificateUsageType):validate()
    local obj = self:GetCertificateServiceCertificateServiceObject()

    return CertificateService.GetCertPathRsp.new(obj:GetCertPath(ctx, req:unpack(true)))
end

function observability_client:PCertificateServiceCertificateServiceGetCertPath(ctx, CertificateUsageType)
    return pcall(function()
        local req = CertificateService.GetCertPathReq.new(CertificateUsageType):validate()
        local obj = self:GetCertificateServiceCertificateServiceObject()

        return CertificateService.GetCertPathRsp.new(obj:GetCertPath(ctx, req:unpack(true)))
    end)
end

---@param CertificateUsageType CertificateService.CertificateUsageType
---@param Type string
---@param Content string
---@param Id integer
---@return CertificateService.ImportCertRsp
function observability_client:CertificateServiceCertificateServiceImportCert(ctx, CertificateUsageType, Type, Content,
    Id)
    local req = CertificateService.ImportCertReq.new(CertificateUsageType, Type, Content, Id):validate()
    local obj = self:GetCertificateServiceCertificateServiceObject()

    return CertificateService.ImportCertRsp.new(obj:ImportCert(ctx, req:unpack(true)))
end

function observability_client:PCertificateServiceCertificateServiceImportCert(ctx, CertificateUsageType, Type, Content,
    Id)
    return pcall(function()
        local req = CertificateService.ImportCertReq.new(CertificateUsageType, Type, Content, Id):validate()
        local obj = self:GetCertificateServiceCertificateServiceObject()

        return CertificateService.ImportCertRsp.new(obj:ImportCert(ctx, req:unpack(true)))
    end)
end

---@param CertificateUsageType CertificateService.CertificateUsageType
---@param Type string
---@param Content string
---@param Key string
---@return CertificateService.ImportCertWithKeyRsp
function observability_client:CertificateServiceCertificateServiceImportCertWithKey(ctx, CertificateUsageType, Type,
    Content, Key)
    local req = CertificateService.ImportCertWithKeyReq.new(CertificateUsageType, Type, Content, Key):validate()
    local obj = self:GetCertificateServiceCertificateServiceObject()

    return CertificateService.ImportCertWithKeyRsp.new(obj:ImportCertWithKey(ctx, req:unpack(true)))
end

function observability_client:PCertificateServiceCertificateServiceImportCertWithKey(ctx, CertificateUsageType, Type,
    Content, Key)
    return pcall(function()
        local req = CertificateService.ImportCertWithKeyReq.new(CertificateUsageType, Type, Content, Key):validate()
        local obj = self:GetCertificateServiceCertificateServiceObject()

        return CertificateService.ImportCertWithKeyRsp.new(obj:ImportCertWithKey(ctx, req:unpack(true)))
    end)
end

---@param Country string
---@param State string
---@param Location string
---@param OrgName string
---@param OrgUnit string
---@param CommonName string
---@param AlternativeNames string[]
---@return CertificateService.StartGenerateCSRRsp
function observability_client:CertificateServiceCertificateServiceStartGenerateCSR(ctx, Country, State, Location,
    OrgName, OrgUnit, CommonName, AlternativeNames)
    local req = CertificateService.StartGenerateCSRReq.new(Country, State, Location, OrgName, OrgUnit, CommonName,
        AlternativeNames):validate()
    local obj = self:GetCertificateServiceCertificateServiceObject()

    return CertificateService.StartGenerateCSRRsp.new(obj:StartGenerateCSR(ctx, req:unpack(true)))
end

function observability_client:PCertificateServiceCertificateServiceStartGenerateCSR(ctx, Country, State, Location,
    OrgName, OrgUnit, CommonName, AlternativeNames)
    return pcall(function()
        local req = CertificateService.StartGenerateCSRReq.new(Country, State, Location, OrgName, OrgUnit, CommonName,
            AlternativeNames):validate()
        local obj = self:GetCertificateServiceCertificateServiceObject()

        return CertificateService.StartGenerateCSRRsp.new(obj:StartGenerateCSR(ctx, req:unpack(true)))
    end)
end

---@param Country string
---@param State string
---@param Location string
---@param OrgName string
---@param OrgUnit string
---@param CommonName string
---@param AlternativeNames string[]
---@param KeyUsage string[]
---@param KeyBitLength integer
---@param Options CertificateService.CSRProperty
---@return CertificateService.GenerateCSRRsp
function observability_client:CertificateServiceCertificateServiceGenerateCSR(ctx, Country, State, Location, OrgName,
    OrgUnit, CommonName, AlternativeNames, KeyUsage, KeyBitLength, Options)
    local req = CertificateService.GenerateCSRReq.new(Country, State, Location, OrgName, OrgUnit, CommonName,
        AlternativeNames, KeyUsage, KeyBitLength, Options):validate()
    local obj = self:GetCertificateServiceCertificateServiceObject()

    return CertificateService.GenerateCSRRsp.new(obj:GenerateCSR(ctx, req:unpack(true)))
end

function observability_client:PCertificateServiceCertificateServiceGenerateCSR(ctx, Country, State, Location, OrgName,
    OrgUnit, CommonName, AlternativeNames, KeyUsage, KeyBitLength, Options)
    return pcall(function()
        local req = CertificateService.GenerateCSRReq.new(Country, State, Location, OrgName, OrgUnit, CommonName,
            AlternativeNames, KeyUsage, KeyBitLength, Options):validate()
        local obj = self:GetCertificateServiceCertificateServiceObject()

        return CertificateService.GenerateCSRRsp.new(obj:GenerateCSR(ctx, req:unpack(true)))
    end)
end

---@param Path string
---@return CertificateService.ExportCSRRsp
function observability_client:CertificateServiceCertificateServiceExportCSR(ctx, Path)
    local req = CertificateService.ExportCSRReq.new(Path):validate()
    local obj = self:GetCertificateServiceCertificateServiceObject()

    return CertificateService.ExportCSRRsp.new(obj:ExportCSR(ctx, req:unpack(true)))
end

function observability_client:PCertificateServiceCertificateServiceExportCSR(ctx, Path)
    return pcall(function()
        local req = CertificateService.ExportCSRReq.new(Path):validate()
        local obj = self:GetCertificateServiceCertificateServiceObject()

        return CertificateService.ExportCSRRsp.new(obj:ExportCSR(ctx, req:unpack(true)))
    end)
end

---@param CertificateUsageType CertificateService.CertificateUsageType
---@return CertificateService.ExportCertKeyByFIFORsp
function observability_client:CertificateServiceCertificateServiceExportCertKeyByFIFO(ctx, CertificateUsageType)
    local req = CertificateService.ExportCertKeyByFIFOReq.new(CertificateUsageType):validate()
    local obj = self:GetCertificateServiceCertificateServiceObject()

    return CertificateService.ExportCertKeyByFIFORsp.new(obj:ExportCertKeyByFIFO(ctx, req:unpack(true)))
end

function observability_client:PCertificateServiceCertificateServiceExportCertKeyByFIFO(ctx, CertificateUsageType)
    return pcall(function()
        local req = CertificateService.ExportCertKeyByFIFOReq.new(CertificateUsageType):validate()
        local obj = self:GetCertificateServiceCertificateServiceObject()

        return CertificateService.ExportCertKeyByFIFORsp.new(obj:ExportCertKeyByFIFO(ctx, req:unpack(true)))
    end)
end

---@param CertificateUsageType CertificateService.CertificateUsageType
---@param Id integer
---@return CertificateService.DeleteCertRsp
function observability_client:CertificateServiceCertificateServiceDeleteCert(ctx, CertificateUsageType, Id)
    local req = CertificateService.DeleteCertReq.new(CertificateUsageType, Id):validate()
    local obj = self:GetCertificateServiceCertificateServiceObject()

    return CertificateService.DeleteCertRsp.new(obj:DeleteCert(ctx, req:unpack(true)))
end

function observability_client:PCertificateServiceCertificateServiceDeleteCert(ctx, CertificateUsageType, Id)
    return pcall(function()
        local req = CertificateService.DeleteCertReq.new(CertificateUsageType, Id):validate()
        local obj = self:GetCertificateServiceCertificateServiceObject()

        return CertificateService.DeleteCertRsp.new(obj:DeleteCert(ctx, req:unpack(true)))
    end)
end

---@param CertificateUsageType CertificateService.CertificateUsageType
---@param Id integer
---@return CertificateService.GetCertChainInfoRsp
function observability_client:CertificateServiceCertificateServiceGetCertChainInfo(ctx, CertificateUsageType, Id)
    local req = CertificateService.GetCertChainInfoReq.new(CertificateUsageType, Id):validate()
    local obj = self:GetCertificateServiceCertificateServiceObject()

    return CertificateService.GetCertChainInfoRsp.new(obj:GetCertChainInfo(ctx, req:unpack(true)))
end

function observability_client:PCertificateServiceCertificateServiceGetCertChainInfo(ctx, CertificateUsageType, Id)
    return pcall(function()
        local req = CertificateService.GetCertChainInfoReq.new(CertificateUsageType, Id):validate()
        local obj = self:GetCertificateServiceCertificateServiceObject()

        return CertificateService.GetCertChainInfoRsp.new(obj:GetCertChainInfo(ctx, req:unpack(true)))
    end)
end

---@param Country string
---@param CommonName string
---@param OrgName string
---@return CertificateService.SetDefaultSSLCertSubjectRsp
function observability_client:CertificateServiceCertificateServiceSetDefaultSSLCertSubject(ctx, Country, CommonName,
    OrgName)
    local req = CertificateService.SetDefaultSSLCertSubjectReq.new(Country, CommonName, OrgName):validate()
    local obj = self:GetCertificateServiceCertificateServiceObject()

    return CertificateService.SetDefaultSSLCertSubjectRsp.new(obj:SetDefaultSSLCertSubject(ctx, req:unpack(true)))
end

function observability_client:PCertificateServiceCertificateServiceSetDefaultSSLCertSubject(ctx, Country, CommonName,
    OrgName)
    return pcall(function()
        local req = CertificateService.SetDefaultSSLCertSubjectReq.new(Country, CommonName, OrgName):validate()
        local obj = self:GetCertificateServiceCertificateServiceObject()

        return CertificateService.SetDefaultSSLCertSubjectRsp.new(obj:SetDefaultSSLCertSubject(ctx, req:unpack(true)))
    end)
end

---@param Type string
---@param Content string
---@param CertId integer
---@return CertificateService.ImportCRLRsp
function observability_client:CertificateServiceCertificateServiceImportCRL(ctx, Type, Content, CertId)
    local req = CertificateService.ImportCRLReq.new(Type, Content, CertId):validate()
    local obj = self:GetCertificateServiceCertificateServiceObject()

    return CertificateService.ImportCRLRsp.new(obj:ImportCRL(ctx, req:unpack(true)))
end

function observability_client:PCertificateServiceCertificateServiceImportCRL(ctx, Type, Content, CertId)
    return pcall(function()
        local req = CertificateService.ImportCRLReq.new(Type, Content, CertId):validate()
        local obj = self:GetCertificateServiceCertificateServiceObject()

        return CertificateService.ImportCRLRsp.new(obj:ImportCRL(ctx, req:unpack(true)))
    end)
end

---@return CertificateService.GetCSRContentRsp
function observability_client:CertificateServiceCertificateServiceGetCSRContent(ctx)
    local obj = self:GetCertificateServiceCertificateServiceObject()

    return CertificateService.GetCSRContentRsp.new(obj:GetCSRContent(ctx))
end

function observability_client:PCertificateServiceCertificateServiceGetCSRContent(ctx)
    return pcall(function()
        local obj = self:GetCertificateServiceCertificateServiceObject()

        return CertificateService.GetCSRContentRsp.new(obj:GetCSRContent(ctx))
    end)
end

---@param Property string
---@return CertificateService.GetCSRPropertyRsp
function observability_client:CertificateServiceCertificateServiceGetCSRProperty(ctx, Property)
    local req = CertificateService.GetCSRPropertyReq.new(Property):validate()
    local obj = self:GetCertificateServiceCertificateServiceObject()

    return CertificateService.GetCSRPropertyRsp.new(obj:GetCSRProperty(ctx, req:unpack(true)))
end

function observability_client:PCertificateServiceCertificateServiceGetCSRProperty(ctx, Property)
    return pcall(function()
        local req = CertificateService.GetCSRPropertyReq.new(Property):validate()
        local obj = self:GetCertificateServiceCertificateServiceObject()

        return CertificateService.GetCSRPropertyRsp.new(obj:GetCSRProperty(ctx, req:unpack(true)))
    end)
end

---@param Property CertificateService.CSRProperty
---@return CertificateService.SetCSRPropertyRsp
function observability_client:CertificateServiceCertificateServiceSetCSRProperty(ctx, Property)
    local req = CertificateService.SetCSRPropertyReq.new(Property):validate()
    local obj = self:GetCertificateServiceCertificateServiceObject()

    return CertificateService.SetCSRPropertyRsp.new(obj:SetCSRProperty(ctx, req:unpack(true)))
end

function observability_client:PCertificateServiceCertificateServiceSetCSRProperty(ctx, Property)
    return pcall(function()
        local req = CertificateService.SetCSRPropertyReq.new(Property):validate()
        local obj = self:GetCertificateServiceCertificateServiceObject()

        return CertificateService.SetCSRPropertyRsp.new(obj:SetCSRProperty(ctx, req:unpack(true)))
    end)
end

function observability_client:ctor()
    self.signal_slots = {}
end

---@type observability_client
return observability_client.new('observability')
