-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-4-28
-- Description: DO NOT EDIT; Code generated by "model.lua.mako"
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local observability_service_class_types = require 'class.types.ObservabilityService'
local observability_service_intf_types = require 'observability.json_types.ObservabilityService'
local properties_intf_types = require 'observability.json_types.Properties'
local receiver_intf_types = require 'observability.json_types.Receiver'

local ObservabilityService = {
    ['table_name'] = 't_observability',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'PoweroffPer'},
            ['primaryKey'] = true,
            ['validator'] = observability_service_class_types.Id
        }
    },
    ['default_props'] = {['Id'] = observability_service_class_types.Id.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.ObservabilityService'] = {
            ['Enabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = false,
                ['description'] = '遥测使能状态',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'DiagnoseMgmt'}},
                ['validator'] = observability_service_intf_types.Enabled
            },
            ['TLSMode'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = 'TLS',
                ['description'] = '遥测认证方式,TLS:单向,mTLS:双向',
                ['enum'] = {'TLS', 'mTLS'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'DiagnoseMgmt'}},
                ['validator'] = observability_service_intf_types.TLSMode
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/ObservabilityService'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.ObservabilityService'] = {
            ['property_defaults'] = {['Enabled'] = false, ['TLSMode'] = 'TLS'},
            ['privileges'] = {
                ['props'] = {
                    ['Enabled'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.DiagnoseMgmt},
                    ['TLSMode'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.DiagnoseMgmt}
                }
            },
            ['interface_types'] = observability_service_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local Receivers = {
    ['table_name'] = 't_observability_receivers',
    ['mdb_prop_configs'] = {
        ['bmc.kepler.ObservabilityService.Receiver'] = {
            ['ReceiverId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = 0,
                ['description'] = '接收端序号',
                ['usage'] = {'PoweroffPer'},
                ['primaryKey'] = true,
                ['validator'] = receiver_intf_types.ReceiverId
            },
            ['Enabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = false,
                ['description'] = '接收端使能状态',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'DiagnoseMgmt'}},
                ['validator'] = receiver_intf_types.Enabled
            },
            ['Address'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = '',
                ['description'] = '接收端地址',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'DiagnoseMgmt'}},
                ['validator'] = receiver_intf_types.Address
            },
            ['Port'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = 0,
                ['description'] = '接收端端口',
                ['minimum'] = 0,
                ['maximum'] = 65535,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'DiagnoseMgmt'}},
                ['validator'] = receiver_intf_types.Port
            },
            ['Protocol'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = 'OtlpHttp',
                ['description'] = '传输协议',
                ['enum'] = {'OtlpHttp'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'DiagnoseMgmt'}},
                ['validator'] = receiver_intf_types.Protocol
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.ObservabilityService.Receiver'] = {['SubmitTestTelemetryData'] = {['req'] = {}, ['rsp'] = {}}},
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/ObservabilityService/Receivers/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.ObservabilityService.Receiver'] = {
            ['property_defaults'] = {
                ['ReceiverId'] = 0,
                ['Enabled'] = false,
                ['Address'] = '',
                ['Port'] = 0,
                ['Protocol'] = 'OtlpHttp'
            },
            ['privileges'] = {
                ['props'] = {
                    ['Enabled'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.DiagnoseMgmt},
                    ['Address'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.DiagnoseMgmt},
                    ['Port'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.DiagnoseMgmt},
                    ['Protocol'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.DiagnoseMgmt}
                }
            },
            ['interface_types'] = receiver_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local M = {}

function M.init(bus)
    class('ObservabilityService', ObservabilityService):set_bus(bus)
    class('Receivers', Receivers):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplObservabilityServicePropertiesGetOptions(cb)
    class('ObservabilityService')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplObservabilityServicePropertiesGetPropertiesByOptions(cb)
    class('ObservabilityService')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplReceiversReceiverSubmitTestTelemetryData(cb)
    class('Receivers')['bmc.kepler.ObservabilityService.Receiver'].SubmitTestTelemetryData = function(obj, ctx, ...)
        local req = receiver_intf_types.SubmitTestTelemetryDataReq.new(...):validate(nil, nil, true)
        local rsp = receiver_intf_types.SubmitTestTelemetryDataRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplReceiversPropertiesGetOptions(cb)
    class('Receivers')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplReceiversPropertiesGetPropertiesByOptions(cb)
    class('Receivers')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

return M
