# observability

提供 BMC 可观测性服务

## 项目结构

```
.
├── src/                    # 源代码目录
│   └── lualib-src/        # Lua 库源代码
│       └── otel/          # OpenTelemetry 相关实现
│           ├── common/    # 通用组件和工具
│           ├── logs/      # 日志收集和处理
│           ├── metrics/   # 指标收集和处理
│           ├── trace/     # 分布式追踪
│           ├── utils/     # 工具函数
│           └── CMakeLists.txt
├── test/                  # 测试目录
│   ├── integration/       # 集成测试
│   ├── unit/             # 单元测试
│   └── .test_temp_data/  # 测试临时数据
├── proto/                 # Protocol Buffers 定义文件
├── gen/                   # 生成的代码
├── mds/                   # 模型定义文件
├── temp/                  # 临时文件目录
├── .vscode/              # VSCode 配置
├── CMakeLists.txt        # 顶层 CMake 配置
├── Makefile              # 构建脚本
├── conanfile.py          # Conan 包管理配置
├── conanbase.py          # Conan 基础配置
├── permissions.ini       # 权限配置文件
├── LICENSE               # 许可证文件
└── CHANGELOG.md          # 变更日志
```

## 功能模块说明

### 源代码 (src/)

#### OpenTelemetry 实现 (otel/)
- **通用组件 (common/)**
  - 提供 OpenTelemetry 的基础设施和共享组件
  - 包含配置管理、上下文传播等核心功能

- **日志模块 (logs/)**
  - 实现 OpenTelemetry 日志收集和处理
  - 支持结构化日志格式
  - 提供日志解析和转换功能

- **指标模块 (metrics/)**
  - 实现 OpenTelemetry 指标收集和处理
  - 支持计数器、仪表盘等指标类型
  - 提供指标聚合和导出功能

- **追踪模块 (trace/)**
  - 实现分布式追踪功能
  - 支持请求链路追踪
  - 提供采样和上下文传播

- **工具函数 (utils/)**
  - 提供通用工具函数
  - 包含辅助方法和工具类

### 测试 (test/)

- **单元测试 (unit/)**
  - 测试各个模块的独立功能
  - 包含测试用例和测试数据

- **集成测试 (integration/)**
  - 测试模块间的交互
  - 验证系统整体功能

### 其他目录

- **proto/**: Protocol Buffers 定义文件，用于数据序列化
- **gen/**: 自动生成的代码文件
- **mds/**: 模型定义文件
- **temp/**: 临时文件存储目录

## 构建系统

项目使用以下构建工具：

- **CMake**: 主要构建系统
  - 顶层 `CMakeLists.txt`: 项目整体配置
  - `otel/CMakeLists.txt`: OpenTelemetry 模块配置

- **Conan**: 包管理
  - `conanfile.py`: 包依赖配置
  - `conanbase.py`: 基础构建配置

- **Makefile**: 提供便捷的构建命令

## 开发环境

- VSCode 配置位于 `.vscode/` 目录
- 权限配置在 `permissions.ini` 文件中

## 许可证

详见 [LICENSE](LICENSE) 文件

## 变更日志

详见 [CHANGELOG.md](CHANGELOG.md)