-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local lu = require 'luaunit'
local event = require 'infrastructure.event'
local debounce = require 'mc.debounce.debounce'
local client = require 'network_adapter.client'
local mdb = require 'mc.mdb'

Test_event = {}

function Test_event:test_generate_om_event()
    local obj = {
        path = '/bmc/kepler/Systems/1/Events'
    }
    client.obj = obj
    client.ForeachEventsObjects = function(self, cb)
        cb(self.obj)
    end
    event.generate_om_event("123", true, '123', 'test', 'type')
    client.obj = {
        path = '/bmc/kepler/Systems/1/Events2'
    }
    client.obj.AddEvent_PACKED = function(obj, param)
        if param[1][1] == '123' then
            return '0'
        else
            return '1'
        end
    end
    event.generate_om_event("234", true, '123', 'test', 'type')
end

function Test_event:test_get_latest_alarm_list()
    local EVENTS_PATH = '/bmc/kepler/Systems/1/Events'
    local EVENTS_INTF = 'bmc.kepler.Systems.Events'
    local list = {{
        MappingTable = {{ Key = 2 }, { Key = 3 }}
    }, {
        MappingTable = {{ Key = 2 }, { Key = 2 }}
    }}
    local test_pcall = {
        GetAlarmList_PACKED = function()
            if event.event_obj.test == 1 then
                return true, { EventList = list }
            elseif event.event_obj.test == 2 then
                return true, {}
            else
                return false, {}
            end
        end
    }
    mdb.get_object = function(obj, path, intf)
        if path == EVENTS_PATH then
            return { pcall = test_pcall, test = 1 }
        end
        if intf == EVENTS_INTF then
            return { pcall = {}, test = 2 }
        end
        return { pcall = {}, test = 3 }
    end
    event.event_obj = nil
    local bus = {}
    event.get_latest_alarm_list(bus)
    EVENTS_PATH = '/bmc/kepler/Systems/1/Events1'
    mdb.get_object(bus, EVENTS_PATH, EVENTS_INTF)
    event.get_latest_alarm_list(bus)
    EVENTS_INTF = 'bmc.kepler.Systems.Events1'
    mdb.get_object(bus, EVENTS_PATH, EVENTS_INTF)
    event.get_latest_alarm_list(bus)
end
