-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local QLE2742_HUA_SP = require 'hardware_config.QLE2742'
local qlogic = QLE2742_HUA_SP.mctp_pldm()

-- 测试套件
TestPldmQle = {}

-- 测试获取芯片温度
function TestPldmQle:test_get_chiptemp()
    -- 测试参数
    local data = string.char(0x02, 0x00, 0x00,0x00, 0x00, 0x00, 0x4e, 0x00)

    -- 执行测试
    local result = qlogic.properties.ChipTemp.response(data)

    -- 验证成功结果
    lu.assertEquals(result, 0x4e)

    -- 测试参数
    data = string.char(0x02, 0x01, 0x00,0x00, 0x00, 0x00, 0x4e, 0x00)

    -- 执行测试
    result = qlogic.properties.ChipTemp.response(data)

    -- 验证状态校验失败结果
    lu.assertEquals(result, 0xffff)

    -- 测试参数
    data = string.char(0x01, 0x01, 0x00,0x00, 0x00, 0x00, 0x4e, 0x00)

    -- 执行测试
    result = qlogic.properties.ChipTemp.response(data)

    -- 验证长度校验失败结果
    lu.assertEquals(result, 0xffff)
end

-- 测试获取端口linkspeed
function TestPldmQle:test_get_linkspeed()
    -- 测试参数
    local data = string.char(0x02, 0x00, 0x00,0x00, 0x00, 0x00, 0x4e, 0x00)

    -- 执行测试
    local result = qlogic.properties.Port0LinkSpeed.response(data)

    -- 验证成功结果
    lu.assertEquals(result, 0x4e)

    -- 测试参数
    data = string.char(0x02, 0x01, 0x00,0x00, 0x00, 0x00, 0x4e, 0x00)

    -- 执行测试
    result = qlogic.properties.Port0LinkSpeed.response(data)

    -- 验证状态校验失败结果
    lu.assertEquals(result, 0x0)

    -- 测试参数
    data = string.char(0x01, 0x01, 0x00,0x00, 0x00, 0x00, 0x4e, 0x00)

    -- 执行测试
    result = qlogic.properties.Port0LinkSpeed.response(data)

    -- 验证长度校验失败结果
    lu.assertEquals(result, 0x0)
end

-- 测试获取端口LinkStatus
function TestPldmQle:test_get_linkstatus()
    -- 测试参数
    local data = string.char(0x00, 0x00, 0x00, 0x00, 0x00)

    -- 执行测试
    local result = qlogic.properties.Port0LinkStatus.response(data)

    -- 验证结果
    lu.assertEquals(result, 'Disconnected')

    -- 测试参数
    data = string.char(0x00, 0x00, 0x01, 0x00, 0x00)

    -- 执行测试
    result = qlogic.properties.Port0LinkStatus.response(data)

    -- 验证结果
    lu.assertEquals(result, 'Connected')

    -- 测试参数
    data = string.char(0x00, 0x01, 0x00, 0x00, 0x00)

    -- 执行测试
    result = qlogic.properties.Port0LinkStatus.response(data)

    -- 验证状态校验失败结果
    lu.assertEquals(result, 'N/A')
end

-- 测试获取网卡FW
function TestPldmQle:test_get_firmware_version()
    -- 测试参数
    local data = string.char(0x00, 0x01, 0x23, 0x5)

    -- 执行测试
    local result = qlogic.properties.FirmwareVersion.response(data)

    -- 验证结果
    lu.assertEquals(result, '5.35.01')
end

-- 测试获取端口WWNN
function TestPldmQle:test_get_wwnn()
    -- 测试参数
    local data = string.char(0x00, 0xdf, 0x23, 0x5, 0x11, 0x22, 0x34, 0x56)

    -- 执行测试
    local result = qlogic.properties.Port0WorkWWNN.response(data)

    -- 验证结果
    lu.assertEquals(result, '00:df:23:05:11:22:34:56')
end