-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local sdbus = require 'sd_bus'
local app_base = require 'mc.app_base'
local test_common = require 'test_common.utils'
local dbus_sms = require 'dbus_sms'
local json = require 'cjson'

return function(work)
    local app = app_base.new('host_agent')
    local is_exit = false
    local bus = test_common.dbus_launch('../.dbus', nil, true)
    bus:request_name(app.service_name)

    local sms = dbus_sms.new(bus)

    local vtbl = sdbus.new_vtable(app.app_path, app.app_interface)
    vtbl:add_method('exit', '', '', function()
        is_exit = true
    end)
    vtbl:add_method('update', 's', '', function(data)
        sms:update(json.decode(data))
    end)
    bus:regist_vtable(vtbl)

    local vtbl_status = sdbus.new_vtable('/bmc/kepler/Systems/1/Sms',
        'bmc.kepler.Systems.Sms.SmsStatus')

    local state = 0
    vtbl_status:add_property_r('State', 'y', function()
        return state
    end)

    bus:regist_vtable(vtbl_status)

    work:recv()

    bus.bus:run_until(function()
        return is_exit
    end, 500000)
end
