-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

loadfile(os.getenv('CONFIG_FILE'), 't', {package = package, os = os})()
package.path = './test_bma/?.lua;' .. package.path

local utils = require 'utils.core'
local logging = require 'mc.logging'
local current_file_dir = debug.getinfo(1).source:match('@?(.*)/')
utils.chdir(current_file_dir)
logging:setPrint(nil)
logging:setLevel(logging.INFO)

local lu = require('luaunit')

require 'test_hardware_config.test_e810'
require 'test_hardware_config.test_pldm_qle'
require 'test_infrastructure.test_om_event_handler'
require 'test_infrastructure.test_event'
require 'test_infrastructure.test_fructl'
require 'test_infrastructure.test_log'
require 'test_hdk_cmd'
require 'device.class.test_network_adapter'
require 'device.class.test_device_manager'
require 'device.class.test_network_port'
require 'device.class.test_optical_module'
require 'device.class.test_card_npu'
require 'test_bma'
require 'test_ncsi'
require 'test_out_of_band_mgmt'
require 'test_event_mgmt'
require 'test_ncsi_protocol.test_ncsi_core'
require 'test_ncsi_protocol.test_ncsi_oem_response'
require 'test_ncsi_protocol.test_ncsi_oem_lldp'
require 'test_ncsi_protocol.test_ncsi_oem_log'
require 'test_ncsi_protocol.test_ncsi_aen'
require 'test_ncsi_protocol.test_ncsi_broadcast_filter'
require 'test_ncsi_protocol.test_ncsi_capabilities'
require 'test_ncsi_protocol.test_ncsi_channel_init'
require 'test_ncsi_protocol.test_ncsi_channel_tx'
require 'test_ncsi_protocol.test_ncsi_channel'
require 'test_ncsi_protocol.test_ncsi_clear_state'
require 'test_ncsi_protocol.test_ncsi_get_status'
require 'test_ncsi_protocol.test_ncsi_init'
require 'test_ncsi_protocol.test_ncsi_mac'
require 'test_ncsi_protocol.test_ncsi_multicast_filter'
require 'test_ncsi_protocol.test_ncsi_package'
require 'test_ncsi_protocol.test_ncsi_socket'
require 'test_ncsi_protocol.test_ncsi_version'
require 'test_ncsi_protocol.test_ncsi_vlan_mode'
require 'test_ncsi_protocol.test_ncsi_vlan_filter'

os.exit(lu.LuaUnit.run())
