-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local utils = require 'mc.utils'
local utils_core = require 'utils.core'
local log = require 'mc.logging'
local lu = require 'luaunit'
local skynet = require 'skynet'
local log_collect = require 'device.class.log_collector'

local TestLogDump = {}

function TestLogDump.test_log_dump_cb()
    log:info('-------------------test log_dump_cb start-------------------')

    local project_dir = os.getenv('PROJECT_DIR')
    local test_data_dir = project_dir .. '/' .. skynet.getenv('TEST_DATA_DIR')
    local test_log_src_path = test_data_dir .. 'test_log'
    os.execute('mkdir -p ' .. test_log_src_path)
    local fp_w = io.open(test_log_src_path .. '/log.bin', 'w+')
    lu.assertEquals(fp_w ~= nil, true)
    pcall(function()
        fp_w:write('aabbccddeeff')
    end)
    io.close(fp_w)
    log_collect.pcie_card_log_base_dir = test_log_src_path
    log_collect.optical_module_info_dir = test_log_src_path
    log_collect.npu_port_info_base_path = test_log_src_path
    local dir_path = test_data_dir .. 'dump_log'
    os.execute('mkdir -p ' .. dir_path)
    log_collect.log_dump_cb(dir_path)

    local fp_r = io.open(dir_path .. '/test_log/log.bin', 'r')
    lu.assertEquals(fp_r ~= nil, true)
    io.close(fp_r)

    local err_path = test_data_dir .. 'test_dump/'
    os.execute('mkdir -p ' .. err_path)
    local ret = pcall(log_collect.log_dump_cb, err_path)
    lu.assertEquals(ret, true)

    log:info('-------------------test log_dump_cb end-------------------')
end

function TestLogDump.test_monitor_pmu_status()
    log:info('-------------------test monitor_pmu_status start-------------------')

    log_collect.monitor_pmu_status()

    log:info('-------------------test monitor_pmu_status end-------------------')
end

function TestLogDump.test_init(bus)
    log:info('-------------------test init start-------------------')

    log_collect.init(bus)

    log:info('-------------------test init end-------------------')
end

function TestLogDump.test_get_log_dir()
    log:info('-------------------test get_smbus_log_dir start-------------------')

    log_collect.pcie_card_log_base_dir = '/data/'
    local mds_obj = {}
    mds_obj.DeviceLocator = nil
    local ret = log_collect.get_smbus_log_dir(mds_obj)
    lu.assertEquals(ret, nil)

    mds_obj.DeviceLocator = 'netcard name'
    ret = log_collect.get_smbus_log_dir(mds_obj)
    lu.assertEquals(ret, nil)

    mds_obj.Name = 'cel name'
    ret = log_collect.get_smbus_log_dir(mds_obj)
    lu.assertEquals(ret, '/data/smbus_netcardname_celname/')

    log:info('-------------------test get_smbus_log_dir end-------------------')
end

function TestLogDump.test_create_dir()
    log:info('-------------------test create_dir start-------------------')

    local test_data_dir = skynet.getenv('TEST_DATA_DIR')
    local log_dir = test_data_dir .. 'test_log_path'
    local ret = log_collect.create_dir(log_dir)
    lu.assertEquals(ret, true)

    log:info('-------------------test create_dir end-------------------')
end

function TestLogDump.test_delete_old_log_file()
    log:info('-------------------test delete_old_log_file start-------------------')

    local test_data_dir = skynet.getenv('TEST_DATA_DIR')
    local log_dir = test_data_dir .. 'test_log_path/'
    os.execute('touch ' .. log_dir .. 'aa')
    os.execute('touch ' .. log_dir .. 'bb')
    os.execute('touch ' .. log_dir .. 'cc')
    os.execute('touch ' .. log_dir .. 'dd')
    os.execute('touch ' .. log_dir .. 'ee')
    local curr_log_files = {'bb', 'ee'}
    log_collect.delete_old_log_file(log_dir, curr_log_files)
    lu.assertEquals(utils_core.is_file(log_dir .. 'aa'), false)

    log:info('-------------------test delete_old_log_file end-------------------')
end

return TestLogDump
