-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local skynet = require 'skynet'
local sdbus = require 'sd_bus'
local log = require 'mc.logging'
local utils = require 'mc.utils'
local test_common = require 'test_common.utils'
require 'skynet.manager'
require 'network_adapter.json_types.NetworkAdapter'
require 'network_adapter.json_types.NetworkAdapters'
require 'network_adapter.json_types.NetworkPort'
require 'network_adapter.json_types.Manufacture'
require 'ipmi'

local ipmi_fuzz = require 'FuzzNetworkAdapterIpmiCmds'
local mdb_fuzz = require 'FuzzModel'
-- 准备测试专用路径
local function prepare_test_data()
    log:info('- prepare test data')
    local test_data_dir = skynet.getenv('TEST_DATA_DIR')
    local dir_list = { 'apps/chassis/mds', 'apps/hwdiscovery/mds', 'apps/frudata/mds', 'apps/sensor/mds',
        'apps/ipmi_core/mds', 'sr', 'data', 'usr/lib64' }
    for _, path in pairs(dir_list) do
        os.execute('mkdir -p ' .. test_data_dir .. '/' .. path)
    end
    os.execute('tar -xzvf temp/test_data/apps/hwproxy/mockdata.tar.gz -C ' .. test_data_dir .. 'data')
    utils.copy_file('temp/usr/lib64/mock/libsoc_adapter_it.so',
        test_data_dir .. '/usr/lib64/libsoc_adapter.so')
    utils.copy_file('test/fuzz/test_data/14100513_BCU_01.csr',
        test_data_dir .. '/sr/14100513_BCU_01.sr')
    utils.copy_file('test/fuzz/test_data/14100513_EXU_01.csr',
        test_data_dir .. '/sr/14100513_EXU_01.sr')
    utils.copy_file('test/fuzz/test_data/root.csr', test_data_dir .. '/sr/root.sr')
    utils.copy_file('mds/schema.json', test_data_dir .. '/apps/chassis/mds/schema.json')
    utils.copy_file('temp/opt/bmc/apps/hwdiscovery/mds/schema.json',
        test_data_dir .. '/apps/hwdiscovery/mds/schema.json')
    utils.copy_file('temp/opt/bmc/apps/frudata/mds/schema.json',
        test_data_dir .. '/apps/frudata/mds/schema.json')
    utils.copy_file('temp/opt/bmc/apps/sensor/mds/schema.json',
        test_data_dir .. '/apps/sensor/mds/schema.json')
    utils.copy_file('temp/opt/bmc/apps/ipmi_core/mds/schema.json',
        test_data_dir .. '/apps/ipmi_core/mds/schema.json')
end

-- 删除路径
local function clear_test_data(exit_test)
    log:info('clear test data')
    local test_data_dir = skynet.getenv('TEST_DATA_DIR')
    if not exit_test then
        return utils.remove_file(test_data_dir)
    end

    skynet.timeout(0, function()
        skynet.sleep(20)
        skynet.abort()
        utils.remove_file(test_data_dir)
    end)
end

local function fuzz_main()
    log:info('================ fuzz test start ================')
    local bus = sdbus.open_user(true)
    -- 调用自动生成的fuzz用例
    ipmi_fuzz.fuzz_test(bus)
    mdb_fuzz.fuzz_test(bus)
    log:info('================ fuzz test complete ================')
end

skynet.start(function()
    clear_test_data(false)
    prepare_test_data()
    test_common.dbus_launch()
    skynet.uniqueservice('sd_bus')
    skynet.uniqueservice('persistence/service/main')
    skynet.uniqueservice('maca/service/main')
    skynet.uniqueservice('main')
    skynet.uniqueservice('hwdiscovery/service/main')
    skynet.uniqueservice('ipmi_core/service/main')
    skynet.sleep(200)
    skynet.fork(function()
        local ok, err = pcall(fuzz_main)
        clear_test_data(true)
        if not ok then
            log:error('=== test failed ===: %s', err)
        end
    end)
end)
