-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local skynet = require 'skynet'
local ncsi_info = require 'ncsi.ncsi_info'
local ncsi_comm = require 'ncsi.ncsi_comm'
local ncsi_worker = require 'ncsi.ncsi_worker'

local ncsi_service = {}
ncsi_service.__index = ncsi_service

function ncsi_service.new(db, bus)
    return setmetatable({db = db, bus = bus,
        ncsi_info = ncsi_info.new(db, bus),
        work = ncsi_worker.new(),
        ncsi_comm = ncsi_comm.new()}, ncsi_service)
end

function ncsi_service:init()
end

return ncsi_service
