-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local worker = require 'worker.core'
local log = require 'mc.logging'

local ncsi_set_worker = {}
ncsi_set_worker.__index = ncsi_set_worker

function ncsi_set_worker.new()
    local work = worker.new(5)  -- 消息队列长度5
    work:start_module('ncsi.ncsi_set_task')
    log:notice('ncsi set worker start!')
    return setmetatable({work = work}, ncsi_set_worker)
end

function ncsi_set_worker:send(msg)
    return self.work:send(msg)
end

return ncsi_set_worker
