-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local bs = require 'mc.bitstring'

local ncsi_def = {}

ncsi_def.NCSI_FAIL = 1
ncsi_def.NCSI_SUCCESS = 0
ncsi_def.CMD_COMPLETED = 0x0000
ncsi_def.PACKET_HEAD_LEN = 16
ncsi_def.ETHERNET_HEAD_LEN = 14
ncsi_def.NCSI_MC_ID = 0
ncsi_def.PACKET_ALL_LEN = 1160

ncsi_def.ethernet_header_bs = bs.new([[<<
    des_addr:6/string,
    src_addr:6/string,
    ether_type:16
>>]])

ncsi_def.ctl_packet_header_bs = bs.new([[<<
    mc_id:8,
    header_revision:8,
    reserved:8,
    iid:8,
    packet_type:8,
    channel_id:5,
    package_id:3,
    payload_len_hi:4,
    reserved1:4,
    payload_len_lo:8,
    reserved2:32/signed,
    reserved3:32/signed
>>]])

return ncsi_def