-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local ncsi_def = require 'ncsi.ncsi_protocol.ncsi_def'
local ncsi_broadcast_filter = require 'ncsi.ncsi_protocol.ncsi_broadcast_filter'
local ncsi_multicast_filter = require 'ncsi.ncsi_protocol.ncsi_multicast_filter'
local ncsi_mac = require 'ncsi.ncsi_protocol.ncsi_mac'
local ncsi_vlan_mode = require 'ncsi.ncsi_protocol.ncsi_vlan_mode'
local ncsi_aen = require 'ncsi.ncsi_protocol.ncsi_aen'
local ncsi_parameter = require 'ncsi.ncsi_protocol.ncsi_parameter'

local ncsi_channel_init = {}

local INTEL_MANUFACTURE_ID = 0x57010000
local BCM_MANUFACTURE_ID = 0x3d110000
local MULEX__MANUFACTURE_ID = 0x6c00000
local MAC_FILTER_NUM_PHYSICAL = 1

-- 初始化通道配置，设置MAC过滤、广播过滤、多播过滤等
function ncsi_channel_init.initial_channel(package_id, channel_id, eth_name)
    local ncsi_para = ncsi_parameter.get_instance():get_ncsi_parameter()

    -- 设置物理MAC地址过滤
    local ret = ncsi_mac.ncsi_set_phy_mac_filter(package_id, channel_id, eth_name, MAC_FILTER_NUM_PHYSICAL)
    if ret ~= ncsi_def.NCSI_SUCCESS then
        log:error('set physical mac addr filter failed')
        return
    end

    -- 启用广播过滤
    ret = ncsi_broadcast_filter.ncsi_enable_brdcast_filter(package_id, channel_id, eth_name)
    if ret ~= ncsi_def.NCSI_SUCCESS then
        log:error('ncsi_enable_brdcast_filter failed')
        return
    end

    -- 根据制造商ID启用多播过滤
    log:debug('manufacture id is: %x', ncsi_para.manufacture_id)
    local multicast_filter_cap = ncsi_para.multicast_filter_cap
    if ncsi_para.manufacture_id == BCM_MANUFACTURE_ID or
        ncsi_para.manufacture_id == MULEX__MANUFACTURE_ID or
        ncsi_para.manufacture_id == INTEL_MANUFACTURE_ID then
        multicast_filter_cap = nil
    end
    ret = ncsi_multicast_filter.ncsi_enable_multicast_filter(package_id, channel_id, eth_name, multicast_filter_cap)
    if ret ~= ncsi_def.NCSI_SUCCESS then
        return
    end

    -- 禁用VLAN请求
    ret = ncsi_vlan_mode.ncsi_disable_vlan_req(package_id, channel_id, eth_name)
    if ret ~= ncsi_def.NCSI_SUCCESS then
        return
    end

    -- 启用AEN - 直接调用ncsi_aen模块的函数
    ncsi_aen.ncsi_aen_enable(package_id, channel_id, eth_name)
end

return ncsi_channel_init