-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local c_object_manage = require 'mc.orm.object_manage'
local c_network_port = require 'device.class.network_port'
local port_comm = require 'port_comm'
local port_defs = require 'port_defs'
local port_manage = require 'port_manage'

local port_init = {}

local function init_id(orm_obj)
    local retry_times = 0

    -- bridge 不通过devicelocator生成ID信息
    if port_comm.is_virtual_port(orm_obj.Type) then
        return
    end
    local parent = orm_obj.parent
    while not parent or parent.NodeId == '' and retry_times < 10 do
        retry_times = retry_times + 1
        orm_obj.tasks:sleep_ms(1000)
    end
    orm_obj.NetworkAdapterId = parent.NodeId
    orm_obj.NodeId = parent.NodeId .. (orm_obj.PortID + 1)
    orm_obj.t_port_prop_without_bma = {
        LinkStatus = port_defs.INVALID_DATA_STRING
    }
    orm_obj:register_mdb_objects()
end

local function listen_device_obj_property_change(device_obj, orm_obj)

end

local function synchronize_property(device_obj, orm_obj)

end

function port_init.init(device_obj, orm_obj)
    -- 先启监听设备树对象属性变化，更新对应的资源树对象属性
    listen_device_obj_property_change(device_obj, orm_obj)
    -- 再将设备树对象属性赋值给对应资源树对象
    synchronize_property(device_obj, orm_obj)
    init_id(orm_obj)
    c_network_port.super.init(orm_obj)
    local parent = device_obj.parent
    if parent and string.find(parent.NodeId, 'ROH') then
        return
    end
    if parent and parent.ChipModel == port_defs.NPU_MODEL then
        log:notice('NPU%s port init start', parent.SlotNumber)
        port_manage.init_npu_port(orm_obj)
    else
        orm_obj.na_object_name, orm_obj.np_object_name = orm_obj.path:match('([^/]+)/Ports/([^/]+)')
        orm_obj.vlans = c_object_manage.get_instance().app:CreateVLANs(1, orm_obj.na_object_name,
            orm_obj.np_object_name,
                function(obj)
                obj.NetworkPortObjectName = orm_obj.na_object_name .. orm_obj.np_object_name
                local mdb_object = obj:get_mdb_object('bmc.kepler.Systems.NetworkPort.VLANs')
                rawset(mdb_object, 'get_parent', function()
                    return orm_obj
                end)
            end)

        orm_obj:connect_signal(orm_obj.on_add_object_complete, function()
            port_manage.register_property_changed_callback(orm_obj)
        end)
        orm_obj:next_tick(port_manage.update_mac_addr_from_db, orm_obj)
    end
end

return port_init
