-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local c_network_port = require 'device.class.network_port'
local skynet = require 'skynet'
local port_init = require 'port_mgmt.port_init'
local class = require 'mc.class'
local singleton = require 'mc.singleton'
local log = require 'mc.logging'
local card_mgmt = require 'card_mgmt'

local port_mgmt = class()

local function get_all_port_device_obj()
    return {}
end

function port_mgmt:create_port_orm_object(port_device_obj)
    c_network_port.__table({
        PortID = port_device_obj.PortId,
        NetworkAdapterId = port_device_obj.NetworkAdapterId,
        IsDevice = true -- 标识orm对象来源于设备树对象
    }):save()
    skynet.sleep(10)
    local port_orm_obj = c_network_port.collection:find({
        PortID = port_device_obj.PortId,
        NetworkAdapterId = port_device_obj.NetworkAdapterId
    })
    return port_orm_obj
end

function port_mgmt:on_add_port_device_obj()
    local port_device_obj
    self:init_obj(port_device_obj)
end

-- 光模块资源树对象创建后，注册到网口的子对象集合中
function port_mgmt:register_children(optical_module_orm_obj, port_device_obj)
    local port_orm_obj = self.objects[port_device_obj]
    if not port_orm_obj then
        return
    end
    table.insert(port_orm_obj.children, optical_module_orm_obj)
end

function port_mgmt:get_orm_obj_by_device_obj(port_device_obj)
    local port_orm_obj = self.objects[port_device_obj]
    if not port_orm_obj then
        log:error('there is not orm obj for port device obj, NetworkAdapterId is %s, PortId is %s',
            port_device_obj.NetworkAdapterId, port_device_obj.PortId)
        return
    end
    return port_orm_obj
end

local function register_parent(port_orm_obj, port_device_obj)
    local card_device_obj = port_device_obj:get_parent()
    if not card_device_obj then
        log:error('there is not parent device obj for port, NetworkAdapterId is %s, PortId is %s',
            port_device_obj.NetworkAdapterId, port_device_obj.PortId)
        return
    end
    card_mgmt.get_instance():register_children(port_orm_obj, card_device_obj)
    local card_orm_obj = card_mgmt.get_instance():get_orm_obj_by_device_obj(card_device_obj)
    if not card_orm_obj then
        log:error('there is not parent orm obj for port, NetworkAdapterId is %s, PortId is %s',
            port_orm_obj.NetworkAdapterId,
            port_orm_obj.PortID)
        return
    end
    port_orm_obj.parent = card_orm_obj
end

function port_mgmt:init_obj(port_device_obj)
    if self.objects[port_device_obj] then
        return
    end
    local port_orm_obj = self:create_port_orm_object(port_device_obj)
    if port_orm_obj then
        self.objects[port_device_obj] = port_orm_obj
        port_orm_obj.children = {}
        -- 网口资源树对象创建后，建立和网卡对象的父子关系
        register_parent(port_orm_obj, port_device_obj)
        port_init.init(port_device_obj, port_orm_obj)
    end
end

function port_mgmt:ctor()
    self.objects = {}  -- 网口设备树对象和资源树对象的映射关系
end

function port_mgmt:init()
    -- 先监听网口设备树对象新增信号
    self:on_add_port_device_obj()
    -- 获取所有的网口设备树对象，创建对应的orm对象
    local port_device_objs = get_all_port_device_obj()
    for _, port_device_obj in pairs(port_device_objs) do
        self:init_obj(port_device_obj)
    end
end

return singleton(port_mgmt)
