-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local c_optical_module = require 'device.class.optical_module'

local optical_module_property_listen = {}

local function update_asset_name(orm_obj, _, value)
    orm_obj.AssetName = value
end

local function update_asset_serial_number(orm_obj, _, value)
    orm_obj.InventorySerialNumber = value
end

local function update_asset_manufacture(orm_obj, _, value)
    orm_obj.InventoryManufacturer = value
end

local function update_asset_part_number(orm_obj, _, value)
    orm_obj.InventoryPartNumber = value
end

local function update_asset_manufacture_date(orm_obj, _, value)
    orm_obj.ManufactureDate = value
end

function optical_module_property_listen.register_property_changed_callback(orm_obj)
    local switch = {
        FaultState = c_optical_module.update_fault_state,
        ReadingCelsius = c_optical_module.update_reading_celsius,
        SpeedMatch = c_optical_module.update_supported_type,
        TypeMatch = c_optical_module.update_supported_type,
        Presence = c_optical_module.restart_update_NSCI_optical_module_info,
        Name = update_asset_name,
        SerialNumber = update_asset_serial_number,
        Manufacturer = update_asset_manufacture,
        PartNumber = update_asset_part_number,
        ProductionDate = update_asset_manufacture_date
    }
    orm_obj:connect_signal(orm_obj.on_property_changed, function(name, value)
        if switch[name] then
            switch[name](orm_obj, name, value)
        end
    end)
end

return optical_module_property_listen