-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local port_defs = require 'port_mgmt.port_defs'
local c_optical_module = require 'device.class.optical_module'
local optical_module_manage = require 'optical_module_manage'


local optical_obj_init = {}

local function listen_device_obj_property_change(device_obj, orm_obj)

end

local function synchronize_property(device_obj, orm_obj)

end

function optical_obj_init.init(device_obj, orm_obj)
    -- 先启监听设备树对象属性变化，更新对应的资源树对象属性
    listen_device_obj_property_change(device_obj, orm_obj)
    -- 再将设备树对象属性赋值给对应资源树对象
    synchronize_property(device_obj, orm_obj)

    local port_orm_obj = orm_obj.parent
    orm_obj.channel_num = port_orm_obj.PortID + 1
    orm_obj.PortID = port_orm_obj.PortID
    orm_obj.NetworkAdapterId = port_orm_obj.NetworkAdapterId
    c_optical_module.super.init(orm_obj)
    local card_orm_obj = port_orm_obj.parent
    if card_orm_obj.Model == port_defs.NPU_MODEL then
        log:notice('[NPU] get_info_from_imu start, slot = %s, npuid = %s',
            card_orm_obj.SlotNumber, port_orm_obj.NpuID)
        optical_module_manage.init_npu_optical(orm_obj, port_orm_obj.NpuID)
    else
        optical_module_manage.register_property_changed_callback(orm_obj)
        optical_module_manage.start_get_optical_info_task(orm_obj)
    end
    orm_obj:register_mdb_objects()
end

return optical_obj_init