-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local skynet = require 'skynet'
local singleton = require 'mc.singleton'
local log = require 'mc.logging'
local class = require 'mc.class'
local port_mgmt = require 'port_mgmt'
local c_optical_module = require 'device.class.optical_module'
local optical_obj_init = require 'optical_module_mgmt.optical_module_init'

local optical_module_mgmt = class()

local function get_all_optical_device_obj()
    return {}
end

local function create_optical_orm_object(optical_device_obj)
    c_optical_module.__table({
        PortID = optical_device_obj.PortId,
        NetworkAdapterId = optical_device_obj.NetworkAdapterId,
        IsDevice = true -- 标识orm对象来源于设备树对象
    }):save()
    skynet.sleep(10)
    local optical_orm_obj = c_optical_module.collection:find({
        PortID = optical_device_obj.PortId,
        NetworkAdapterId = optical_device_obj.NetworkAdapterId
    })
    return optical_orm_obj
end

function optical_module_mgmt:on_add_optical_device_obj()
    local optical_device_obj
    self:init_obj(optical_device_obj)
end

local function register_parent(optical_orm_obj, optical_device_obj)
    local port_device_obj = optical_device_obj:get_parent()
    if not port_device_obj then
        log:error('there is not parent device obj for optical module, NetworkAdapterId is %s, PortId is %s',
            optical_device_obj.NetworkAdapterId, optical_device_obj.PortId)
        return
    end
    port_mgmt.get_instance():register_children(optical_orm_obj, port_device_obj)
    local port_orm_obj =  port_mgmt.get_instance():get_orm_obj_by_device_obj(port_device_obj)
    if not port_orm_obj then
        log:error('there is not parent orm obj for optical module, NetworkAdapterId is %s, PortId is %s',
            optical_orm_obj.NetworkAdapterId, optical_orm_obj.PortID)
        return
    end
    optical_orm_obj.parent = port_orm_obj
end

function optical_module_mgmt:get_orm_obj_by_device_obj(optical_device_obj)
    local port_orm_obj = self.objects[optical_device_obj]
    if not port_orm_obj then
        log:error('there is not orm obj for optical device obj, NetworkAdapterId is %s, PortId is %s',
            optical_device_obj.NetworkAdapterId, optical_device_obj.PortId)
        return
    end
    return port_orm_obj
end

function optical_module_mgmt:init_obj(optical_device_obj)
    if self.objects[optical_device_obj] then
        return
    end
    local optical_orm_obj = create_optical_orm_object(optical_device_obj)
    if optical_orm_obj then
        self.objects[optical_device_obj] = optical_orm_obj
        optical_orm_obj.children = {}
        -- 光模块资源树对象创建后，建立和父对象网口的关系
        register_parent(optical_orm_obj, optical_device_obj)
        optical_obj_init.init(optical_device_obj, optical_orm_obj)
    end
end

function optical_module_mgmt:ctor()
    self.objects = {}  -- 光模块设备树对象和资源树对象的映射关系
end

function optical_module_mgmt:init()
    -- 先监听光模块设备树对象新增信号
    self:on_add_optical_device_obj()
    -- 获取所有的光模块设备树对象，创建对应的orm对象
    local optical_device_objs = get_all_optical_device_obj()
    for _, optical_device_obj in pairs(optical_device_objs) do
        self:init_obj(optical_device_obj)
    end
end

return singleton(optical_module_mgmt)
