-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local c_network_adapter = require 'device.class.network_adapter'
local skynet = require 'skynet'
local card_init = require 'card_mgmt.card_init'
local class = require 'mc.class'
local singleton = require 'mc.singleton'
local log = require 'mc.logging'


local card_mgmt = class()

local function get_all_port_device_obj()
    return {}
end

function card_mgmt:create_port_orm_object(card_device_obj)
    local node_id = string.gsub(card_device_obj.DeviceName, '%s+', '')
    c_network_adapter.__table({
        ID = node_id,
        NodeId = node_id,
        IsDevice = true -- 标识orm对象来源于设备树对象
    }):save()
    skynet.sleep(10)
    local card_orm_obj = c_network_adapter.collection:find({
        ID = node_id,
        NodeId = node_id
    })
    return card_orm_obj
end

function card_mgmt:on_add_port_device_obj()
    local card_device_obj
    self:init_obj(card_device_obj)
end

function card_mgmt:init_obj(card_device_obj)
    if self.objects[card_device_obj] then
        return
    end
    local card_orm_obj = self:create_port_orm_object(card_device_obj)
    if card_orm_obj then
        self.objects[card_device_obj] = card_orm_obj
        card_orm_obj.children = {}
    end
end

function card_mgmt:ctor()
    self.objects = {} -- 网卡设备树对象和资源树对象的映射关系
end

-- 网口资源树对象创建后，注册到网卡的子对象集合中
function card_mgmt:register_children(port_orm_obj, card_device_obj)
    local card_orm_obj = self.objects[card_device_obj]
    if not card_orm_obj then
        return
    end
    table.insert(card_orm_obj.children, port_orm_obj)
    -- 当网卡所有的网口子对象创建好后再初始化
    if #card_orm_obj.children == card_device_obj.NetworkPortCount then
        card_init.init(card_device_obj, card_orm_obj)
    end
end

function card_mgmt:get_orm_obj_by_device_obj(card_device_obj)
    local card_orm_obj = self.objects[card_device_obj]
    if not card_orm_obj then
        log:error('there is not orm obj for card device obj, DeviceName is %s', card_device_obj.DeviceName)
        return
    end
    return card_orm_obj
end

function card_mgmt:init()
    -- 先监听网卡设备树对象新增信号
    self:on_add_port_device_obj()
    -- 获取所有的网卡设备树对象，创建对应的orm对象
    local port_device_objs = get_all_port_device_obj()
    for _, card_device_obj in pairs(port_device_objs) do
        self:init_obj(card_device_obj)
    end
end

return singleton(card_mgmt)