-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local Databases = require 'database'
local Col = require 'database.column'

local db_selector = {}

---@class NetWorkAdapterResetTable: Table
---@field PerId FieldBase
---@field Key FieldBase
---@field Value FieldBase

---@class Network_adapterDBDatabaseReset
---@field db DataBase
---@field select fun(db:DataBase, table: any, ...): SelectStatement
---@field update fun(db:DataBase, table: any, ...): UpdateStatement
---@field insert fun(db:DataBase, table: any, ...): InsertStatement
---@field NetWorkAdapterReset NetWorkAdapterResetTable

local Network_adapterDBDatabaseReset = {}
Network_adapterDBDatabaseReset.__index = Network_adapterDBDatabaseReset

function Network_adapterDBDatabaseReset.new(path, datas)
    local db = Databases(path)
    local obj = {db = db}

    obj.NetWorkAdapterReset = db:Table('t_network_adapter_reset', {
        PerId = Col.TextField():cid(1):primary_key(),
        Key = Col.TextField():cid(2):primary_key(),
        Value = Col.TextField():cid(3):null()
    }):create_if_not_exist(datas and datas['t_network_adapter_reset'])

    obj.tables = db.tables
    return setmetatable(obj, Network_adapterDBDatabaseReset)
end

function Network_adapterDBDatabaseReset:select(table, ...)
    return self.db:select(table, ...)
end

function Network_adapterDBDatabaseReset:update(table, ...)
    return self.db:update(table, ...)
end

function Network_adapterDBDatabaseReset:insert(table, ...)
    return self.db:insert(table, ...)
end

function Network_adapterDBDatabaseReset:delete(table, ...)
    return self.db:delete(table, ...)
end

function Network_adapterDBDatabaseReset:exec(...)
    return self.db:exec(...)
end

db_selector['reset'] = Network_adapterDBDatabaseReset.new

local Network_adapterDBDatabase = {}
Network_adapterDBDatabase.__index = Network_adapterDBDatabase

function Network_adapterDBDatabase.new(path, datas, type)
    return db_selector[type] and db_selector[type](path, datas) or nil
end

return Network_adapterDBDatabase.new
