-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PRBSTest = {}

---@class PRBSTest.ShutdownReq
---@field TestObjects string[]
local TShutdownReq = {}
TShutdownReq.__index = TShutdownReq
TShutdownReq.group = {}

local function TShutdownReq_from_obj(obj)
    return setmetatable(obj, TShutdownReq)
end

function TShutdownReq.new(TestObjects)
    return TShutdownReq_from_obj({TestObjects = TestObjects})
end
---@param obj PRBSTest.ShutdownReq
function TShutdownReq:init_from_obj(obj)
    self.TestObjects = obj.TestObjects
end

function TShutdownReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TShutdownReq.group)
end

TShutdownReq.from_obj = TShutdownReq_from_obj

TShutdownReq.proto_property = {'TestObjects'}

TShutdownReq.default = {{}}

TShutdownReq.struct = {{name = 'TestObjects', is_array = true, struct = nil}}

function TShutdownReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'TestObjects', self.TestObjects, 'string', false, errs, need_convert)

    TShutdownReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TShutdownReq.proto_property, errs, need_convert)
    return self
end

function TShutdownReq:unpack(_)
    return self.TestObjects
end

PRBSTest.ShutdownReq = TShutdownReq

---@class PRBSTest.ClearStatisticsReq
---@field TestObjects string[]
local TClearStatisticsReq = {}
TClearStatisticsReq.__index = TClearStatisticsReq
TClearStatisticsReq.group = {}

local function TClearStatisticsReq_from_obj(obj)
    return setmetatable(obj, TClearStatisticsReq)
end

function TClearStatisticsReq.new(TestObjects)
    return TClearStatisticsReq_from_obj({TestObjects = TestObjects})
end
---@param obj PRBSTest.ClearStatisticsReq
function TClearStatisticsReq:init_from_obj(obj)
    self.TestObjects = obj.TestObjects
end

function TClearStatisticsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearStatisticsReq.group)
end

TClearStatisticsReq.from_obj = TClearStatisticsReq_from_obj

TClearStatisticsReq.proto_property = {'TestObjects'}

TClearStatisticsReq.default = {{}}

TClearStatisticsReq.struct = {{name = 'TestObjects', is_array = true, struct = nil}}

function TClearStatisticsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'TestObjects', self.TestObjects, 'string', false, errs, need_convert)

    TClearStatisticsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearStatisticsReq.proto_property, errs, need_convert)
    return self
end

function TClearStatisticsReq:unpack(_)
    return self.TestObjects
end

PRBSTest.ClearStatisticsReq = TClearStatisticsReq

---@class PRBSTest.ConfigReq
---@field Configurations string
local TConfigReq = {}
TConfigReq.__index = TConfigReq
TConfigReq.group = {}

local function TConfigReq_from_obj(obj)
    return setmetatable(obj, TConfigReq)
end

function TConfigReq.new(Configurations)
    return TConfigReq_from_obj({Configurations = Configurations})
end
---@param obj PRBSTest.ConfigReq
function TConfigReq:init_from_obj(obj)
    self.Configurations = obj.Configurations
end

function TConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConfigReq.group)
end

TConfigReq.from_obj = TConfigReq_from_obj

TConfigReq.proto_property = {'Configurations'}

TConfigReq.default = {''}

TConfigReq.struct = {{name = 'Configurations', is_array = false, struct = nil}}

function TConfigReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Configurations', self.Configurations, 'string', false, errs, need_convert)

    TConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConfigReq.proto_property, errs, need_convert)
    return self
end

function TConfigReq:unpack(_)
    return self.Configurations
end

PRBSTest.ConfigReq = TConfigReq

---@class PRBSTest.QueryInfoRsp
---@field TestInfos string
local TQueryInfoRsp = {}
TQueryInfoRsp.__index = TQueryInfoRsp
TQueryInfoRsp.group = {}

local function TQueryInfoRsp_from_obj(obj)
    return setmetatable(obj, TQueryInfoRsp)
end

function TQueryInfoRsp.new(TestInfos)
    return TQueryInfoRsp_from_obj({TestInfos = TestInfos})
end
---@param obj PRBSTest.QueryInfoRsp
function TQueryInfoRsp:init_from_obj(obj)
    self.TestInfos = obj.TestInfos
end

function TQueryInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TQueryInfoRsp.group)
end

TQueryInfoRsp.from_obj = TQueryInfoRsp_from_obj

TQueryInfoRsp.proto_property = {'TestInfos'}

TQueryInfoRsp.default = {''}

TQueryInfoRsp.struct = {{name = 'TestInfos', is_array = false, struct = nil}}

function TQueryInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TestInfos', self.TestInfos, 'string', false, errs, need_convert)

    TQueryInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TQueryInfoRsp.proto_property, errs, need_convert)
    return self
end

function TQueryInfoRsp:unpack(_)
    return self.TestInfos
end

PRBSTest.QueryInfoRsp = TQueryInfoRsp

---@class PRBSTest.QueryInfoReq
---@field TestObjects string[]
local TQueryInfoReq = {}
TQueryInfoReq.__index = TQueryInfoReq
TQueryInfoReq.group = {}

local function TQueryInfoReq_from_obj(obj)
    return setmetatable(obj, TQueryInfoReq)
end

function TQueryInfoReq.new(TestObjects)
    return TQueryInfoReq_from_obj({TestObjects = TestObjects})
end
---@param obj PRBSTest.QueryInfoReq
function TQueryInfoReq:init_from_obj(obj)
    self.TestObjects = obj.TestObjects
end

function TQueryInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TQueryInfoReq.group)
end

TQueryInfoReq.from_obj = TQueryInfoReq_from_obj

TQueryInfoReq.proto_property = {'TestObjects'}

TQueryInfoReq.default = {{}}

TQueryInfoReq.struct = {{name = 'TestObjects', is_array = true, struct = nil}}

function TQueryInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'TestObjects', self.TestObjects, 'string', false, errs, need_convert)

    TQueryInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TQueryInfoReq.proto_property, errs, need_convert)
    return self
end

function TQueryInfoReq:unpack(_)
    return self.TestObjects
end

PRBSTest.QueryInfoReq = TQueryInfoReq

---@class PRBSTest.OperationResults
---@field TestObjectId string
---@field Result string
local TOperationResults = {}
TOperationResults.__index = TOperationResults
TOperationResults.group = {}

local function TOperationResults_from_obj(obj)
    return setmetatable(obj, TOperationResults)
end

function TOperationResults.new(TestObjectId, Result)
    return TOperationResults_from_obj({TestObjectId = TestObjectId, Result = Result})
end
---@param obj PRBSTest.OperationResults
function TOperationResults:init_from_obj(obj)
    self.TestObjectId = obj.TestObjectId
    self.Result = obj.Result
end

function TOperationResults:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOperationResults.group)
end

TOperationResults.from_obj = TOperationResults_from_obj

TOperationResults.proto_property = {'TestObjectId', 'Result'}

TOperationResults.default = {'', ''}

TOperationResults.struct = {
    {name = 'TestObjectId', is_array = false, struct = nil}, {name = 'Result', is_array = false, struct = nil}
}

function TOperationResults:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TestObjectId', self.TestObjectId, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Result', self.Result, 'string', false, errs, need_convert)

    TOperationResults:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOperationResults.proto_property, errs, need_convert)
    return self
end

function TOperationResults:unpack(_)
    return self.TestObjectId, self.Result
end

PRBSTest.OperationResults = TOperationResults

---@class PRBSTest.ShutdownRsp
---@field OperationResults PRBSTest.OperationResults[]
local TShutdownRsp = {}
TShutdownRsp.__index = TShutdownRsp
TShutdownRsp.group = {}

local function TShutdownRsp_from_obj(obj)
    obj.OperationResults = utils.from_obj(PRBSTest.OperationResults, obj.OperationResults, true)
    return setmetatable(obj, TShutdownRsp)
end

function TShutdownRsp.new(OperationResults)
    return TShutdownRsp_from_obj({OperationResults = OperationResults})
end
---@param obj PRBSTest.ShutdownRsp
function TShutdownRsp:init_from_obj(obj)
    self.OperationResults = obj.OperationResults
end

function TShutdownRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TShutdownRsp.group)
end

TShutdownRsp.from_obj = TShutdownRsp_from_obj

TShutdownRsp.proto_property = {'OperationResults'}

TShutdownRsp.default = {{}}

TShutdownRsp.struct = {{name = 'OperationResults', is_array = true, struct = PRBSTest.OperationResults.struct}}

function TShutdownRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.OperationResults) do
        PRBSTest.OperationResults.new(v.TestObjectId, v.Result):validate(prefix, errs, need_convert)
    end

    TShutdownRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TShutdownRsp.proto_property, errs, need_convert)
    return self
end

function TShutdownRsp:unpack(raw)
    return utils.unpack(raw, self.OperationResults, true)
end

PRBSTest.ShutdownRsp = TShutdownRsp

---@class PRBSTest.ClearStatisticsRsp
---@field OperationResults PRBSTest.OperationResults[]
local TClearStatisticsRsp = {}
TClearStatisticsRsp.__index = TClearStatisticsRsp
TClearStatisticsRsp.group = {}

local function TClearStatisticsRsp_from_obj(obj)
    obj.OperationResults = utils.from_obj(PRBSTest.OperationResults, obj.OperationResults, true)
    return setmetatable(obj, TClearStatisticsRsp)
end

function TClearStatisticsRsp.new(OperationResults)
    return TClearStatisticsRsp_from_obj({OperationResults = OperationResults})
end
---@param obj PRBSTest.ClearStatisticsRsp
function TClearStatisticsRsp:init_from_obj(obj)
    self.OperationResults = obj.OperationResults
end

function TClearStatisticsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearStatisticsRsp.group)
end

TClearStatisticsRsp.from_obj = TClearStatisticsRsp_from_obj

TClearStatisticsRsp.proto_property = {'OperationResults'}

TClearStatisticsRsp.default = {{}}

TClearStatisticsRsp.struct = {{name = 'OperationResults', is_array = true, struct = PRBSTest.OperationResults.struct}}

function TClearStatisticsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.OperationResults) do
        PRBSTest.OperationResults.new(v.TestObjectId, v.Result):validate(prefix, errs, need_convert)
    end

    TClearStatisticsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearStatisticsRsp.proto_property, errs, need_convert)
    return self
end

function TClearStatisticsRsp:unpack(raw)
    return utils.unpack(raw, self.OperationResults, true)
end

PRBSTest.ClearStatisticsRsp = TClearStatisticsRsp

---@class PRBSTest.ConfigRsp
---@field OperationResults PRBSTest.OperationResults[]
local TConfigRsp = {}
TConfigRsp.__index = TConfigRsp
TConfigRsp.group = {}

local function TConfigRsp_from_obj(obj)
    obj.OperationResults = utils.from_obj(PRBSTest.OperationResults, obj.OperationResults, true)
    return setmetatable(obj, TConfigRsp)
end

function TConfigRsp.new(OperationResults)
    return TConfigRsp_from_obj({OperationResults = OperationResults})
end
---@param obj PRBSTest.ConfigRsp
function TConfigRsp:init_from_obj(obj)
    self.OperationResults = obj.OperationResults
end

function TConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConfigRsp.group)
end

TConfigRsp.from_obj = TConfigRsp_from_obj

TConfigRsp.proto_property = {'OperationResults'}

TConfigRsp.default = {{}}

TConfigRsp.struct = {{name = 'OperationResults', is_array = true, struct = PRBSTest.OperationResults.struct}}

function TConfigRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.OperationResults) do
        PRBSTest.OperationResults.new(v.TestObjectId, v.Result):validate(prefix, errs, need_convert)
    end

    TConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConfigRsp.proto_property, errs, need_convert)
    return self
end

function TConfigRsp:unpack(raw)
    return utils.unpack(raw, self.OperationResults, true)
end

PRBSTest.ConfigRsp = TConfigRsp

PRBSTest.interface = mdb.register_interface('bmc.kepler.Managers.DiagnosticService.PRBSTest', {}, {
    QueryInfo = {'a{ss}as', 's', TQueryInfoReq, TQueryInfoRsp},
    Config = {'a{ss}s', 'a(ss)', TConfigReq, TConfigRsp},
    ClearStatistics = {'a{ss}as', 'a(ss)', TClearStatisticsReq, TClearStatisticsRsp},
    Shutdown = {'a{ss}as', 'a(ss)', TShutdownReq, TShutdownRsp}
}, {})

return PRBSTest
