-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local LldpConfig = {}

---@class LldpConfig.TxHold
---@field TxHold integer
local TTxHold = {}
TTxHold.__index = TTxHold
TTxHold.group = {}

local function TTxHold_from_obj(obj)
    return setmetatable(obj, TTxHold)
end

function TTxHold.new(TxHold)
    return TTxHold_from_obj({TxHold = TxHold})
end
---@param obj LldpConfig.TxHold
function TTxHold:init_from_obj(obj)
    self.TxHold = obj.TxHold
end

function TTxHold:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTxHold.group)
end

TTxHold.from_obj = TTxHold_from_obj

TTxHold.proto_property = {'TxHold'}

TTxHold.default = {0}

TTxHold.struct = {{name = 'TxHold', is_array = false, struct = nil}}

function TTxHold:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TxHold', self.TxHold, 'int32', false, errs, need_convert)

    if self.TxHold ~= nil then
        validate.ranges(prefix .. 'TxHold', self.TxHold, 2, 10, errs, need_convert)
    end

    TTxHold:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTxHold.proto_property, errs, need_convert)
    return self
end

function TTxHold:unpack(_)
    return self.TxHold
end

LldpConfig.TxHold = TTxHold

---@class LldpConfig.TxIntervalSeconds
---@field TxIntervalSeconds integer
local TTxIntervalSeconds = {}
TTxIntervalSeconds.__index = TTxIntervalSeconds
TTxIntervalSeconds.group = {}

local function TTxIntervalSeconds_from_obj(obj)
    return setmetatable(obj, TTxIntervalSeconds)
end

function TTxIntervalSeconds.new(TxIntervalSeconds)
    return TTxIntervalSeconds_from_obj({TxIntervalSeconds = TxIntervalSeconds})
end
---@param obj LldpConfig.TxIntervalSeconds
function TTxIntervalSeconds:init_from_obj(obj)
    self.TxIntervalSeconds = obj.TxIntervalSeconds
end

function TTxIntervalSeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTxIntervalSeconds.group)
end

TTxIntervalSeconds.from_obj = TTxIntervalSeconds_from_obj

TTxIntervalSeconds.proto_property = {'TxIntervalSeconds'}

TTxIntervalSeconds.default = {0}

TTxIntervalSeconds.struct = {{name = 'TxIntervalSeconds', is_array = false, struct = nil}}

function TTxIntervalSeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TxIntervalSeconds', self.TxIntervalSeconds, 'int32', false, errs, need_convert)

    if self.TxIntervalSeconds ~= nil then
        validate.ranges(prefix .. 'TxIntervalSeconds', self.TxIntervalSeconds, 5, 32768, errs, need_convert)
    end

    TTxIntervalSeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTxIntervalSeconds.proto_property, errs, need_convert)
    return self
end

function TTxIntervalSeconds:unpack(_)
    return self.TxIntervalSeconds
end

LldpConfig.TxIntervalSeconds = TTxIntervalSeconds

---@class LldpConfig.TxDelaySeconds
---@field TxDelaySeconds integer
local TTxDelaySeconds = {}
TTxDelaySeconds.__index = TTxDelaySeconds
TTxDelaySeconds.group = {}

local function TTxDelaySeconds_from_obj(obj)
    return setmetatable(obj, TTxDelaySeconds)
end

function TTxDelaySeconds.new(TxDelaySeconds)
    return TTxDelaySeconds_from_obj({TxDelaySeconds = TxDelaySeconds})
end
---@param obj LldpConfig.TxDelaySeconds
function TTxDelaySeconds:init_from_obj(obj)
    self.TxDelaySeconds = obj.TxDelaySeconds
end

function TTxDelaySeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTxDelaySeconds.group)
end

TTxDelaySeconds.from_obj = TTxDelaySeconds_from_obj

TTxDelaySeconds.proto_property = {'TxDelaySeconds'}

TTxDelaySeconds.default = {0}

TTxDelaySeconds.struct = {{name = 'TxDelaySeconds', is_array = false, struct = nil}}

function TTxDelaySeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TxDelaySeconds', self.TxDelaySeconds, 'int32', false, errs, need_convert)

    if self.TxDelaySeconds ~= nil then
        validate.ranges(prefix .. 'TxDelaySeconds', self.TxDelaySeconds, 1, 8192, errs, need_convert)
    end

    TTxDelaySeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTxDelaySeconds.proto_property, errs, need_convert)
    return self
end

function TTxDelaySeconds:unpack(_)
    return self.TxDelaySeconds
end

LldpConfig.TxDelaySeconds = TTxDelaySeconds

---@class LldpConfig.WorkMode
---@field WorkMode string
local TWorkMode = {}
TWorkMode.__index = TWorkMode
TWorkMode.group = {}

local function TWorkMode_from_obj(obj)
    return setmetatable(obj, TWorkMode)
end

function TWorkMode.new(WorkMode)
    return TWorkMode_from_obj({WorkMode = WorkMode})
end
---@param obj LldpConfig.WorkMode
function TWorkMode:init_from_obj(obj)
    self.WorkMode = obj.WorkMode
end

function TWorkMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWorkMode.group)
end

TWorkMode.from_obj = TWorkMode_from_obj

TWorkMode.proto_property = {'WorkMode'}

TWorkMode.default = {''}

TWorkMode.struct = {{name = 'WorkMode', is_array = false, struct = nil}}

function TWorkMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'WorkMode', self.WorkMode, 'string', false, errs, need_convert)

    TWorkMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWorkMode.proto_property, errs, need_convert)
    return self
end

function TWorkMode:unpack(_)
    return self.WorkMode
end

LldpConfig.WorkMode = TWorkMode

---@class LldpConfig.Enabled
---@field Enabled boolean
local TEnabled = {}
TEnabled.__index = TEnabled
TEnabled.group = {}

local function TEnabled_from_obj(obj)
    return setmetatable(obj, TEnabled)
end

function TEnabled.new(Enabled)
    return TEnabled_from_obj({Enabled = Enabled})
end
---@param obj LldpConfig.Enabled
function TEnabled:init_from_obj(obj)
    self.Enabled = obj.Enabled
end

function TEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnabled.group)
end

TEnabled.from_obj = TEnabled_from_obj

TEnabled.proto_property = {'Enabled'}

TEnabled.default = {false}

TEnabled.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, 'bool', false, errs, need_convert)

    TEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnabled.proto_property, errs, need_convert)
    return self
end

function TEnabled:unpack(_)
    return self.Enabled
end

LldpConfig.Enabled = TEnabled

---@class LldpConfig.LLDPOverNCSIStateChangedSignature
---@field State boolean
local TLLDPOverNCSIStateChangedSignature = {}
TLLDPOverNCSIStateChangedSignature.__index = TLLDPOverNCSIStateChangedSignature
TLLDPOverNCSIStateChangedSignature.group = {}

local function TLLDPOverNCSIStateChangedSignature_from_obj(obj)
    return setmetatable(obj, TLLDPOverNCSIStateChangedSignature)
end

function TLLDPOverNCSIStateChangedSignature.new(State)
    return TLLDPOverNCSIStateChangedSignature_from_obj({State = State})
end
---@param obj LldpConfig.LLDPOverNCSIStateChangedSignature
function TLLDPOverNCSIStateChangedSignature:init_from_obj(obj)
    self.State = obj.State
end

function TLLDPOverNCSIStateChangedSignature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLLDPOverNCSIStateChangedSignature.group)
end

TLLDPOverNCSIStateChangedSignature.from_obj = TLLDPOverNCSIStateChangedSignature_from_obj

TLLDPOverNCSIStateChangedSignature.proto_property = {'State'}

TLLDPOverNCSIStateChangedSignature.default = {false}

TLLDPOverNCSIStateChangedSignature.struct = {{name = 'State', is_array = false, struct = nil}}

function TLLDPOverNCSIStateChangedSignature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'State', self.State, 'bool', false, errs, need_convert)

    TLLDPOverNCSIStateChangedSignature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLLDPOverNCSIStateChangedSignature.proto_property, errs, need_convert)
    return self
end

function TLLDPOverNCSIStateChangedSignature:unpack(_)
    return self.State
end

LldpConfig.LLDPOverNCSIStateChangedSignature = TLLDPOverNCSIStateChangedSignature

LldpConfig.interface = mdb.register_interface('bmc.kepler.Managers.LldpConfig', {
    Enabled = {'b', nil, false, nil, false},
    WorkMode = {'s', nil, false, nil, false},
    TxDelaySeconds = {'i', nil, false, nil, false},
    TxIntervalSeconds = {'i', nil, false, nil, false},
    TxHold = {'i', nil, false, nil, false}
}, {}, {LLDPOverNCSIStateChanged = 'a{ss}b'})

return LldpConfig
