-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local InnerNetwork = {}

---@class InnerNetwork.VLANId
---@field VLANId integer
local TVLANId = {}
TVLANId.__index = TVLANId
TVLANId.group = {}

local function TVLANId_from_obj(obj)
    return setmetatable(obj, TVLANId)
end

function TVLANId.new(VLANId)
    return TVLANId_from_obj({VLANId = VLANId})
end
---@param obj InnerNetwork.VLANId
function TVLANId:init_from_obj(obj)
    self.VLANId = obj.VLANId
end

function TVLANId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVLANId.group)
end

TVLANId.from_obj = TVLANId_from_obj

TVLANId.proto_property = {'VLANId'}

TVLANId.default = {0}

TVLANId.struct = {{name = 'VLANId', is_array = false, struct = nil}}

function TVLANId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VLANId', self.VLANId, 'uint16', true, errs, need_convert)

    TVLANId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVLANId.proto_property, errs, need_convert)
    return self
end

function TVLANId:unpack(_)
    return self.VLANId
end

InnerNetwork.VLANId = TVLANId

---@class InnerNetwork.Status
---@field Status boolean
local TStatus = {}
TStatus.__index = TStatus
TStatus.group = {}

local function TStatus_from_obj(obj)
    return setmetatable(obj, TStatus)
end

function TStatus.new(Status)
    return TStatus_from_obj({Status = Status})
end
---@param obj InnerNetwork.Status
function TStatus:init_from_obj(obj)
    self.Status = obj.Status
end

function TStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStatus.group)
end

TStatus.from_obj = TStatus_from_obj

TStatus.proto_property = {'Status'}

TStatus.default = {false}

TStatus.struct = {{name = 'Status', is_array = false, struct = nil}}

function TStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'bool', true, errs, need_convert)

    TStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStatus.proto_property, errs, need_convert)
    return self
end

function TStatus:unpack(_)
    return self.Status
end

InnerNetwork.Status = TStatus

---@class InnerNetwork.SubnetMask
---@field SubnetMask string
local TSubnetMask = {}
TSubnetMask.__index = TSubnetMask
TSubnetMask.group = {}

local function TSubnetMask_from_obj(obj)
    return setmetatable(obj, TSubnetMask)
end

function TSubnetMask.new(SubnetMask)
    return TSubnetMask_from_obj({SubnetMask = SubnetMask})
end
---@param obj InnerNetwork.SubnetMask
function TSubnetMask:init_from_obj(obj)
    self.SubnetMask = obj.SubnetMask
end

function TSubnetMask:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubnetMask.group)
end

TSubnetMask.from_obj = TSubnetMask_from_obj

TSubnetMask.proto_property = {'SubnetMask'}

TSubnetMask.default = {''}

TSubnetMask.struct = {{name = 'SubnetMask', is_array = false, struct = nil}}

function TSubnetMask:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SubnetMask', self.SubnetMask, 'string', true, errs, need_convert)

    TSubnetMask:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubnetMask.proto_property, errs, need_convert)
    return self
end

function TSubnetMask:unpack(_)
    return self.SubnetMask
end

InnerNetwork.SubnetMask = TSubnetMask

---@class InnerNetwork.IpAddr
---@field IpAddr string
local TIpAddr = {}
TIpAddr.__index = TIpAddr
TIpAddr.group = {}

local function TIpAddr_from_obj(obj)
    return setmetatable(obj, TIpAddr)
end

function TIpAddr.new(IpAddr)
    return TIpAddr_from_obj({IpAddr = IpAddr})
end
---@param obj InnerNetwork.IpAddr
function TIpAddr:init_from_obj(obj)
    self.IpAddr = obj.IpAddr
end

function TIpAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpAddr.group)
end

TIpAddr.from_obj = TIpAddr_from_obj

TIpAddr.proto_property = {'IpAddr'}

TIpAddr.default = {''}

TIpAddr.struct = {{name = 'IpAddr', is_array = false, struct = nil}}

function TIpAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IpAddr', self.IpAddr, 'string', true, errs, need_convert)

    TIpAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpAddr.proto_property, errs, need_convert)
    return self
end

function TIpAddr:unpack(_)
    return self.IpAddr
end

InnerNetwork.IpAddr = TIpAddr

---@class InnerNetwork.EthName
---@field EthName string
local TEthName = {}
TEthName.__index = TEthName
TEthName.group = {}

local function TEthName_from_obj(obj)
    return setmetatable(obj, TEthName)
end

function TEthName.new(EthName)
    return TEthName_from_obj({EthName = EthName})
end
---@param obj InnerNetwork.EthName
function TEthName:init_from_obj(obj)
    self.EthName = obj.EthName
end

function TEthName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEthName.group)
end

TEthName.from_obj = TEthName_from_obj

TEthName.proto_property = {'EthName'}

TEthName.default = {''}

TEthName.struct = {{name = 'EthName', is_array = false, struct = nil}}

function TEthName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EthName', self.EthName, 'string', true, errs, need_convert)

    TEthName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEthName.proto_property, errs, need_convert)
    return self
end

function TEthName:unpack(_)
    return self.EthName
end

InnerNetwork.EthName = TEthName

---@class InnerNetwork.EthId
---@field EthId integer
local TEthId = {}
TEthId.__index = TEthId
TEthId.group = {}

local function TEthId_from_obj(obj)
    return setmetatable(obj, TEthId)
end

function TEthId.new(EthId)
    return TEthId_from_obj({EthId = EthId})
end
---@param obj InnerNetwork.EthId
function TEthId:init_from_obj(obj)
    self.EthId = obj.EthId
end

function TEthId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEthId.group)
end

TEthId.from_obj = TEthId_from_obj

TEthId.proto_property = {'EthId'}

TEthId.default = {0}

TEthId.struct = {{name = 'EthId', is_array = false, struct = nil}}

function TEthId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EthId', self.EthId, 'uint8', true, errs, need_convert)

    TEthId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEthId.proto_property, errs, need_convert)
    return self
end

function TEthId:unpack(_)
    return self.EthId
end

InnerNetwork.EthId = TEthId

---@class InnerNetwork.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj InnerNetwork.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'uint8', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

InnerNetwork.Id = TId

InnerNetwork.interface = mdb.register_interface('bmc.kepler.Managers.EthernetInterfaces.InnerNetwork', {
    Id = {'y', {}, true, nil, false},
    EthId = {'y', {}, true, nil, false},
    EthName = {'s', {}, true, nil, false},
    IpAddr = {'s', nil, true, nil, false},
    SubnetMask = {'s', nil, true, nil, false},
    Status = {'b', nil, true, nil, false},
    VLANId = {'q', nil, true, nil, false}
}, {}, {})

return InnerNetwork
