-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local IPv6Address = {}

---@class IPv6Address.Gateway
---@field Gateway string[]
local TGateway = {}
TGateway.__index = TGateway
TGateway.group = {}

local function TGateway_from_obj(obj)
    return setmetatable(obj, TGateway)
end

function TGateway.new(Gateway)
    return TGateway_from_obj({Gateway = Gateway})
end
---@param obj IPv6Address.Gateway
function TGateway:init_from_obj(obj)
    self.Gateway = obj.Gateway
end

function TGateway:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGateway.group)
end

TGateway.from_obj = TGateway_from_obj

TGateway.proto_property = {'Gateway'}

TGateway.default = {{}}

TGateway.struct = {{name = 'Gateway', is_array = true, struct = nil}}

function TGateway:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'Gateway', self.Gateway, 'string', true, errs, need_convert)

    TGateway:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGateway.proto_property, errs, need_convert)
    return self
end

function TGateway:unpack(_)
    return self.Gateway
end

IPv6Address.Gateway = TGateway

---@class IPv6Address.AddressOrigin
---@field AddressOrigin string
local TAddressOrigin = {}
TAddressOrigin.__index = TAddressOrigin
TAddressOrigin.group = {}

local function TAddressOrigin_from_obj(obj)
    return setmetatable(obj, TAddressOrigin)
end

function TAddressOrigin.new(AddressOrigin)
    return TAddressOrigin_from_obj({AddressOrigin = AddressOrigin})
end
---@param obj IPv6Address.AddressOrigin
function TAddressOrigin:init_from_obj(obj)
    self.AddressOrigin = obj.AddressOrigin
end

function TAddressOrigin:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddressOrigin.group)
end

TAddressOrigin.from_obj = TAddressOrigin_from_obj

TAddressOrigin.proto_property = {'AddressOrigin'}

TAddressOrigin.default = {''}

TAddressOrigin.struct = {{name = 'AddressOrigin', is_array = false, struct = nil}}

function TAddressOrigin:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AddressOrigin', self.AddressOrigin, 'string', true, errs, need_convert)

    if self.AddressOrigin ~= nil then
        validate.Enum(prefix .. 'AddressOrigin', self.AddressOrigin, '', {'DHCPv6', 'LinkLocal', 'SLAAC', 'Static'},
            errs, need_convert)
    end

    TAddressOrigin:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddressOrigin.proto_property, errs, need_convert)
    return self
end

function TAddressOrigin:unpack(_)
    return self.AddressOrigin
end

IPv6Address.AddressOrigin = TAddressOrigin

---@class IPv6Address.AddressState
---@field AddressState string
local TAddressState = {}
TAddressState.__index = TAddressState
TAddressState.group = {}

local function TAddressState_from_obj(obj)
    return setmetatable(obj, TAddressState)
end

function TAddressState.new(AddressState)
    return TAddressState_from_obj({AddressState = AddressState})
end
---@param obj IPv6Address.AddressState
function TAddressState:init_from_obj(obj)
    self.AddressState = obj.AddressState
end

function TAddressState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddressState.group)
end

TAddressState.from_obj = TAddressState_from_obj

TAddressState.proto_property = {'AddressState'}

TAddressState.default = {''}

TAddressState.struct = {{name = 'AddressState', is_array = false, struct = nil}}

function TAddressState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AddressState', self.AddressState, 'string', true, errs, need_convert)

    if self.AddressState ~= nil then
        validate.Enum(prefix .. 'AddressState', self.AddressState, '',
            {'Deprecated', 'Failed', 'Preferred', 'Tentative'}, errs, need_convert)
    end

    TAddressState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddressState.proto_property, errs, need_convert)
    return self
end

function TAddressState:unpack(_)
    return self.AddressState
end

IPv6Address.AddressState = TAddressState

---@class IPv6Address.PrefixLength
---@field PrefixLength string
local TPrefixLength = {}
TPrefixLength.__index = TPrefixLength
TPrefixLength.group = {}

local function TPrefixLength_from_obj(obj)
    return setmetatable(obj, TPrefixLength)
end

function TPrefixLength.new(PrefixLength)
    return TPrefixLength_from_obj({PrefixLength = PrefixLength})
end
---@param obj IPv6Address.PrefixLength
function TPrefixLength:init_from_obj(obj)
    self.PrefixLength = obj.PrefixLength
end

function TPrefixLength:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPrefixLength.group)
end

TPrefixLength.from_obj = TPrefixLength_from_obj

TPrefixLength.proto_property = {'PrefixLength'}

TPrefixLength.default = {''}

TPrefixLength.struct = {{name = 'PrefixLength', is_array = false, struct = nil}}

function TPrefixLength:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PrefixLength', self.PrefixLength, 'string', true, errs, need_convert)

    TPrefixLength:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPrefixLength.proto_property, errs, need_convert)
    return self
end

function TPrefixLength:unpack(_)
    return self.PrefixLength
end

IPv6Address.PrefixLength = TPrefixLength

---@class IPv6Address.Address
---@field Address string
local TAddress = {}
TAddress.__index = TAddress
TAddress.group = {}

local function TAddress_from_obj(obj)
    return setmetatable(obj, TAddress)
end

function TAddress.new(Address)
    return TAddress_from_obj({Address = Address})
end
---@param obj IPv6Address.Address
function TAddress:init_from_obj(obj)
    self.Address = obj.Address
end

function TAddress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddress.group)
end

TAddress.from_obj = TAddress_from_obj

TAddress.proto_property = {'Address'}

TAddress.default = {''}

TAddress.struct = {{name = 'Address', is_array = false, struct = nil}}

function TAddress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Address', self.Address, 'string', true, errs, need_convert)

    TAddress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddress.proto_property, errs, need_convert)
    return self
end

function TAddress:unpack(_)
    return self.Address
end

IPv6Address.Address = TAddress

IPv6Address.interface = mdb.register_interface('bmc.kepler.Systems.IPv6Address', {
    Address = {'s', nil, true, nil, false},
    PrefixLength = {'s', nil, true, nil, false},
    AddressState = {'s', nil, true, nil, false},
    AddressOrigin = {'s', nil, true, nil, false},
    Gateway = {'as', nil, true, nil, false}
}, {}, {})

return IPv6Address
