-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Frudata = {}

---@class Frudata.SetProductAssetTagRsp
local TSetProductAssetTagRsp = {}
TSetProductAssetTagRsp.__index = TSetProductAssetTagRsp
TSetProductAssetTagRsp.group = {}

local function TSetProductAssetTagRsp_from_obj(obj)
    return setmetatable(obj, TSetProductAssetTagRsp)
end

function TSetProductAssetTagRsp.new()
    return TSetProductAssetTagRsp_from_obj({})
end
---@param obj Frudata.SetProductAssetTagRsp
function TSetProductAssetTagRsp:init_from_obj(obj)

end

function TSetProductAssetTagRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetProductAssetTagRsp.group)
end

TSetProductAssetTagRsp.from_obj = TSetProductAssetTagRsp_from_obj

TSetProductAssetTagRsp.proto_property = {}

TSetProductAssetTagRsp.default = {}

TSetProductAssetTagRsp.struct = {}

function TSetProductAssetTagRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetProductAssetTagRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetProductAssetTagRsp.proto_property, errs, need_convert)
    return self
end

function TSetProductAssetTagRsp:unpack(_)
end

Frudata.SetProductAssetTagRsp = TSetProductAssetTagRsp

---@class Frudata.SetProductAssetTagReq
---@field FruId integer
---@field AssetTag string
local TSetProductAssetTagReq = {}
TSetProductAssetTagReq.__index = TSetProductAssetTagReq
TSetProductAssetTagReq.group = {}

local function TSetProductAssetTagReq_from_obj(obj)
    return setmetatable(obj, TSetProductAssetTagReq)
end

function TSetProductAssetTagReq.new(FruId, AssetTag)
    return TSetProductAssetTagReq_from_obj({FruId = FruId, AssetTag = AssetTag})
end
---@param obj Frudata.SetProductAssetTagReq
function TSetProductAssetTagReq:init_from_obj(obj)
    self.FruId = obj.FruId
    self.AssetTag = obj.AssetTag
end

function TSetProductAssetTagReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetProductAssetTagReq.group)
end

TSetProductAssetTagReq.from_obj = TSetProductAssetTagReq_from_obj

TSetProductAssetTagReq.proto_property = {'FruId', 'AssetTag'}

TSetProductAssetTagReq.default = {0, ''}

TSetProductAssetTagReq.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'AssetTag', is_array = false, struct = nil}
}

function TSetProductAssetTagReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AssetTag', self.AssetTag, 'string', false, errs, need_convert)

    TSetProductAssetTagReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetProductAssetTagReq.proto_property, errs, need_convert)
    return self
end

function TSetProductAssetTagReq:unpack(_)
    return self.FruId, self.AssetTag
end

Frudata.SetProductAssetTagReq = TSetProductAssetTagReq

---@class Frudata.SetSysProductNameRsp
local TSetSysProductNameRsp = {}
TSetSysProductNameRsp.__index = TSetSysProductNameRsp
TSetSysProductNameRsp.group = {}

local function TSetSysProductNameRsp_from_obj(obj)
    return setmetatable(obj, TSetSysProductNameRsp)
end

function TSetSysProductNameRsp.new()
    return TSetSysProductNameRsp_from_obj({})
end
---@param obj Frudata.SetSysProductNameRsp
function TSetSysProductNameRsp:init_from_obj(obj)

end

function TSetSysProductNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSysProductNameRsp.group)
end

TSetSysProductNameRsp.from_obj = TSetSysProductNameRsp_from_obj

TSetSysProductNameRsp.proto_property = {}

TSetSysProductNameRsp.default = {}

TSetSysProductNameRsp.struct = {}

function TSetSysProductNameRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetSysProductNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSysProductNameRsp.proto_property, errs, need_convert)
    return self
end

function TSetSysProductNameRsp:unpack(_)
end

Frudata.SetSysProductNameRsp = TSetSysProductNameRsp

---@class Frudata.SetSysProductNameReq
---@field FruId integer
---@field ProductName string
local TSetSysProductNameReq = {}
TSetSysProductNameReq.__index = TSetSysProductNameReq
TSetSysProductNameReq.group = {}

local function TSetSysProductNameReq_from_obj(obj)
    return setmetatable(obj, TSetSysProductNameReq)
end

function TSetSysProductNameReq.new(FruId, ProductName)
    return TSetSysProductNameReq_from_obj({FruId = FruId, ProductName = ProductName})
end
---@param obj Frudata.SetSysProductNameReq
function TSetSysProductNameReq:init_from_obj(obj)
    self.FruId = obj.FruId
    self.ProductName = obj.ProductName
end

function TSetSysProductNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSysProductNameReq.group)
end

TSetSysProductNameReq.from_obj = TSetSysProductNameReq_from_obj

TSetSysProductNameReq.proto_property = {'FruId', 'ProductName'}

TSetSysProductNameReq.default = {0, ''}

TSetSysProductNameReq.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'ProductName', is_array = false, struct = nil}
}

function TSetSysProductNameReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ProductName', self.ProductName, 'string', false, errs, need_convert)

    TSetSysProductNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSysProductNameReq.proto_property, errs, need_convert)
    return self
end

function TSetSysProductNameReq:unpack(_)
    return self.FruId, self.ProductName
end

Frudata.SetSysProductNameReq = TSetSysProductNameReq

---@class Frudata.UpdateRsp
local TUpdateRsp = {}
TUpdateRsp.__index = TUpdateRsp
TUpdateRsp.group = {}

local function TUpdateRsp_from_obj(obj)
    return setmetatable(obj, TUpdateRsp)
end

function TUpdateRsp.new()
    return TUpdateRsp_from_obj({})
end
---@param obj Frudata.UpdateRsp
function TUpdateRsp:init_from_obj(obj)

end

function TUpdateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateRsp.group)
end

TUpdateRsp.from_obj = TUpdateRsp_from_obj

TUpdateRsp.proto_property = {}

TUpdateRsp.default = {}

TUpdateRsp.struct = {}

function TUpdateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TUpdateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateRsp.proto_property, errs, need_convert)
    return self
end

function TUpdateRsp:unpack(_)
end

Frudata.UpdateRsp = TUpdateRsp

---@class Frudata.UpdateReq
---@field PropertyName string[]
---@field Value string[]
local TUpdateReq = {}
TUpdateReq.__index = TUpdateReq
TUpdateReq.group = {}

local function TUpdateReq_from_obj(obj)
    return setmetatable(obj, TUpdateReq)
end

function TUpdateReq.new(PropertyName, Value)
    return TUpdateReq_from_obj({PropertyName = PropertyName, Value = Value})
end
---@param obj Frudata.UpdateReq
function TUpdateReq:init_from_obj(obj)
    self.PropertyName = obj.PropertyName
    self.Value = obj.Value
end

function TUpdateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateReq.group)
end

TUpdateReq.from_obj = TUpdateReq_from_obj

TUpdateReq.proto_property = {'PropertyName', 'Value'}

TUpdateReq.default = {{}, {}}

TUpdateReq.struct = {
    {name = 'PropertyName', is_array = true, struct = nil}, {name = 'Value', is_array = true, struct = nil}
}

function TUpdateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'PropertyName', self.PropertyName, 'string', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Value', self.Value, 'string', false, errs, need_convert)

    TUpdateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateReq.proto_property, errs, need_convert)
    return self
end

function TUpdateReq:unpack(_)
    return self.PropertyName, self.Value
end

Frudata.UpdateReq = TUpdateReq

Frudata.interface = mdb.register_interface('bmc.kepler.FrudataService.Frudata', {}, {
    Update = {'a{ss}asas', '', TUpdateReq, TUpdateRsp},
    SetSysProductName = {'a{ss}ys', '', TSetSysProductNameReq, TSetSysProductNameRsp},
    SetProductAssetTag = {'a{ss}ys', '', TSetProductAssetTagReq, TSetProductAssetTagRsp}
}, {})

return Frudata
